<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Projet extends Model
{
    use HasFactory;

    protected $table = 'projet';
    protected $primaryKey = 'id_projet';
    public $timestamps = false;

    protected $fillable = [
        'id_superviseur',
        'id_estimation_budget',
        'id_formulaire',
        'id_association',
        'id_demande',
        'nom_projet',
        'justification_realisation',
        'objectives',
        'public',
        'nombre_spectateur',
        'tranch_age_min',
        'tranch_age_max',
        'parties_realisation',
        'resultat_quantitatif',
        'resultat_qualitatif',
        'perspectives',
    ];

    public function superviseur()
    {
        return $this->belongsTo(Superviseur::class, 'id_superviseur', 'id_sup');
    }

    public function activites()
    {
        return $this->hasMany(ActivitePhase::class, 'id_projet', 'id_projet');
    }

        public function estimationBudget()
{
    return $this->hasMany(EstimationBudget::class, 'projet_id', 'id_projet');
}

    public function formulaire()
    {
        return $this->belongsTo(TypeFormulaire::class, 'id_formulaire', 'id_type');
    }

    public function association()
    {
        return $this->belongsTo(Association::class, 'id_association', 'id_association');
    }

    public function demande()
    {
        return $this->belongsTo(DemandeFinancement::class, 'id_demande', 'id_demande_fin');
    }

    public function documentsFinancement()
    {
        return $this->hasMany(DocumentsFinancementList::class, 'id_projet', 'id_projet');
    }

}
