<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvestissementSport extends Model
{
    use HasFactory;

    protected $table = 'investissement_sport';
    protected $primaryKey = 'id_inv_sport';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = true;

    protected $fillable = [
        'id_formulaire',
        'id_statut',
        'type_espace_s_id',
        'nbr_chambre',
        'nbr_stade',
        'nbr_stages_sportifs',
        'nbr_salles',
        'nbr_vestiaire',
        'nbr_salle_renforcement_musculaire',
        'capacite_accueil_foyer',
        'capacite_accueil_stade',
        'heberg_rest',
        'stage_activ',
        'espace_exercice',
        'activite_culturel',
        'manifestation_sportif',
        'autres',
        'autres_services',
        'nom_projet',
        'nature_projet_id',
        'nbr_emplois',
        'directeur_etabl_id',
        'remarques',
        'commentaire_motif',
		'code_postal',
		'delegation_id',
		'gouvernorat_id',
		'adresse_siege',
		'niveau_etude_user',
		'dernier_diplome_user',
		'experience_user',
		'id_user',
    ];

 public function gouvernorat()
    {
        return $this->belongsTo(Gouvernorat::class, 'gouvernorat_id', 'id_gouver');
    }

    public function delegation()
    {
        return $this->belongsTo(Delegation::class, 'delegation_id', 'id_delegation');
    }
	
    public function formulaire()
    {
        return $this->belongsTo(TypeFormulaire::class, 'id_formulaire', 'id_type');
    }

    public function statut()
    {
        return $this->belongsTo(TpStatut::class, 'id_statut', 'id_statut');
    }

    public function typeEspace()
    {
        return $this->belongsTo(TypeEspaceS::class, 'type_espace_s_id', 'id_type_es');
    }

    public function natureProjet()
    {
        return $this->belongsTo(NatureProjet::class, 'nature_projet_id', 'id_nature_p');
    }

    public function directeur()
    {
        return $this->belongsTo(DirecteurEtablissement::class, 'directeur_etabl_id', 'id_directeur');
    }

        public function investissements()
    {
        return $this->hasMany(Investissement::class, 'id_inv_sport', 'id_inv_sport');
    }
	
		public function debutActivite()
{
    return $this->hasOne(
        \App\Models\DebutActivite::class,
        'id_inv_sport_debut',
        'id_inv_sport'
    );
}

public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id');
    }
  public function statutHistories()
    {
        return $this->hasMany(\App\Models\ImmobilierStatutHistory::class, 'inv_sport_id', 'id_inv_sport')
                    ->orderBy('created_at', 'desc');
    }
}
