<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class FieldFile extends Model
{
    protected $table = 'field_files';
    protected $fillable = ['concours_ext_id','field_definition_id','file_path','original_name','mime_type','size'];
    public $timestamps = true;

    public function definition()
    {
        return $this->belongsTo(FieldDefinition::class, 'field_definition_id', 'id');
    }

    public function concours()
    {
        return $this->belongsTo(ConcoursExt::class, 'concours_ext_id', 'id');
    }
}
