<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FieldDefinition extends Model
{
    use HasFactory;

    protected $table = 'field_definitions';

    protected $fillable = [
        'key','label','input_type','options_json','value_type','is_visible','is_required','validation_json','sort_order'
    ];

    protected $casts = [
        'options_json' => 'array',
        'is_visible' => 'boolean',
        'is_required' => 'boolean',
    ];

    public function values()
    {
        return $this->hasMany(FieldValue::class, 'field_definition_id', 'id');
    }

    public function files()
    {
        return $this->hasMany(FieldFile::class, 'field_definition_id', 'id');
    }

public function options(): array
{
    if (empty($this->options_json)) {
        return [];
    }

    // If the cast already converted it to array, return it.
    if (is_array($this->options_json)) {
        return $this->options_json;
    }

    // Otherwise attempt to decode a JSON string defensively.
    $v = json_decode((string) $this->options_json, true);
    return is_array($v) ? $v : [];
}


    /**
     * Contests that use this field (pivot concours_field)
     */
    public function concours()
    {
        return $this->belongsToMany(Concours::class, 'concours_field', 'field_definition_id', 'concours_id')
                    ->withTimestamps();
    }
}
