<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContributeurProjet extends Model
{
    use HasFactory;

    protected $table = 'contributeurs_projet';
    protected $primaryKey = 'id_contr';
    public $timestamps = false;

    protected $fillable = [
        'id_estimation_budget',
        'nom',
        'montant',
        'pourcentage',
    ];

    public function estimationBudget()
    {
        return $this->belongsTo(EstimationBudget::class, 'id_estimation_budget', 'id_estimation');
    }
}
