<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ConcoursExt extends Model
{
    protected $table = 'concours_ext';
    protected $fillable = ['nom','prenom','cin','date_naissance','tel','email','adresse','gouvernorat','code_postale','etat'];

    public function fieldValues()
    {
        return $this->hasMany(FieldValue::class, 'concours_ext_id', 'id');
    }

    public function files()
    {
        return $this->hasMany(FieldFile::class, 'concours_ext_id', 'id');
    }

    // ADD THIS:
    public function optional()
    {
        return $this->hasOne(ConcoursExtOptional::class, 'concours_ext_id', 'id');
    }
}
