<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BuilderContenu extends Model
{
    use HasFactory;

    protected $table = 'builder_contenu';
    protected $primaryKey = 'id_builder_cont';

    protected $fillable = [
        'id_builder',
        'nature',
        'image',
        'url_video',
        'text_ar',
        'text_fr',
        'text_en',
        'col',
    ];

    // Relation : ce contenu appartient à un builder
    public function builder()
    {
        return $this->belongsTo(Builder::class, 'id_builder', 'id_builder');
    }
}
