<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class StatutDemandeMail extends Mailable
{
    use Queueable, SerializesModels;

    public $utilisateur;
    public $numeroDossier;
    public $messageStatus; // HTML
    public $type;
    public $comment;

    public function __construct($utilisateur, $numeroDossier, $messageStatus, $type = 'status_changed', $comment = null)
    {
        $this->utilisateur = $utilisateur;
        $this->numeroDossier = $numeroDossier;
        $this->messageStatus = $messageStatus;
        $this->type = $type;
        $this->comment = $comment;
    }

    public function build()
    {
        $subjects = [
            'accepted'  => 'تم تحديث حالة ملفك — مقبول',
            'rejected'  => 'تم تحديث حالة ملفك — مرفوض',
            'incomplete'=> 'تم تحديث حالة ملفك — غير مكتمل',
            'deferred'  => 'تم إرجاء قرار طلبك - بحاجة للمداولة',
            'status_changed' => 'تحديث حالة الملف'
        ];

        $subject = $subjects[$this->type] ?? $subjects['status_changed'];

        return $this->subject($subject)
                    ->view('emails.demande.status')
                    ->with([
                        'utilisateur' => $this->utilisateur,
                        'numeroDossier'=> $this->numeroDossier,
                        'messageStatus'=> $this->messageStatus,
                        'type'         => $this->type,
                        'comment'      => $this->comment,
                    ]);
    }
}
