<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\DocumentsFinancementList;

class Statut2DocumentChanged extends Mailable
{
    use Queueable, SerializesModels;

    public DocumentsFinancementList $docList;
    public string $type;   // 'accepted'|'rejected'|'incomplete'|'deferred'|'status_changed'
    public array $params;  // optional: reason, missing, note, date, comment, reference
    public $recipientUser;

    public function __construct(DocumentsFinancementList $docList, string $type = 'status_changed', array $params = [], $recipientUser = null)
    {
        $this->docList = $docList;
        $this->type = $type;
        $this->params = $params;
        $this->recipientUser = $recipientUser;
    }

    public function build()
    {
        $subjects = [
            'accepted'       => 'تمت الموافقة على ملفك للتمويل العمومي',
            'rejected'       => 'تم رفض ملفك للتمويل العمومي',
            'incomplete'     => 'ملفك غير مكتمل - مطلوب مستندات أو معلومات إضافية',
            'deferred'       => 'تأجيل معالجة ملفك للتمويل العمومي',
            'status_changed' => 'تحديث حالة ملف التمويل العمومي'
        ];

        $subject = $subjects[$this->type] ?? $subjects['status_changed'];

        return $this->subject($subject)
                    ->view('emails.statut2_document_changed')
                    ->with([
                        'docList' => $this->docList,
                        'type'    => $this->type,
                        'params'  => $this->params,
                        'user'    => $this->recipientUser ?? $this->docList->user,
                    ]);
    }
}
