<?php

// app/Mail/ReservationRejectedMail.php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Carbon\Carbon;
class ReservationRejectedMail extends Mailable
{
    use Queueable;

    public $reservation;
    public $motif;
    public $utilisateurName;
    public $numeroDossier;
    public $dateSent;
    public $messageHtml;

    public function __construct($reservation, $motif)
    {
        $this->reservation = $reservation;
        $this->motif = $motif;
        $this->utilisateurName = optional($reservation->user)->nom_prenom ?? 'المستخدم';
        $this->numeroDossier = $reservation->formatted_dossier ?? ($reservation->id ?? '00-'.$reservation->id.'-unknown-'.now()->format('Y'));
        $this->dateSent = now()->format('Y-m-d');
        $this->messageHtml = "<p>نأسف لإبلاغكم بأن طلب الحجز الخاص بكم قد تم رفضه.</p>
                              <p><strong>السبب:</strong> {$this->motif}</p>";
    }

    public function build()
    {
        return $this->subject('تم رفض الحجز')
                    ->view('emails.reservation.status')
                    ->with([
                        'utilisateur_name' => $this->utilisateurName,
                        'numero_dossier' => $this->numeroDossier,
                        'message_html' => $this->messageHtml,
                        'date_sent' => $this->dateSent,
                        'logo_url' => asset('logo.png'),
                    ]);
    }
}

