<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class Jeunesse2StatutMail extends Mailable
{
    use Queueable, SerializesModels;

    public $type;
    public $user;
    public $motif;

    public function __construct($type, $user, $motif = null)
    {
        $this->type = $type;
        $this->user = $user;
        $this->motif = $motif;
    }

    public function build()
    {
        $subjectMap = [
            'accepte'   => 'تم قبول مشروعك بالإستثمار في الأنشطة الخاصة بالشباب و الأطفال',
            'refuse'    => 'تم رفض مشروعك بالإستثمار في الأنشطة الخاصة بالشباب و الأطفال',
            'incomplet' => 'طلبك يحتاج إلى استكمال - مشروع الإستثمار للشباب و الأطفال',
            'deferre'   => 'تم إرجاء قرار طلبك - مشروع الإستثمار للشباب و الأطفال',
        ];

        $subject = $subjectMap[$this->type] ?? 'تحديث حالة مشروعك';

        return $this->subject($subject)
                    ->view('emails.jeunesse.statut2'); // view receives $type, $user, $motif
    }
}


