<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class JeuneEnfantStatutMail extends Mailable
{
    use Queueable, SerializesModels;

    public $type;
    public $user;
    public $motif;

    /**
     * @param string $type  one of: 'accepte', 'refuse', 'incomplete', 'deferred'
     * @param \App\Models\User $user
     * @param string|null $motif
     */
    public function __construct($type, $user, $motif = null)
    {
        $this->type  = $type;
        $this->user  = $user;
        $this->motif = $motif;
    }

    public function build()
    {
        // choose subject based on type
        switch ($this->type) {
            case 'accepte':
                $subject = 'تم قبول مشروعك في قطاع الشباب و الأطفال';
                break;
            case 'refuse':
                $subject = 'تم رفض مشروعك في قطاع الشباب و الأطفال';
                break;
            case 'incomplete':
                $subject = 'ملفك غير مكتمل — يرجى استكمال الوثائق';
                break;
            case 'deferred':
                $subject = 'تم تأجيل قرار مشروعك';
                break;
            default:
                $subject = 'تغيير حالة طلبك';
                break;
        }

        // pass data to the view (you can access $type, $user, $motif in the view)
        return $this->subject($subject)
                    ->view('emails.jeune_enfant.statut')
                    ->with([
                        'type'  => $this->type,
                        'user'  => $this->user,
                        'motif' => $this->motif,
                    ]);
    }
}
