<?php

namespace App\Mail;

use App\Models\Utilisateur;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CompteSetMdpMail extends Mailable
{
    use Queueable, SerializesModels;

    public $utilisateur;
public $resetLink;

    public function __construct(Utilisateur $utilisateur, string $resetLink)
    {
        $this->utilisateur = $utilisateur;
        $this->resetLink = $resetLink;
    }

    public function build()
    {
        return $this->subject('إعداد كلمة المرور الخاصة بك')
                    ->markdown('emails.utilisateurs.compte_set_mdp')->with(['resetLink' => $this->resetLink]);
    }
}


