<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;

class Authenticate extends Middleware
{
    protected function redirectTo($request): ?string
    {
        if (!$request->expectsJson()) {
            // Si la requête est pour l’espace admin
            if ($request->is('admin/*') || $request->is('admin')) {
                return route('login');
            }

            // Sinon, route par défaut (utile si tu ajoutes une auth utilisateur classique)
            return route('login');
        }

        return null;
    }
}
