<?php

namespace App\Http\Controllers;

use App\Models\Utilisateur;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use App\Mail\CompteActiveMail;
use App\Mail\CompteSetMdpMail;
use App\Models\Role;
use App\Models\Auberge;
use App\Models\Gouvernorat;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class UtilisateurController extends Controller
{
    public function index(Request $request)
{
    $query = Utilisateur::with('roles')
        ->whereHas('roles');

    if ($request->filled('cin')) {
        $query->where('cin', 'LIKE', '%' . $request->cin . '%');
    }

    if ($request->filled('role_id')) {
        $query->whereHas('roles', function($q) use ($request) {
            $q->where('id_roles', $request->role_id);
        });
    }

    $utilisateurs = $query->orderBy('id', 'desc')->paginate(10)->withQueryString();

    $roles = Role::all();

    return view('backoffice.role-permission.user.index', compact('utilisateurs', 'roles'));
}


    public function create()
    {
        $roles = Role::all(); 		
		$auberges = Auberge::all();
		$gouvernorat = Gouvernorat::all();
        return view('backoffice.role-permission.user.create', compact('roles','gouvernorat','auberges'));
    }

	public function store(Request $request)	{		
		$data = $request->validate([			
		'nom_prenom' => 'required|string|max:100',			
	/*	'cin' => 'nullable|string|size:8|unique:utilisateur,cin', */	
		'email' => 'required|email|max:100|unique:utilisateur,email',			
		'mdp' => 'nullable|string|min:6',		
       /* 'tel' => 'required|string|max:12',			
		'adresse' => 'required|string|max:100',		*/
		'role_id' => 'required|exists:roles,id_roles',	
		'auberge_id' => $request->role_id == 7 ? 'required|exists:auberge,id' : 'nullable',	
		'id_gouv' => $request->role_id == 8 ? 'required|exists:tp_gouvernorat,id_gouver' : 'nullable',
		], [			
		'nom_prenom.required' => ' الرجاء إدخال الاسم واللقب',	
		/* 'cin.size' => ' رقم بطاقة التعريف يجب أن يحتوي على 8 أرقام',	
		'cin.unique' => ' رقم بطاقة التعريف مستعمل من قبل',		*/
		'email.required' => ' الرجاء إدخال البريد الإلكتروني',	
		'email.email' => ' الرجاء إدخال بريد إلكتروني صحيح',	
		'email.unique' => ' هذا البريد الإلكتروني مستخدم بالفعل',	
		'mdp.min' => 'كلمة المرور يجب أن تحتوي على الأقل 6 حروف',	
	/*	'tel.required' => ' الرجاء إدخال رقم الهاتف',			
		'adresse.required' => ' الرجاء إدخال العنوان',		*/	
		'role_id.required' => ' الرجاء اختيار نوع المستخدم',	
		'role_id.exists' => 'نوع المستخدم المختار غير صالح',		
		'auberge_id.required' => ' الرجاء اختيار المركز',		
		'auberge_id.exists' => 'المركز المختار غير موجود',	
		'id_gouv.required' => 'الرجاء اختيار الولاية',		
		]);		
		if (!empty($data['mdp'])) {		
		$data['mdp'] = Hash::make($data['mdp']);	
		} else {		
		unset($data['mdp']);	
		}				
		/*$utilisateur = Utilisateur::create($data);	
		$utilisateur->roles()->attach($request->role_id);
		if ($request->role_id == 7 && $request->filled('auberge_id')) {	
			$utilisateur->auberge_id = $request->auberge_id;		
			$utilisateur->save();		
		}*/
		$utilisateur = Utilisateur::create($data);
		$utilisateur->roles()->attach($request->role_id);
		if ($request->role_id == 7 && $request->filled('auberge_id')) {
			$utilisateur->auberge_id = $request->auberge_id;
		}
		if ($request->role_id == 8 && $request->filled('id_gouv')) {
			$utilisateur->id_gouv = $request->id_gouv;
		}
		$utilisateur->save();
		return redirect()->route('utilisateurs.index')						
			->with('ok', 'تم إنشاء المستخدم بنجاح.');	
	}


    public function show(Utilisateur $utilisateur)
    {
        $roles = Role::all();
		$auberges = Auberge::all();
		$gouvernorat = Gouvernorat::all();
        return view('backoffice.role-permission.user.show', compact('utilisateur', 'gouvernorat','roles','auberges'));
    }

    public function edit(Utilisateur $utilisateur)	{		
		$roles = Role::all();		
		$auberges = Auberge::all();
		$gouvernorat = Gouvernorat::all();	
		return view('backoffice.role-permission.user.edit', compact('utilisateur', 'gouvernorat','roles', 'auberges'));	
	}	
	
	public function update(Request $request, Utilisateur $utilisateur)	{		
		$data = $request->validate([			
		'nom_prenom' => 'required|string|max:100',			
		/* 'cin' => 'nullable|string|size:8|unique:utilisateur,cin,' . $utilisateur->id,	*/		
		'email' => 'required|email|max:100|unique:utilisateur,email,' . $utilisateur->id,			
		'mdp' => 'nullable|string|min:6',			
		// 'tel' => 'required|string|max:12',			
	/*	'adresse' => 'required|string|max:100',			'role_id' => 'required|exists:roles,id_roles',	*/		
		'auberge_id' => $request->role_id == 7 ? 'required|exists:auberge,id' : 'nullable',	
		'id_gouv' => $request->role_id == 8 ? 'required|exists:tp_gouvernorat,id_gouver' : 'nullable',	
		], [			
		'nom_prenom.required' => ' الرجاء إدخال الاسم واللقب',			
		/* 'cin.size' => ' رقم بطاقة التعريف يجب أن يحتوي على 8 أرقام',		
		'cin.unique' => ' رقم بطاقة التعريف مستعمل من قبل',		*/	
		'email.required' => ' الرجاء إدخال البريد الإلكتروني',			
		'email.email' => ' الرجاء إدخال بريد إلكتروني صحيح',			
		'email.unique' => ' هذا البريد الإلكتروني مستخدم بالفعل',		
		'mdp.min' => 'كلمة المرور يجب أن تحتوي على الأقل 6 حروف',		
		/* 'tel.required' => ' الرجاء إدخال رقم الهاتف',			
		'adresse.required' => ' الرجاء إدخال العنوان',		*/	
		'role_id.required' => ' الرجاء اختيار نوع المستخدم',	
		'role_id.exists' => 'نوع المستخدم المختار غير صالح',	
		'auberge_id.required' => ' الرجاء اختيار المركز',		
		'auberge_id.exists' => 'المركز المختار غير موجود',	
		'id_gouv.required' => ' الرجاء اختيار الولاية',	
		]);		
		if (!empty($data['mdp'])) {			
		$data['mdp'] = Hash::make($data['mdp']);	
		} else {			
		unset($data['mdp']);	
		}				
		$utilisateur->update($data);		
		$utilisateur->roles()->sync([$request->role_id]);
		
		/*if ($request->role_id == 7 && $request->filled('auberge_id')) {			
		$utilisateur->auberge_id = $request->auberge_id;		
		} else {			
		$utilisateur->auberge_id = null;		
		}*/	
		
		if ($request->role_id == 7 && $request->filled('auberge_id')) {
			$utilisateur->auberge_id = $request->auberge_id;
			$utilisateur->id_gouv = null;
		}
		if ($request->role_id == 8) {
			$utilisateur->id_gouv = $request->id_gouv;
			$utilisateur->auberge_id = null;
		}
		if (!in_array($request->role_id, [7, 8])) {
			$utilisateur->auberge_id = null;
			$utilisateur->id_gouv = null;
		}
		$utilisateur->save();
		return redirect()->route('utilisateurs.index')		
		->with('ok', 'تم تعديل المستخدم بنجاح.');	
	}
   

    public function destroy(Utilisateur $utilisateur)
    {
        $utilisateur->delete();
        return redirect()->route('utilisateurs.index')->with('ok', 'تم حذف المستخدم بنجاح.');
    }

    public function toggleActivation(Request $request, Utilisateur $utilisateur)
    {
        $etaitInactif = !$utilisateur->est_active;
        $utilisateur->est_active = !$utilisateur->est_active;
        $utilisateur->save();

        if ($etaitInactif) {
            $roleIds = $utilisateur->roles->pluck('id_roles')->toArray();
            if (in_array(2, $roleIds) || in_array(3, $roleIds)) {
                Mail::to($utilisateur->email)->send(new CompteActiveMail($utilisateur));
            } else {
                
$token = Str::random(60);

DB::table('password_resets')->updateOrInsert(
    ['email' => $utilisateur->email],
    [
        'email' => $utilisateur->email,
        'token' => Hash::make($token),
        'created_at' => Carbon::now(),
    ]
);

$resetLink = route('admin.password.reset', $utilisateur->id) . '?token=' . $token . '&email=' . urlencode($utilisateur->email);

Mail::to($utilisateur->email)->send(new CompteSetMdpMail($utilisateur, $resetLink));

            }
        }

        return back()->with('ok', $utilisateur->est_active ? 'تم تفعيل الحساب.' : 'تم تعطيل الحساب.');
    }


    public function profil(Utilisateur $utilisateur)
    {
        return view('backoffice.role-permission.user.profile', compact('utilisateur'));
    }
        
    public function editProfil()
    {
        $utilisateur = auth()->user();
        return view('backoffice.role-permission.user.editProfile', compact('utilisateur'));
    }

  public function updateProfil(Request $request, Utilisateur $utilisateur)
{
    $utilisateur = auth()->user();

    $data = $request->validate([
        'nom_prenom' => 'required|string|max:100',
     //   'cin'        => 'nullable|string|size:8|unique:utilisateur,cin,'.$utilisateur->id,
        'email'      => 'required|email|max:100|unique:utilisateur,email,'.$utilisateur->id,
        'tel'        => 'nullable|string|max:12',
     //   'adresse'    => 'nullable|string|max:100',
        // password is optional; if provided it must be confirmed and meet complexity
        'password'   => [
            'nullable',
            'string',
            'min:8',
            'confirmed',
            // at least one lowercase, one uppercase, one digit and one special character
            'regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_]).+$/'
        ],
    ], [
        // optional: custom error message for regex
        'password.regex' => 'كلمة المرور يجب أن تحتوي على حرف كبير واحد على الأقل، حرف صغير واحد على الأقل، رقم واحد على الأقل و رمز خاص.',
    ]);

    // If password provided, hash it before saving
    if (isset($data['password']) && $data['password'] !== null && $data['password'] !== '') {
        $data['password'] = Hash::make($data['password']);
    } else {
        // ensure password isn't updated to null/empty
        unset($data['password']);
    }

    $utilisateur->update($data);

    return redirect()->route('utilisateurs.editprofil')->with('ok', 'تم تحديث الملف الشخصي بنجاح.');
}
}