<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Newsletter;
use Illuminate\Validation\Rule;

class NewsletterController extends Controller
{
    /**
     * Store subscriber email from footer
     */
    public function subscribe(Request $request)
    {
        $data = $request->validate([
            'email' => 'required|email|max:255',
        ], [
            'email.required' => 'الرجاء إدخال البريد الإلكتروني.',
            'email.email'    => 'البريد الإلكتروني غير صالح.',
        ]);

        $email = trim(strtolower($data['email']));

        $exists = Newsletter::where('email', $email)->exists();

        if ($exists) {
            return back()->with('newsletter_info', 'هذا البريد مسجل مسبقًا في النشرة الإخبارية.');
        }

        Newsletter::create(['email' => $email]);

        return back()->with('newsletter_success', 'تم تسجيل البريد في النشرة الإخبارية. شكرًا لك.');
    }

    /**
     * Admin index: show subscribers (protected by your auth middleware in routes)
     */
    /*public function index(Request $request)
    {
        $q = (string) $request->input('q', '');

        $query = Newsletter::query();

        if ($q !== '') {
            $query->where('email', 'like', "%{$q}%");
        }

        $subscribers = $query->orderBy('created_at', 'desc')->paginate(20)->withQueryString();

        return view('backoffice.newsletter_contact.newsletter_index', compact('subscribers', 'q'));
    }*/
	
	public function index(Request $request)
{
    // Récupérer la recherche et nettoyer les espaces
    $q = trim((string) $request->input('q', ''));

    // Bloquer les recherches vides ou ne contenant que % ou espaces
    if ($q === '' || preg_match('/^[\s%]+$/', $q)) {
        $q = null;
    }

    $query = Newsletter::query();

    if ($q) {
        $query->where(function($query) use ($q) {
            // Recherche par email
            $query->where('email', 'like', "%{$q}%");

            // Recherche par date si format YYYY-MM-DD
            if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $q)) {
                $query->orWhereDate('created_at', $q);
            }
        });
    }

    $subscribers = $query->orderBy('created_at', 'desc')
                         ->paginate(20)
                         ->withQueryString();

    return view('backoffice.newsletter_contact.newsletter_index', compact('subscribers', 'q'));
}


    /**
     * Show edit form.
     */
    public function edit(Newsletter $newsletter)
    {
        return view('backoffice.newsletter_contact.edit', compact('newsletter'));
    }

    /**
     * Update subscriber (only email).
     */
    public function update(Request $request, Newsletter $newsletter)
    {
        $data = $request->validate([
            'email' => [
                'required','email','max:255',
                Rule::unique('newsletters', 'email')->ignore($newsletter->id),
            ],
        ], [
            'email.required' => 'الرجاء إدخال البريد الإلكتروني.',
            'email.email'    => 'البريد الإلكتروني غير صالح.',
            'email.unique'   => 'هذا البريد الإلكتروني مستخدم بالفعل.',
        ]);

        $newsletter->email = trim(strtolower($data['email']));
        $newsletter->save();

        return redirect()->route('newsletters.index')->with('ok', 'تم تعديل المشترك بنجاح.');
    }

    /**
     * Delete subscriber.
     */
    public function destroy(Newsletter $newsletter)
    {
        $newsletter->delete();
        return redirect()->route('newsletters.index')->with('ok', 'تم حذف المشترك بنجاح.');
    }
}
