<?php

namespace App\Http\Controllers\ManifestationSport;

use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\Utilisateur;

use App\Models\DemandeManifestation;
use App\Models\TpAttachement;
use App\Models\TpTypeMembre;
use App\Models\TpDomaineEducation;
use App\Models\TpTypeEtrangere;
use App\Models\TeamsAssociation;
use App\Models\OrganismeNonSportif;
use App\Models\EvenementSportif;
use App\Models\MembreOrgInvite;
use App\Models\AssocParticipante;
use App\Models\SportifParticipant;
use App\Models\Etrangere;
use App\Models\TypeFormulaire;
use App\Models\Gouvernorat;
use App\Models\Delegation;
use App\Models\TpStatut;
use App\Models\AthleteIndividuel;
use App\Models\Attachement;
use App\Models\Identite_personnel;
use Illuminate\Support\Facades\Mail;
use App\Mail\StatutDemande2Mail;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Mpdf\Mpdf;
use App\Models\ImmobilierStatutHistory;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class ManifestationSport2Controller extends Controller
{
    public function index(Request $request)
    {
        $typesIdentite = Identite_personnel::all();

        $query = DemandeManifestation::with([
            'utilisateur',
            'organismeNonSportif',
            'evenementSportifs.gouvernorat',
            'evenementSportifs.delegation',
            'statut'
        ])
        ->where('type_formulaire_id', 13) 
        ->orderByDesc('id_demande');

        if ($request->filled('date')) {
            $query->whereDate('created_at', $request->date);
        }

        if ($request->filled('type_identite') && $request->filled('cin')) {
            $query->whereHas('utilisateur', function($q) use ($request) {
                $q->where('type_identite_id', $request->type_identite)
                ->where('num_cin', $request->cin);
            });
        }

        // Pagination
        $demandes = $query->paginate(10);

        // Calcul des num_dossier et autres infos pour la vue
        $rows = $demandes->map(function($d) {
            $idPad = str_pad($d->id_demande, 3, '0', STR_PAD_LEFT);

            $cin = $d->utilisateur->num_cin ?? $d->utilisateur->cin ?? null;
            $cinDigits = $cin ? preg_replace('/\D+/', '', $cin) : '';
            $cinPad = $cinDigits ? str_pad($cinDigits, 9, '0', STR_PAD_LEFT) : '000000000';

            $year = $d->created_at ? $d->created_at->format('Y') : now()->format('Y');
            $num_dossier = "{$idPad}-{$cinPad}-{$year}";

            // Récupérer le premier événement sportif (s'il existe)
            $even = $d->evenementSportifs->first() ?? null;
            $nom_evenement = $even->nom_even ?? null;
            $date_even = $even->date ?? null;
            $heure_even = $even->heure ?? null;

            $gouvernorat = $even?->gouvernorat?->name ?? $even?->gouvernorat?->gouvernorat ?? null;
            $delegation  = $even?->delegation?->name ?? $even?->delegation?->delegation ?? null;

            $nom_organisme = $d->organismeNonSportif ? ($d->organismeNonSportif->nom ?? $d->organismeNonSportif->raison_sociale ?? null) : null;

            return (object) [
                'id_demande' => $d->id_demande,
                'num_dossier' => $num_dossier,
                'nom_organisme' => $nom_organisme,
                'nom_evenement' => $nom_evenement,
                'date_even' => $date_even ? \Carbon\Carbon::parse($date_even)->format('Y-m-d') : null,
                'heure_even' => $heure_even ? \Carbon\Carbon::parse($heure_even)->format('H:i') : null,
                'gouvernorat' => $gouvernorat,
                'delegation' => $delegation,
                'statut' => $d->statut,
                'raw' => $d,
            ];
        });

        return view('backoffice.manifestation_sport.demande_inter.index', compact('demandes', 'rows', 'typesIdentite'));
    }

public function pdf($id)
{
    ini_set('pcre.backtrack_limit', '10000000');
    ini_set('pcre.recursion_limit', '10000000');
    ini_set('memory_limit', '512M');

    $demande = DemandeManifestation::with([
        'organismeNonSportif',
        'evenementSportifs',
        'evenementSportifs.membres',
        'evenementSportifs.invites',
        'evenementSportifs.assocParticipantes',
        'evenementSportifs.athletesIndividuels',
        'evenementSportifs.sportifs',
        'attachements'
    ])->findOrFail($id);

    $org = $demande->organismeNonSportif;
    $formulaire   = TypeFormulaire::find(13);
        $attachments  = TpAttachement::orderBy('type_ar', 'asc')->get();
        $formulaire2  = TypeFormulaire::find(14);
        $formulaire3  = TypeFormulaire::find(15);
        $gouvernorats = Gouvernorat::all();
        $delegations  = Delegation::all();
        $formulaire4  = TypeFormulaire::find(16);
        $type_membre  = TpTypeMembre::all();
        $statut       = TpStatut::all();
        $formulaire5  = TypeFormulaire::find(17);
        $formulaire6  = TypeFormulaire::find(23);
        $formulaire7  = TypeFormulaire::find(18);
        $formulaire8  = TypeFormulaire::find(19);
        $formulaire9  = TypeFormulaire::find(20);

    // Définir la langue et la direction
    $lang = 'ar';
$direction = 'rtl';

    $html = view(
        'backoffice.manifestation_sport.demande_inter.pdf',
        compact(
            'demande','formulaire','attachments','formulaire2','formulaire3',
            'gouvernorats','delegations','type_membre','statut','formulaire4',
            'formulaire5','formulaire6','formulaire7','formulaire9','formulaire8','org',
            'lang','direction' // <-- ajouter ici
        )
    )->render();

    $mpdf = new Mpdf([
        'mode'              => 'utf-8',
        'format'            => 'A4',
        'default_font'      => 'dejavusans',
        'directionality'    => $direction,
        'autoScriptToLang'  => true,
        'autoLangToFont'    => true,
        'tempDir'           => storage_path('app/mpdf'),
    ]);

    $mpdf->setFooter('{PAGENO} / {nbpg}');
    $mpdf->WriteHTML($html);

    return response(
        $mpdf->Output('demande_manifestation_'.$id.'.pdf', 'S'),
        200,
        [
            'Content-Type'        => 'application/pdf',
            'Content-Disposition' => 'inline; filename="demande_manifestation_'.$id.'.pdf"',
        ]
    );
}



	/*public function showDecision($id)
{
    $demande = DemandeManifestation::findOrFail($id);

    // Vérifier si le fichier existe
    if (empty($demande->file)) {
        abort(404, 'Aucun fichier disponible');
    }

    // Détection MIME depuis le BLOB
    $finfo = new \finfo(FILEINFO_MIME_TYPE);
    $mimeType = $finfo->buffer($demande->file);

    return response($demande->file, 200)
        ->header('Content-Type', $mimeType)
        ->header('Content-Disposition', 'inline');
}*/







//last
/*public function showDecision($id)
{
    $demande = DemandeManifestation::findOrFail($id);

    // Vérifier si le fichier existe
    if (empty($demande->file)) {
        abort(404, 'Aucun fichier disponible');
    }

    // Si le fichier est stocké comme chemin (string), lire depuis le système de fichiers
    if (is_string($demande->file) && file_exists($demande->file)) {
        $content = file_get_contents($demande->file);
        $mimeType = mime_content_type($demande->file);
        
        return response($content, 200)
            ->header('Content-Type', $mimeType)
            ->header('Content-Disposition', 'inline');
    }
    
    // Si c'est un BLOB (ancien système)
    $finfo = new \finfo(FILEINFO_MIME_TYPE);
    $mimeType = $finfo->buffer($demande->file);

    return response($demande->file, 200)
        ->header('Content-Type', $mimeType)
        ->header('Content-Disposition', 'inline');
}*/



private function filteredQuery(Request $request)
    {
        $query = DemandeManifestation::with([
            'utilisateur',
            'organismeNonSportif',
            'evenementSportifs.gouvernorat',
            'evenementSportifs.delegation',
            'statut'
        ])
        ->where('type_formulaire_id', 13) // 🔥 internationales
        ->orderByDesc('id_demande');

        if ($request->filled('date')) {
            $query->whereDate('created_at', $request->date);
        }

        if ($request->filled('type_identite') && $request->filled('cin')) {
            $query->whereHas('utilisateur', function ($q) use ($request) {
                $q->where('type_identite_id', $request->type_identite)
                  ->where('num_cin', $request->cin);
            });
        }

        return $query;
    }

    /* ===============================
     * 🔹 EXPORT EXCEL
     * =============================== */
    public function exportExcel(Request $request)
{
    $demandes = $this->filteredQuery($request)->get();

    $rows = $demandes->map(function ($d) {

        // ===============================
        // 🔹 رقم الملف
        // ===============================
        $idPad = str_pad($d->id_demande, 3, '0', STR_PAD_LEFT);

        $cin = $d->utilisateur->num_cin ?? $d->utilisateur->cin ?? null;
        $cinDigits = $cin ? preg_replace('/\D+/', '', $cin) : '';
        $cinPad = $cinDigits
            ? str_pad($cinDigits, 9, '0', STR_PAD_LEFT)
            : '000000000';

        $year = $d->created_at
            ? $d->created_at->format('Y')
            : now()->format('Y');

        $num_dossier = "{$idPad}-{$cinPad}-{$year}";

        // ===============================
        // 🔹 الحدث الرياضي
        // ===============================
        $even = $d->evenementSportifs->first();

        // ===============================
        // 🔹 الولاية والبلدية (✔ تصحيح المشكل)
        // ===============================
        $gouvernorat = $even?->gouvernorat?->nom_ar
            ?? $even?->gouvernorat?->name
            ?? $even?->gouvernorat?->gouvernorat
            ?? '-';

        $delegation = $even?->delegation?->nom_ar
            ?? $even?->delegation?->name
            ?? $even?->delegation?->delegation
            ?? '-';

        // ===============================
        // 🔹 سطر Excel
        // ===============================
        return [
            $num_dossier,
            $d->organismeNonSportif->nom
                ?? $d->organismeNonSportif->raison_sociale
                ?? '-',
            $even?->nom_even ?? '-',
            $even?->date ?? '-',
            $even?->heure ?? '-',
            $gouvernorat,
            $delegation,
            $d->statut?->statut_ar ?? 'في الانتظار',
        ];
    });

    // ===============================
    // 🔹 إنشاء ملف Excel
    // ===============================
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setRightToLeft(true);

    // 🔹 العناوين
    $sheet->fromArray([
        'رقم الملف',
        'اسم الهيكل',
        'اسم التظاهرة',
        'التاريخ',
        'الساعة',
        'الولاية',
        'البلدية',
        'الحالة',
    ], null, 'A1');

    $sheet->getStyle('A1:H1')->getFont()->setBold(true);

    // 🔹 البيانات
    $rowNum = 2;
    foreach ($rows as $row) {
        $sheet->fromArray($row, null, 'A' . $rowNum++);
    }

    // 🔹 ضبط العرض
    foreach (range('A', 'H') as $col) {
        $sheet->getColumnDimension($col)->setAutoSize(true);
    }

    // ===============================
    // 🔹 تحميل الملف
    // ===============================
    $writer = new Xlsx($spreadsheet);

    return response()->streamDownload(
        fn () => $writer->save('php://output'),
        'manifestations_internationales.xlsx'
    );
}


    /* ===============================
     * 🔹 EXPORT PDF
     * =============================== */
    public function exportPdf(Request $request)
{
    $demandes = $this->filteredQuery($request)->get();

    $rows = $demandes->map(function ($d) {

        // ===============================
        // 🔹 رقم الملف
        // ===============================
        $idPad = str_pad($d->id_demande, 3, '0', STR_PAD_LEFT);

        $cin = $d->utilisateur->num_cin ?? $d->utilisateur->cin ?? null;
        $cinDigits = $cin ? preg_replace('/\D+/', '', $cin) : '';
        $cinPad = $cinDigits
            ? str_pad($cinDigits, 9, '0', STR_PAD_LEFT)
            : '000000000';

        $year = $d->created_at
            ? $d->created_at->format('Y')
            : now()->format('Y');

        $num_dossier = "{$idPad}-{$cinPad}-{$year}";

        // ===============================
        // 🔹 الحدث الرياضي
        // ===============================
        $even = $d->evenementSportifs->first();

        // ===============================
        // 🔹 الولاية والبلدية (✔ تصحيح)
        // ===============================
        $gouvernorat = $even?->gouvernorat?->nom_ar
            ?? $even?->gouvernorat?->name
            ?? $even?->gouvernorat?->gouvernorat
            ?? '-';

        $delegation = $even?->delegation?->nom_ar
            ?? $even?->delegation?->name
            ?? $even?->delegation?->delegation
            ?? '-';

        // ===============================
        // 🔹 سطر PDF
        // ===============================
        return (object)[
            'num_dossier'   => $num_dossier,
            'nom_organisme' => $d->organismeNonSportif->nom
                ?? $d->organismeNonSportif->raison_sociale
                ?? '-',
            'nom_evenement' => $even?->nom_even ?? '-',
            'date_even'     => $even?->date ?? '-',
            'heure_even'    => $even?->heure ?? '-',
            'gouvernorat'   => $gouvernorat,
            'delegation'    => $delegation,
            'statut'        => $d->statut,
        ];
    });

    // ===============================
    // 🔹 Vue PDF
    // ===============================
    $html = view(
        'backoffice.manifestation_sport.demande_inter.exports.manifestation2_pdf',
        compact('rows')
    )->render();

    // ===============================
    // 🔹 mPDF
    // ===============================
    $mpdf = new \Mpdf\Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4-L',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
    ]);

    $mpdf->WriteHTML($html);

    return response(
        $mpdf->Output('manifestations_internationales.pdf', 'S')
    )->header('Content-Type', 'application/pdf');
}




    public function create()
    {
        $formulaire   = TypeFormulaire::find(13);
        $attachments  = TpAttachement::orderBy('type_ar', 'asc')->get();
        $formulaire2  = TypeFormulaire::find(14);
        $formulaire3  = TypeFormulaire::find(15);
        $gouvernorats = Gouvernorat::all();
        $delegations  = Delegation::all();
        $formulaire4  = TypeFormulaire::find(16);
        $type_membre  = TpTypeMembre::all();
        $statut       = TpStatut::all();
        $formulaire5  = TypeFormulaire::find(17);
        $formulaire6  = TypeFormulaire::find(23);
        $formulaire7  = TypeFormulaire::find(18);
        $formulaire8  = TypeFormulaire::find(19);
        $formulaire9  = TypeFormulaire::find(20);

        return view('backoffice.manifestation_sport.demande_inter.create', compact('formulaire', 'attachments','formulaire2','formulaire3',
            'gouvernorats','delegations','type_membre','statut','formulaire4','formulaire5','formulaire6','formulaire7',
            'formulaire8','formulaire9'
        ));
    }

    public function store(Request $request)
    {
        $request->validate([
            //demande
            'sujet' => 'nullable|string|max:255',
            'sport_type' => 'nullable|string|max:255',
            'event_name' => 'nullable|string|max:255',
            'objectif' => 'nullable|string',
            'commentaire_motif' => 'nullable|string',
            'type_formulaire_id' => 'required|integer',
            'user_id' => 'required|integer',
            'id_type' => 'nullable|integer',
            'organisme_non_sportif_id' => 'nullable|integer',
            'role' => 'nullable|string',
            'periode_min' => 'nullable|date',
            'periode_max' => 'nullable|date|after_or_equal:periode_min',
            'lieu' => 'nullable|string|max:255',

            // Organisme non sportif
            'org.nom' => 'required|string|max:255',
            'org.num_visa' => 'nullable|integer',
            'org.date_enregistrement' => 'nullable|date',
            'org.num_enregistrement' => 'nullable|string|max:50',
            'org.identifiant_fiscal' => 'nullable|int',
            'org.num_compte_bancaire' => 'nullable|string|max:50',
            'org.adresse' => 'nullable|string|max:255',
            'org.tel' => 'nullable|string|max:20',
            'org.fax' => 'nullable|string|max:20',
            'org.email' => 'nullable|email|max:255',
            'org.type_formulaire_id' => 'nullable|integer',

            // EvenementSportif
            'nom_even' => 'required|string|max:100',
            'objectifs' => 'nullable|string',
            'contenus' => 'nullable|string',
            'date' => 'required|date',
            'heure' => 'nullable|date_format:H:i',
            'instalation_sportives' => 'nullable|string|max:200',
            'reference' => 'nullable|string|max:100',
            'estimation_evenement' => 'nullable|numeric',
            'cout_total_evenement' => 'nullable|numeric',
            'difference_estimee' => 'nullable|numeric',
            'recompense' => 'nullable|string',
            'moyen_transport' => 'nullable|string|max:200',
            'user_id' => 'required|integer',
            'id_type' => 'nullable|integer',
            'id_formulaire' => 'nullable|integer',
            'gouvernorat_id' => 'required|integer',
            'delegation_id' => 'required|integer',
            'demande_id' => 'nullable|integer',

            // MembreOrgInvite
            'membres.*.nom_prenom' => 'required|string|max:255',
            'membres.*.role' => 'nullable|string',
            'membres.*.nationalite' => 'nullable|string',
            'membres.*.type_membre_id' => 'nullable|integer',

            //MembreOrgInvite2
            'invites.*.nom_prenom' => 'required|string|max:255',
            'invites.*.role' => 'nullable|string',
            'invites.*.nationalite' => 'nullable|string',
            'invites.*.type_membre_id' => 'nullable|integer',

            // AssocParticipante
            'assoc_participantes.*.nom' => 'required|string|max:255',
            'assoc_participantes.*.num_athlete_h' => 'nullable|integer',
            'assoc_participantes.*.num_athlete_f' => 'nullable|integer',
            'assoc_participantes.*.accompagnants' => 'nullable|integer',
            'assoc_participantes.*.total' => 'nullable|integer',

            // AthleteIndividuel
            'athletes.*.nom_prenom_sportif' => 'nullable|string|max:255',
            'athletes.*.num_athlete_h' => 'nullable|integer',
            'athletes.*.num_athlete_f' => 'nullable|integer',
            'athletes.*.accompagnants' => 'nullable|integer',
            'athletes.*.total' => 'nullable|integer',

            // SportifParticipant
            'sportifs.*.nom_prenom' => 'required|string|max:255',
            'sportifs.*.tranch_age' => 'nullable|string|max:50',
            'sportifs.*.date_naissance' => 'nullable|date',
            'sportifs.*.num_cin' => 'nullable|string|max:50',
            'sportifs.*.invitee' => 'nullable|string|max:255',
            'sportifs.*.jeune_id' => 'nullable|integer',

            // Attachements
            'assurance_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'technique_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'accord_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'demande_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',

            //touristes
            'touristes.*.nom_prenom' => 'nullable|string|max:255',
            'touristes.*.pays_origine' => 'nullable|string|max:255',
            'touristes.*.num_passport' => 'nullable|string|max:50',
            'touristes.*.date_arrive' => 'nullable|date',
            'touristes.*.lieu_residence' => 'nullable|string|max:255',
            'touristes.*.date_depart' => 'nullable|date',

            'touriste2s.*.nom_prenom' => 'nullable|string|max:255',
            'touriste2s.*.pays_origine' => 'nullable|string|max:255',
            'touriste2s.*.num_passport' => 'nullable|string|max:50',
            'touriste2s.*.date_arrive' => 'nullable|date',
            'touriste2s.*.lieu_residence' => 'nullable|string|max:255',
            'touriste2s.*.date_depart' => 'nullable|date',

            'touriste3s.*.nom_prenom' => 'nullable|string|max:255',
            'touriste3s.*.pays_origine' => 'nullable|string|max:255',
            'touriste3s.*.num_passport' => 'nullable|string|max:50',
            'touriste3s.*.date_arrive' => 'nullable|date',
            'touriste3s.*.lieu_residence' => 'nullable|string|max:255',
            'touriste3s.*.date_depart' => 'nullable|date',

        ]);

        //OrganismeNonSportif
        $organisme = null;
        if ($request->has('org')) {
            $organismeData = $request->input('org');
            $organismeData['type_formulaire_id'] = 14; 
            $organisme = OrganismeNonSportif::create($organismeData);
        }

        // DemandeManifestation
        $demande = DemandeManifestation::create([
            'sujet' => $request->sujet,
            'sport_type' => $request->sport_type,
            'event_name' => $request->event_name,
            'objectif' => $request->objectif,
            'commentaire_motif' => $request->commentaire_motif,
            'type_formulaire_id' => 13,
            'user_id' => Auth::id(),
            'id_type' => 2,
            'organisme_non_sportif_id' => $organisme?->id_org,
            'role' => $request->role,
            'periode_min' => $request->periode_min,
            'periode_max' => $request->periode_max,
            'lieu' => $request->lieu,
        ]);

        // Attachement
        if ($request->hasFile('assurance_file')) {
            $filePath = $request->file('assurance_file')->store('manifestations/', 'public');

            Attachement::create([
                'id_type_attach' => 2, 
                'file' => $filePath,
                'id_demande' => $demande->id_demande,
            ]);
        }

        if ($request->hasFile('accord_file')) {
            $filePath = $request->file('accord_file')->store('manifestations/', 'public');

            Attachement::create([
                'id_type_attach' => 7, 
                'file' => $filePath,
                'id_demande' => $demande->id_demande,
            ]);
        }

        if ($request->hasFile('technique_file')) {
            $filePath = $request->file('technique_file')->store('manifestations/', 'public');

            Attachement::create([
                'id_type_attach' => 8, 
                'file' => $filePath,
                'id_demande' => $demande->id_demande,
            ]);
        }

        if ($request->hasFile('demande_file')) {
            $filePath = $request->file('demande_file')->store('manifestations/', 'public');

            Attachement::create([
                'id_type_attach' => 9, 
                'file' => $filePath,
                'id_demande' => $demande->id_demande,
            ]);
        }

        // EvenementSportif
        if ($request->has('nom_even')) {
            $evenement = EvenementSportif::create([
                'nom_even' => $request->nom_even,
                'objectifs' => $request->objectifs,
                'contenus' => $request->contenus,
                'date' => $request->date,
                'heure' => $request->heure,
                'instalation_sportives' => $request->instalation_sportives,
                'reference' => $request->reference,
                'estimation_evenement' => $request->estimation_evenement,
                'cout_total_evenement' => $request->cout_total_evenement,
                'difference_estimee' => $request->difference_estimee,
                'recompense' => $request->recompense,
                'moyen_transport' => $request->moyen_transport,
                'user_id' => Auth::id(),
                'id_type' => 2,
                'id_formulaire' => 15,
                'gouvernorat_id' => $request->gouvernorat_id,
                'delegation_id' => $request->delegation_id,
                'demande_id' => $demande->id_demande,
            ]);

            // MembreOrgInvite
            if ($request->has('membres')) {
                foreach ($request->membres as $membre) {
                    MembreOrgInvite::create([
                        'nom_prenom' => $membre['nom_prenom'],
                        'role' => $membre['role'] ?? null,
                        'nationalite' => $membre['nationalite'] ?? null,
                        'event_id' => $evenement->id_even,
                        'type_membre_id' => 1,
                    ]);
                }
            }

            // MembreOrgInvite2
            if ($request->has('invites')) {
                foreach ($request->invites as $invite) {
                    MembreOrgInvite::create([
                        'nom_prenom' => $invite['nom_prenom'],
                        'role' => $invite['role'] ?? null,
                        'nationalite' => $invite['nationalite'] ?? null,
                        'event_id' => $evenement->id_even,
                        'type_membre_id' => 2,
                    ]);
                }
            }

            //AssocParticipante
            if ($request->has('assoc_participantes')) {
                foreach ($request->assoc_participantes as $assoc) {
                    // On calcule le total directement ici
                    $num_h = isset($assoc['num_athlete_h']) ? (int) $assoc['num_athlete_h'] : 0;
                    $num_f = isset($assoc['num_athlete_f']) ? (int) $assoc['num_athlete_f'] : 0;
                    $accomp = isset($assoc['accompagnants']) ? (int) $assoc['accompagnants'] : 0;

                    $total = $num_h + $num_f + $accomp;

                    AssocParticipante::create([
                        'nom' => $assoc['nom'] ?? null,
                        'num_athlete_h' => $num_h,
                        'num_athlete_f' => $num_f,
                        'accompagnants' => $accomp,
                        'total' => $total,
                        'event_id' => $evenement->id_even,
                    ]);
                }
            }


            //AthleteIndividuel
            if ($request->has('athletes')) {
                foreach ($request->athletes as $athlete) {
                    AthleteIndividuel::create([
                        'nom_prenom_sportif' => $athlete['nom_prenom_sportif'],
                        'num_athlete_h' => $athlete['num_athlete_h'] ?? 0,
                        'num_athlete_f' => $athlete['num_athlete_f'] ?? 0,
                        'accompagnants' => $athlete['accompagnants'] ?? 0,
                        'event_id' => $evenement->id_even,
                    ]);
                }
            }

            //SportifParticipant
            if ($request->has('sportifs')) {
                foreach ($request->sportifs as $sportif) {
                    SportifParticipant::create([
                        'nom_prenom' => $sportif['nom_prenom'],
                        'tranch_age' => $sportif['tranch_age'] ?? null,
                        'date_naissance' => $sportif['date_naissance'] ?? null,
                        'num_cin' => $sportif['num_cin'] ?? null,
                        'invitee' => $sportif['invitee'] ?? null,
                        'even_id' => $evenement->id_even,
                        'jeune_id' => $sportif['jeune_id'] ?? null,
                    ]);
                }
            }

            
            if ($request->has('touristes')) {
                foreach ($request->touristes as $touriste) {
                    Etrangere::create([
                        'nom_prenom' => $touriste['nom_prenom'] ?? null,
                        'pays_origine' => $touriste['pays_origine'] ?? null,
                        'num_passport' => $touriste['num_passport'] ?? null,
                        'date_arrive' => $touriste['date_arrive'] ?? null,
                        'lieu_residence' => $touriste['lieu_residence'] ?? null,
                        'date_depart' => $touriste['date_depart'] ?? null,
                        'even_id' => $evenement->id_even,
                        'type_etranger_id' => 1, 
                    ]);
                }
            }

           
            if ($request->has('touriste2s')) {
                foreach ($request->touriste2s as $touriste2) {
                    Etrangere::create([
                        'nom_prenom' => $touriste2['nom_prenom'] ?? null,
                        'pays_origine' => $touriste2['pays_origine'] ?? null,
                        'num_passport' => $touriste2['num_passport'] ?? null,
                        'date_arrive' => $touriste2['date_arrive'] ?? null,
                        'lieu_residence' => $touriste2['lieu_residence'] ?? null,
                        'date_depart' => $touriste2['date_depart'] ?? null,
                        'even_id' => $evenement->id_even,
                        'type_etranger_id' => 2, 
                    ]);
                }
            }

            if ($request->has('touriste3s')) {
                foreach ($request->touriste3s as $touriste3) {
                    Etrangere::create([
                        'nom_prenom' => $touriste3['nom_prenom'] ?? null,
                        'pays_origine' => $touriste3['pays_origine'] ?? null,
                        'num_passport' => $touriste3['num_passport'] ?? null,
                        'date_arrive' => $touriste3['date_arrive'] ?? null,
                        'lieu_residence' => $touriste3['lieu_residence'] ?? null,
                        'date_depart' => $touriste3['date_depart'] ?? null,
                        'even_id' => $evenement->id_even,
                        'type_etranger_id' => 3, 
                    ]);
                }
            }


        }

        return redirect()->route('admin.manifestation2.index')
                    ->with('success', 'تم تسجيل الطلب بنجاح');
    }


    /*public function showfile2($id)
{
    $att = Attachement::findOrFail($id);

    if (empty($att->file)) {
        abort(404, 'Fichier introuvable');
    }

    // Détecte automatiquement le type MIME à partir du contenu binaire
    $finfo = new \finfo(FILEINFO_MIME_TYPE);
    $mimeType = $finfo->buffer($att->file);

    return response($att->file, 200)
        ->header('Content-Type', $mimeType)
        ->header('Content-Disposition', 'inline'); // Affichage direct dans le navigateur
}*/

















//last 
/*public function showfile2($id)
{
    $att = Attachement::findOrFail($id);

    if (empty($att->file)) {
        abort(404, 'Fichier introuvable');
    }

    // Si le fichier est stocké comme chemin (string), lire depuis le système de fichiers
    if (is_string($att->file) && file_exists($att->file)) {
        $content = file_get_contents($att->file);
        $mimeType = mime_content_type($att->file);
        
        return response($content, 200)
            ->header('Content-Type', $mimeType)
            ->header('Content-Disposition', 'inline');
    }
    
    // Si c'est un BLOB (ancien système)
    $finfo = new \finfo(FILEINFO_MIME_TYPE);
    $mimeType = $finfo->buffer($att->file);

    return response($att->file, 200)
        ->header('Content-Type', $mimeType)
        ->header('Content-Disposition', 'inline');
}*/


    public function show($id)
    {
        $demande = DemandeManifestation::with([
            'organismeNonSportif',
            'evenementSportifs',
            'evenementSportifs.membres',
            'evenementSportifs.invites',
            'evenementSportifs.assocParticipantes',
            'evenementSportifs.athletesIndividuels',
            'evenementSportifs.sportifs',
            'attachements'
        ])->findOrFail($id);


        $org = $demande->organismeNonSportif;
        $formulaire   = TypeFormulaire::find(13);
        $attachments  = TpAttachement::orderBy('type_ar', 'asc')->get();
        $formulaire2  = TypeFormulaire::find(14);
        $formulaire3  = TypeFormulaire::find(15);
        $gouvernorats = Gouvernorat::all();
        $delegations  = Delegation::all();
        $formulaire4  = TypeFormulaire::find(16);
        $type_membre  = TpTypeMembre::all();
        $statut       = TpStatut::all();
        $formulaire5  = TypeFormulaire::find(17);
        $formulaire6  = TypeFormulaire::find(23);
        $formulaire7  = TypeFormulaire::find(18);
        $formulaire8  = TypeFormulaire::find(19);
        $formulaire9  = TypeFormulaire::find(20);

        return view('backoffice.manifestation_sport.demande_inter.show', compact(
            'demande', 'formulaire', 'attachments','formulaire2','formulaire3',
            'gouvernorats','delegations','type_membre','statut','formulaire4',
            'formulaire5','formulaire6','formulaire7','org','formulaire8','formulaire9'
        ));
    }

    public function edit($id)
    {
        $demande = DemandeManifestation::with([
            'organismeNonSportif',
            'evenementSportifs',
            'evenementSportifs.membres',
            'evenementSportifs.invites',
            'evenementSportifs.assocParticipantes',
            'evenementSportifs.athletesIndividuels',
            'evenementSportifs.sportifs',
            'attachements'
        ])->findOrFail($id);

        $org = $demande->organismeNonSportif;
        //$org = OrganismeNonSportif::find($id);
        $formulaire   = TypeFormulaire::find(13);
        $attachments  = TpAttachement::orderBy('type_ar', 'asc')->get();
        $formulaire2  = TypeFormulaire::find(14);
        $formulaire3  = TypeFormulaire::find(15);
        $gouvernorats = Gouvernorat::all();
        $delegations  = Delegation::all();
        $formulaire4  = TypeFormulaire::find(16);
        $type_membre  = TpTypeMembre::all();
        $statut       = TpStatut::all();
        $formulaire5  = TypeFormulaire::find(17);
        $formulaire6  = TypeFormulaire::find(23);
        $formulaire7  = TypeFormulaire::find(18);
        $formulaire8  = TypeFormulaire::find(19);
        $formulaire9  = TypeFormulaire::find(20);
        $statuts = TpStatut::orderBy('id_statut')->get();
        return view('backoffice.manifestation_sport.demande_inter.edit', compact(
            'demande', 'formulaire', 'attachments','formulaire2','formulaire3',
            'gouvernorats','delegations','type_membre','statut','formulaire4',
            'formulaire5','formulaire6','formulaire7','org','formulaire8','formulaire9','statuts'
        ));
    }

   private function envoyerNotificationEtMail(DemandeManifestation $demande, $nouveauStatut)
{
    $date = now()->format('Y-m-d');
    $statut_ar = $nouveauStatut == 1 ? 'قبول' : 'رفض';

    $idPad = str_pad($demande->id_demande, 3, '0', STR_PAD_LEFT);
    $cin = $demande->utilisateur->num_cin ?? $demande->utilisateur->cin ?? null;
    $cinDigits = $cin ? preg_replace('/\D+/', '', $cin) : '';
    $cinPad = $cinDigits ? str_pad($cinDigits, 9, '0', STR_PAD_LEFT) : '000000000';
    $year = $demande->created_at ? $demande->created_at->format('Y') : now()->format('Y');
    $num_dossier = "{$idPad}-{$cinPad}-{$year}";
    $nomUtilisateur = $demande->utilisateur->nom_prenom ?? 'المستخدم';

    if ($nouveauStatut == 1) {
        $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>" .
            "رقم الملف: <strong>{$num_dossier}</strong><br>" .
            "تم قبول طلبكم \" طلب في اقامة تظاهرة رياضية وطنية بالبالد التونسية \" ، بتاريخ: <strong>{$date}</strong>.<br>نهنئكم على هذا القبول.";
    } else {
        $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>" .
            "رقم الملف: <strong>{$num_dossier}</strong><br>" .
            "تم رفض طلبكم \" طلب في اقامة تظاهرة رياضية وطنية بالبالد التونسية \" ، بتاريخ: <strong>{$date}</strong>.<br>" .
            "التعليق: {$demande->commentaire_motif}{$demande->commentaire_motif2}{$demande->commentaire_motif3}.";
    }

    if ($demande->utilisateur?->email) {
        Mail::to($demande->utilisateur->email)->send(
            new \App\Mail\StatutDemande2Mail($demande->utilisateur, $num_dossier, $messageStatus)
        );
    }

    if ($demande->utilisateur) {
        $demande->utilisateur->notify(
            new \App\Notifications\StatutDemandeNotification($num_dossier, $messageStatus)
        );
    }
}


public function update(Request $request, $id)
{
    $request->validate([
        'sujet' => 'nullable|string|max:255',
        'sport_type' => 'nullable|string|max:255',
        'event_name' => 'nullable|string|max:255',
        'objectif' => 'nullable|string',
        'commentaire_motif' => 'nullable|string',
        'type_formulaire_id' => 'required|integer',
        'statut_id' => 'nullable|integer',
        'statut2_id' => 'nullable|integer',
        'commentaire_motif2' => 'nullable|string|max:255',
        'commentaire_motif3' => 'nullable|string|max:255',
        'file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:4096',
        'id_type' => 'nullable|integer',
        'organisme_non_sportif_id' => 'nullable|integer',
        'role' => 'nullable|string',
        'periode_min' => 'nullable|date',
        'periode_max' => 'nullable|date|after_or_equal:periode_min',
        'lieu' => 'nullable|string|max:255',
        // Organisme fields
        'org' => 'nullable|array',
        'org.nom' => 'nullable|string|max:255',
        'org.num_visa' => 'nullable|integer',
        'org.date_enregistrement' => 'nullable|date',
        'org.num_enregistrement' => 'nullable|string|max:50',
        'org.identifiant_fiscal' => 'nullable|numeric',
        'org.num_compte_bancaire' => 'nullable|string|max:50',
        'org.adresse' => 'nullable|string|max:255',
        'org.tel' => 'nullable|string|max:20',
        'org.fax' => 'nullable|string|max:20',
        'org.email' => 'nullable|email|max:255',
        'org.type_formulaire_id' => 'nullable|integer',
        // EvenementSportif
        'nom_even' => 'required_with:date|string|max:100',
        'objectifs' => 'nullable|string',
        'contenus' => 'nullable|string',
        'date' => 'required_with:nom_even|date',
        'heure' => 'nullable|date_format:H:i',
        'instalation_sportives' => 'nullable|string|max:200',
        'reference' => 'nullable|string|max:100',
        'estimation_evenement' => 'nullable|numeric',
        'cout_total_evenement' => 'nullable|numeric',
        'difference_estimee' => 'nullable|numeric',
        'recompense' => 'nullable|string',
        'moyen_transport' => 'nullable|string|max:200',
        'gouvernorat_id' => 'required_with:nom_even|integer',
        'delegation_id' => 'required_with:nom_even|integer',
        // collections
        'membres.*.nom_prenom' => 'required_with:membres|string|max:255',
        'invites.*.nom_prenom' => 'required_with:invites|string|max:255',
        'assoc_participantes.*.nom' => 'required_with:assoc_participantes|string|max:255',
        'athletes.*.nom_prenom_sportif' => 'nullable|string|max:255',
        'sportifs.*.nom_prenom' => 'required_with:sportifs|string|max:255',
        // attachements
        'assurance_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'technique_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'accord_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'demande_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        // touristes
        'touristes.*.nom_prenom' => 'nullable|string|max:255',
        'touristes.*.pays_origine' => 'nullable|string|max:255',
        'touristes.*.num_passport' => 'nullable|string|max:50',
        'touristes.*.date_arrive' => 'nullable|date',
        'touristes.*.lieu_residence' => 'nullable|string|max:255',
        'touristes.*.date_depart' => 'nullable|date',
        'touriste2s.*.nom_prenom' => 'nullable|string|max:255',
        'touriste2s.*.pays_origine' => 'nullable|string|max:255',
        'touriste2s.*.num_passport' => 'nullable|string|max:50',
        'touriste2s.*.date_arrive' => 'nullable|date',
        'touriste2s.*.lieu_residence' => 'nullable|string|max:255',
        'touriste2s.*.date_depart' => 'nullable|date',
        'touriste3s.*.nom_prenom' => 'nullable|string|max:255',
        'touriste3s.*.pays_origine' => 'nullable|string|max:255',
        'touriste3s.*.num_passport' => 'nullable|string|max:50',
        'touriste3s.*.date_arrive' => 'nullable|date',
        'touriste3s.*.lieu_residence' => 'nullable|string|max:255',
        'touriste3s.*.date_depart' => 'nullable|date',
    ]);

    DB::beginTransaction();
    $committed = false;

    try {
        $demande = DemandeManifestation::findOrFail($id);
        
        // Définir le dossier d'upload
        $uploadDir = '/home/preprov/www/mjs/shared_uploads/images';
        
        // Vérifier et créer le dossier si nécessaire
        if (!is_dir($uploadDir)) {
            if (!mkdir($uploadDir, 0755, true)) {
                abort(500, 'لا يمكن إنشاء مجلد التحميل');
            }
        }

        // -------------------------
        // Organisme: update or create
        // -------------------------
        $organisme = null;
        $orgInput = $request->input('org', null);
        if (is_array($orgInput) && count(array_filter($orgInput)) > 0) {
            $orgInput['type_formulaire_id'] = $orgInput['type_formulaire_id'] ?? 14;

            if ($demande->organisme_non_sportif_id) {
                $organisme = OrganismeNonSportif::find($demande->organisme_non_sportif_id);
                if ($organisme) {
                    $organisme->fill($orgInput);
                    $organisme->save();
                } else {
                    $organisme = OrganismeNonSportif::create($orgInput);
                }
            } else {
                $organisme = OrganismeNonSportif::create($orgInput);
            }

            $pkName = $organisme->getKeyName();
            $demande->organisme_non_sportif_id = $organisme->{$pkName};
        }

        // -------------------------
        // Gestion du fichier principal (decision/file)
        // -------------------------
        $filePath = $demande->file; // Conserver l'ancien chemin par défaut

        if ($request->hasFile('file') && $request->file('file')->isValid()) {
            $file = $request->file('file');
            
            // Supprimer l'ancien fichier s'il existe
            if (!empty($demande->file)) {
                $oldFilePath = $demande->file;
                // Si c'est un chemin relatif, l'ajouter au dossier d'upload
                if (strpos($oldFilePath, '/') !== 0) {
                    $oldFilePath = $uploadDir . '/' . basename($oldFilePath);
                }
                if (file_exists($oldFilePath)) {
                    try {
                        unlink($oldFilePath);
                    } catch (\Exception $e) {
                        \Log::warning("Cannot delete old main file: " . $e->getMessage());
                    }
                }
            }
            
            // Générer un nom de fichier sécurisé
            $original = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $ext = $file->getClientOriginalExtension();
            $safe = \Illuminate\Support\Str::slug(mb_substr($original, 0, 40)) ?: 'document';
            
            // Nom de fichier
            $filename = 'decision_' . $demande->id_demande . '_' . $safe . '_' . time() . '.' . $ext;
            $targetPath = $uploadDir . DIRECTORY_SEPARATOR . $filename;
            
            // Déplacer le fichier
            try {
                $file->move($uploadDir, $filename);
                
                if (!file_exists($targetPath)) {
                    throw new \Exception('لم يتم إنشاء الملف بعد النقل');
                }
                
                $filePath = $targetPath;
                
                \Log::info("Fichier décision téléchargé avec succès", [
                    'demande_id' => $demande->id_demande,
                    'path' => $filePath,
                    'filename' => $filename
                ]);
                
            } catch (\Exception $e) {
                \Log::error("Erreur lors du téléchargement du fichier décision: " . $e->getMessage());
                DB::rollBack();
                return redirect()->back()
                    ->withInput()
                    ->with('error', 'خطأ في تحميل الملف: ' . $e->getMessage());
            }
        }

        // capture old status values
        $ancienStatut  = $demande->getOriginal('id_type');
        $ancienStatut1 = $demande->getOriginal('statut_id');
        $ancienStatut2 = $demande->getOriginal('statut2_id');

        // -------------------------
        // Mettre à jour la demande
        // -------------------------
        $updateData = [
            'sujet' => $request->input('sujet'),
            'sport_type' => $request->input('sport_type'),
            'event_name' => $request->input('event_name'),
            'objectif' => $request->input('objectif'),
            'commentaire_motif' => $request->input('commentaire_motif'),
            'commentaire_motif2' => $request->input('commentaire_motif2'),
            'commentaire_motif3' => $request->input('commentaire_motif3'),
            'type_formulaire_id' => $request->input('type_formulaire_id', $demande->type_formulaire_id),
            'user_id' => $demande->user_id,
            'id_type' => $request->input('id_type', $demande->id_type),
            'statut_id' => $request->input('statut_id', $demande->statut_id),
            'statut2_id' => $request->input('statut2_id', $demande->statut2_id),
            'role' => $request->input('role'),
            'periode_min' => $request->input('periode_min'),
            'periode_max' => $request->input('periode_max'),
            'lieu' => $request->input('lieu'),
            'organisme_non_sportif_id' => $demande->organisme_non_sportif_id,
            'file' => $filePath, // Chemin du fichier de décision
        ];

        // Perform update on DemandeManifestation
        $demande->update($updateData);

        // -------------------------
        // Gestion des attachements (fichiers supplémentaires)
        // -------------------------
        $attachmentsMap = [
            'assurance_file' => 2,
            'accord_file'    => 7,
            'technique_file' => 8,
            'demande_file'   => 9,
        ];

        foreach ($attachmentsMap as $inputName => $typeId) {
            if ($request->hasFile($inputName) && $request->file($inputName)->isValid()) {
                $f = $request->file($inputName);
                
                $oldAttachment = Attachement::where('id_demande', $demande->id_demande)
                    ->where('id_type_attach', $typeId)
                    ->first();

                // Supprimer l'ancien fichier s'il existe
                if ($oldAttachment && !empty($oldAttachment->file)) {
                    $oldPath = $oldAttachment->file;
                    
                    // Si le chemin est relatif, essayer avec le dossier d'upload
                    if (strpos($oldPath, '/') !== 0) {
                        $oldPath = $uploadDir . '/' . basename($oldPath);
                    }
                    
                    if (file_exists($oldPath)) {
                        try {
                            unlink($oldPath);
                            \Log::info("Ancien fichier d'attachment supprimé: " . basename($oldPath));
                        } catch (\Exception $e) {
                            \Log::warning("Cannot delete old attachment: " . $e->getMessage());
                        }
                    }
                }

                // Générer un nom de fichier
                $original = pathinfo($f->getClientOriginalName(), PATHINFO_FILENAME);
                $ext = $f->getClientOriginalExtension();
                $safe = \Illuminate\Support\Str::slug(mb_substr($original, 0, 40)) ?: 'document';
                
                // Nom de fichier
                $filename = 'attachment_' . $demande->id_demande . '_' . $typeId . '_' . $safe . '_' . time() . '.' . $ext;
                $targetPath = $uploadDir . DIRECTORY_SEPARATOR . $filename;
                
                try {
                    // Déplacer le fichier
                    $f->move($uploadDir, $filename);
                    
                    // Vérifier si le fichier existe
                    if (!file_exists($targetPath)) {
                        throw new \Exception('لم يتم إنشاء ملف المرفق: ' . $targetPath);
                    }
                    
                    // Stocker le chemin absolu
                    $filePathToStore = $targetPath;
                    
                    \Log::info("Fichier attachment téléchargé", [
                        'demande_id' => $demande->id_demande,
                        'type' => $typeId,
                        'filename' => $filename,
                        'path' => $filePathToStore
                    ]);
                    
                    if ($oldAttachment) {
                        $oldAttachment->update([
                            'file' => $filePathToStore, // Chemin absolu
                            'mime_type' => $f->getMimeType(),
                        ]);
                    } else {
                        Attachement::create([
                            'id_demande'     => $demande->id_demande,
                            'id_type_attach' => $typeId,
                            'file'           => $filePathToStore, // Chemin absolu
                            'mime_type'      => $f->getMimeType(),
                        ]);
                    }
                    
                } catch (\Exception $e) {
                    \Log::error("Erreur attachment {$inputName}: " . $e->getMessage());
                }
            }
        }

        // -------------------------
        // EvenementSportif and related collections
        // -------------------------
        $evenement = EvenementSportif::where('demande_id', $demande->id_demande)->first();

        if ($request->has('nom_even')) {
            $evenData = [
                'nom_even' => $request->input('nom_even'),
                'objectifs' => $request->input('objectifs'),
                'contenus' => $request->input('contenus'),
                'date' => $request->input('date'),
                'heure' => $request->input('heure'),
                'instalation_sportives' => $request->input('instalation_sportives'),
                'reference' => $request->input('reference'),
                'estimation_evenement' => $request->input('estimation_evenement'),
                'cout_total_evenement' => $request->input('cout_total_evenement'),
                'difference_estimee' => $request->input('difference_estimee'),
                'recompense' => $request->input('recompense'),
                'moyen_transport' => $request->input('moyen_transport'),
                'user_id' => Auth::id(),
                'id_type' => $request->input('id_type', 2),
                'id_formulaire' => $request->input('id_formulaire', 15),
                'gouvernorat_id' => $request->input('gouvernorat_id'),
                'delegation_id' => $request->input('delegation_id'),
                'demande_id' => $demande->id_demande,
            ];

            if ($evenement) {
                $evenement->update($evenData);
            } else {
                $evenement = EvenementSportif::create($evenData);
            }

            // delete old related rows then re-create
            MembreOrgInvite::where('event_id', $evenement->id_even)->delete();
            AssocParticipante::where('event_id', $evenement->id_even)->delete();
            AthleteIndividuel::where('event_id', $evenement->id_even)->delete();
            SportifParticipant::where('even_id', $evenement->id_even)->delete();
            Etrangere::where('even_id', $evenement->id_even)->delete();

            if ($request->has('membres')) {
                foreach ($request->input('membres', []) as $membre) {
                    MembreOrgInvite::create([
                        'nom_prenom' => $membre['nom_prenom'],
                        'role' => $membre['role'] ?? null,
                        'nationalite' => $membre['nationalite'] ?? null,
                        'event_id' => $evenement->id_even,
                        'type_membre_id' => 1,
                    ]);
                }
            }

            if ($request->has('invites')) {
                foreach ($request->input('invites', []) as $invite) {
                    MembreOrgInvite::create([
                        'nom_prenom' => $invite['nom_prenom'],
                        'role' => $invite['role'] ?? null,
                        'nationalite' => $invite['nationalite'] ?? null,
                        'event_id' => $evenement->id_even,
                        'type_membre_id' => 2,
                    ]);
                }
            }

            if ($request->has('assoc_participantes')) {
                foreach ($request->input('assoc_participantes', []) as $assoc) {
                    $num_h = isset($assoc['num_athlete_h']) ? (int)$assoc['num_athlete_h'] : 0;
                    $num_f = isset($assoc['num_athlete_f']) ? (int)$assoc['num_athlete_f'] : 0;
                    $accomp = isset($assoc['accompagnants']) ? (int)$assoc['accompagnants'] : 0;
                    $total = $num_h + $num_f + $accomp;

                    AssocParticipante::create([
                        'nom' => $assoc['nom'] ?? null,
                        'num_athlete_h' => $num_h,
                        'num_athlete_f' => $num_f,
                        'accompagnants' => $accomp,
                        'total' => $total,
                        'event_id' => $evenement->id_even,
                    ]);
                }
            }

            if ($request->has('athletes')) {
                foreach ($request->input('athletes', []) as $athlete) {
                    AthleteIndividuel::create([
                        'nom_prenom_sportif' => $athlete['nom_prenom_sportif'],
                        'num_athlete_h' => $athlete['num_athlete_h'] ?? 0,
                        'num_athlete_f' => $athlete['num_athlete_f'] ?? 0,
                        'accompagnants' => $athlete['accompagnants'] ?? 0,
                        'event_id' => $evenement->id_even,
                    ]);
                }
            }

            if ($request->has('sportifs')) {
                foreach ($request->input('sportifs', []) as $sportif) {
                    SportifParticipant::create([
                        'nom_prenom' => $sportif['nom_prenom'],
                        'tranch_age' => $sportif['tranch_age'] ?? null,
                        'date_naissance' => $sportif['date_naissance'] ?? null,
                        'num_cin' => $sportif['num_cin'] ?? null,
                        'invitee' => $sportif['invitee'] ?? null,
                        'even_id' => $evenement->id_even,
                        'jeune_id' => $sportif['jeune_id'] ?? null,
                    ]);
                }
            }

            // touristes (Etrangere)
            if ($request->has('touristes')) {
                foreach ($request->input('touristes', []) as $touriste) {
                    Etrangere::create([
                        'nom_prenom' => $touriste['nom_prenom'] ?? null,
                        'pays_origine' => $touriste['pays_origine'] ?? null,
                        'num_passport' => $touriste['num_passport'] ?? null,
                        'date_arrive' => $touriste['date_arrive'] ?? null,
                        'lieu_residence' => $touriste['lieu_residence'] ?? null,
                        'date_depart' => $touriste['date_depart'] ?? null,
                        'even_id' => $evenement->id_even,
                        'type_etranger_id' => 1,
                    ]);
                }
            }
            if ($request->has('touriste2s')) {
                foreach ($request->input('touriste2s', []) as $touriste2) {
                    Etrangere::create([
                        'nom_prenom' => $touriste2['nom_prenom'] ?? null,
                        'pays_origine' => $touriste2['pays_origine'] ?? null,
                        'num_passport' => $touriste2['num_passport'] ?? null,
                        'date_arrive' => $touriste2['date_arrive'] ?? null,
                        'lieu_residence' => $touriste2['lieu_residence'] ?? null,
                        'date_depart' => $touriste2['date_depart'] ?? null,
                        'even_id' => $evenement->id_even,
                        'type_etranger_id' => 2,
                    ]);
                }
            }
            if ($request->has('touriste3s')) {
                foreach ($request->input('touriste3s', []) as $touriste3) {
                    Etrangere::create([
                        'nom_prenom' => $touriste3['nom_prenom'] ?? null,
                        'pays_origine' => $touriste3['pays_origine'] ?? null,
                        'num_passport' => $touriste3['num_passport'] ?? null,
                        'date_arrive' => $touriste3['date_arrive'] ?? null,
                        'lieu_residence' => $touriste3['lieu_residence'] ?? null,
                        'date_depart' => $touriste3['date_depart'] ?? null,
                        'even_id' => $evenement->id_even,
                        'type_etranger_id' => 3,
                    ]);
                }
            }
        } // end evenement handling

        // -------------------------
        // Status history creation (after update)
        // -------------------------
        $normalize = function ($v) {
            if (is_null($v) || $v === '') return null;
            $i = (int) $v;
            return ($i > 0) ? $i : null;
        };

        $old_id_type    = $normalize($ancienStatut);
        $old_statut_id  = $normalize($ancienStatut1);
        $old_statut2_id = $normalize($ancienStatut2);

        // refresh model to ensure we compare current persisted values
        $demande->refresh();

        $new_id_type    = $normalize($demande->id_type);
        $new_statut_id  = $normalize($demande->statut_id);
        $new_statut2_id = $normalize($demande->statut2_id);

        $statExists = function ($id) {
            if (is_null($id)) return false;
            return DB::table('tp_statut')->where('id_statut', $id)->exists();
        };

        $commentForHistory = null;
        if ($request->filled('commentaire_motif')) {
            $commentForHistory = trim($request->input('commentaire_motif'));
        } elseif ($request->filled('commentaire_motif2')) {
            $commentForHistory = trim($request->input('commentaire_motif2'));
        } elseif ($request->filled('commentaire_motif3')) {
            $commentForHistory = trim($request->input('commentaire_motif3'));
        }

        if ($old_id_type !== $new_id_type) {
            ImmobilierStatutHistory::create([
                'demande_manifestation_id' => $demande->id_demande,
                'from_statut_id' => $old_id_type,
                'to_statut_id' => $statExists($new_id_type) ? $new_id_type : null,
                'changed_by' => Auth::id() ?? null,
                'commentaire' => $commentForHistory,
            ]);
        }

        if ($old_statut_id !== $new_statut_id) {
            ImmobilierStatutHistory::create([
                'demande_manifestation_id' => $demande->id_demande,
                'from_statut_id' => $old_statut_id,
                'to_statut_id' => $statExists($new_statut_id) ? $new_statut_id : null,
                'changed_by' => Auth::id() ?? null,
                'commentaire' => $commentForHistory,
            ]);
        }

        if ($old_statut2_id !== $new_statut2_id) {
            ImmobilierStatutHistory::create([
                'demande_manifestation_id' => $demande->id_demande,
                'from_statut_id' => $old_statut2_id,
                'to_statut_id' => $statExists($new_statut2_id) ? $new_statut2_id : null,
                'changed_by' => Auth::id() ?? null,
                'commentaire' => $commentForHistory,
            ]);
        }

        // -------------------------
        // Commit DB transaction before running non-critical operations (mail/notifications)
        // -------------------------
        DB::commit();
        $committed = true;

        session()->forget('_old_input');

        // -------------------------
        // Notifications & Mail (run after commit; failures here should NOT roll back DB)
        // -------------------------
        try {
            // Refresh the model and user
            $demande = DemandeManifestation::with('utilisateur')->findOrFail($id);
            $user = $demande->utilisateur;

            // Determine which status was changed (prefer request inputs)
            $resolved = (int) ($request->input('id_type') ?? $request->input('statut_id') ?? $request->input('statut2_id') ?? 0);
            if ($resolved <= 0) {
                // nothing to notify, just redirect success
                return redirect()->route('admin.manifestation2.index', $demande->id_demande)
                                 ->with('success', 'تم تحديث الطلب بنجاح');
            }

            // Status normalization
            $statusMap = [
                1 => 'accepted',
                3 => 'rejected',
                4 => 'incomplete',
                5 => 'deferred',
            ];
            $type = $statusMap[$resolved] ?? 'status_changed';

            // Build dossier reference
            $idPad = str_pad($demande->id_demande, 3, '0', STR_PAD_LEFT);
            $cin = $user->num_cin ?? $user->cin ?? '';
            $cinDigits = preg_replace('/\D+/', '', $cin);
            $cinPad = $cinDigits ? str_pad($cinDigits, 9, '0', STR_PAD_LEFT) : '000000000';
            $year = $demande->created_at ? $demande->created_at->format('Y') : now()->format('Y');
            $num_dossier = "{$idPad}-{$cinPad}-{$year}";

            // Prepare comment (prefer saved model fields, fallback to request)
            $messageComment = trim(($demande->commentaire_motif ?? '') . ' ' . ($demande->commentaire_motif2 ?? '') . ' ' . ($demande->commentaire_motif3 ?? ''));
            if ($messageComment === '') {
                $messageComment = trim($request->input('commentaire_motif') ?? $request->input('commentaire_motif2') ?? $request->input('commentaire_motif3') ?? '');
            }
            $messageComment = $messageComment !== '' ? $messageComment : null;

            // Build HTML messageStatus (comments are escaped with e())
            $nomUtilisateur = $user->nom_prenom ?? 'المستخدم';
            $date = now()->format('Y-m-d');

            switch ($resolved) {
                case 1: // accepted
                    $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم قبول طلبكم بتاريخ: <strong>{$date}</strong>.<br>نهنئكم على هذا القبول.";
                    break;

                case 3: // rejected
                    $reason = e($messageComment ?? 'سبب غير محدد');
                    $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم رفض طلبكم.<br>السبب: <b>{$reason}</b>.";
                    break;

                case 4: // incomplete
                    $missing = e($request->input('commentaire_acceptation') ?? $messageComment ?? 'يرجى استكمال الوثائق المطلوبة');
                    $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>طلبكم <strong>غير مكتمل</strong>.<br>التوضيح: <b>{$missing}</b>.";
                    break;

                case 5: // deferred
                    $note = e($request->input('commentaire_avis') ?? $messageComment ?? 'لا يوجد ملاحظات');
                    $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم إرجاء طلبكم.<br>الملاحظة: <b>{$note}</b>.";
                    break;

                default:
                    $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم تحديث حالة ملفكم.";
            }

            // Build translation params for DB notification
            $params = [];
            if ($resolved === 3) $params['reason'] = $messageComment ?? '';
            if ($resolved === 4) $params['missing'] = $request->input('commentaire_acceptation') ?? ($messageComment ?? '');
            if ($resolved === 5) $params['note'] = $request->input('commentaire_avis') ?? ($messageComment ?? '');
            if ($resolved === 1) $params['date'] = $date;
            $params['reference'] = $num_dossier;
            if (!empty($messageComment)) $params['comment'] = $messageComment;

            // Send mail (best-effort)
            if (!empty($user->email)) {
                try {
                    Mail::to($user->email)->send(new \App\Mail\StatutDemande2Mail($user, $num_dossier, $messageStatus, $type, $messageComment));
                } catch (\Exception $ex) {
                    Log::error("Mail error after update for DemandeManifestation {$demande->id_demande}: " . $ex->getMessage());
                }
            }

            // DB Notification (best-effort)
            try {
                if ($user) {
                    $translationKey = "site.notifications.manifestation.{$type}";
                    $user->notify(new \App\Notifications\StatutDemande2Notification($demande->fresh('utilisateur'), $type, $params, $demande->id_demande, $translationKey));
                }
            } catch (\Exception $ex) {
                Log::error("Notification error after update for DemandeManifestation {$demande->id_demande}: " . $ex->getMessage());
            }

            return redirect()->route('admin.manifestation2.index', $demande->id_demande)
                             ->with('success', 'تم تحديث الطلب بنجاح');
        } catch (\Exception $e) {
            // Notification failures should not break the user flow. Log and fallthrough to success redirect.
            Log::error("Notification processing error after update for DemandeManifestation {$id}: " . $e->getMessage());
            // still redirect success because DB changes are already committed
            return redirect()->route('admin.manifestation2.index', $demande->id_demande)
                             ->with('success', 'تم تحديث الطلب بنجاح');
        }
    } catch (\Exception $e) {
        // Only rollback if we haven't already committed
        if (!$committed) {
            DB::rollBack();
        }
        Log::error("Error updating DemandeManifestation {$id}: " . $e->getMessage());
        return redirect()->back()->withInput()->with('error', 'حدث خطأ أثناء التحديث: ' . $e->getMessage());
    }
}

public function showDecision($id)
{
    $demande = DemandeManifestation::findOrFail($id);

    // Vérifier si le fichier existe
    if (empty($demande->file)) {
        abort(404, 'Aucun fichier disponible');
    }
    
    $uploadDir = '/home/preprov/www/mjs/shared_uploads/images';
    $filePath = $demande->file;
    
    // Si le chemin est relatif, construire le chemin absolu
    if (strpos($filePath, '/') !== 0) {
        $filePath = $uploadDir . '/' . basename($filePath);
    }
    
    // Vérifier l'existence du fichier
    if (!file_exists($filePath)) {
        // Essayer de trouver le fichier avec différentes possibilités
        $alternativePaths = [
            $uploadDir . '/' . basename($demande->file),
            $demande->file,
            public_path($demande->file),
            storage_path('app/' . $demande->file),
        ];
        
        foreach ($alternativePaths as $path) {
            if (file_exists($path)) {
                $filePath = $path;
                break;
            }
        }
        
        if (!file_exists($filePath)) {
            \Log::error("Fichier introuvable pour la demande {$id}: " . $demande->file);
            abort(404, 'Fichier introuvable');
        }
    }

    // Déterminer le Content-Type
    $extension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
    $mimeTypes = [
        'pdf' => 'application/pdf',
        'jpg' => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'png' => 'image/png',
    ];

    $contentType = $mimeTypes[$extension] ?? mime_content_type($filePath);
    
    // Vérifier si le téléchargement est demandé
    if (request()->has('download')) {
        return response()->download($filePath, basename($filePath), [
            'Content-Type' => $contentType,
        ]);
    }

    // Afficher le fichier dans le navigateur
    return response()->file($filePath, [
        'Content-Type' => $contentType,
        'Content-Disposition' => 'inline; filename="' . basename($filePath) . '"',
        'Cache-Control' => 'no-store, no-cache, must-revalidate, max-age=0',
        'Pragma' => 'no-cache',
        'Expires' => '0',
    ]);
}

public function showfile2($id)
{
    $att = Attachement::findOrFail($id);

    if (empty($att->file)) {
        abort(404, 'Fichier introuvable');
    }
    
    $uploadDir = '/home/preprov/www/mjs/shared_uploads/images';
    $filePath = $att->file;
    
    // Si le chemin est relatif, construire le chemin absolu
    if (strpos($filePath, '/') !== 0) {
        $filePath = $uploadDir . '/' . basename($filePath);
    }
    
    // Vérifier l'existence du fichier
    if (!file_exists($filePath)) {
        // Essayer de trouver le fichier avec différentes possibilités
        $alternativePaths = [
            $uploadDir . '/' . basename($att->file),
            $att->file,
            public_path($att->file),
            storage_path('app/' . $att->file),
        ];
        
        foreach ($alternativePaths as $path) {
            if (file_exists($path)) {
                $filePath = $path;
                break;
            }
        }
        
        if (!file_exists($filePath)) {
            \Log::error("Fichier attachment introuvable: " . $att->file);
            abort(404, 'Fichier introuvable');
        }
    }

    // Déterminer le Content-Type
    $extension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
    $mimeTypes = [
        'pdf' => 'application/pdf',
        'jpg' => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'png' => 'image/png',
    ];

    $contentType = $mimeTypes[$extension] ?? mime_content_type($filePath);
    
    // Vérifier si le téléchargement est demandé
    if (request()->has('download')) {
        return response()->download($filePath, basename($filePath), [
            'Content-Type' => $contentType,
        ]);
    }

    // Afficher le fichier dans le navigateur
    return response()->file($filePath, [
        'Content-Type' => $contentType,
        'Content-Disposition' => 'inline; filename="' . basename($filePath) . '"',
        'Cache-Control' => 'no-store, no-cache, must-revalidate, max-age=0',
        'Pragma' => 'no-cache',
        'Expires' => '0',
    ]);
}


//    public function update(Request $request, $id)
// {
//     $request->validate([
//         'sujet' => 'nullable|string|max:255',
//         'sport_type' => 'nullable|string|max:255',
//         'event_name' => 'nullable|string|max:255',
//         'objectif' => 'nullable|string',
//         'commentaire_motif' => 'nullable|string',
//         'type_formulaire_id' => 'required|integer',
//         'statut_id' => 'nullable|integer',
//         'statut2_id' => 'nullable|integer',
//         'commentaire_motif2' => 'nullable|string|max:255',
//         'commentaire_motif3' => 'nullable|string|max:255',
//         'file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:4096',
//         'id_type' => 'nullable|integer',
//         'organisme_non_sportif_id' => 'nullable|integer',
//         'role' => 'nullable|string',
//         'periode_min' => 'nullable|date',
//         'periode_max' => 'nullable|date|after_or_equal:periode_min',
//         'lieu' => 'nullable|string|max:255',
//         // Organisme fields
//         'org' => 'nullable|array',
//         'org.nom' => 'nullable|string|max:255',
//         'org.num_visa' => 'nullable|integer',
//         'org.date_enregistrement' => 'nullable|date',
//         'org.num_enregistrement' => 'nullable|string|max:50',
//         'org.identifiant_fiscal' => 'nullable|numeric',
//         'org.num_compte_bancaire' => 'nullable|string|max:50',
//         'org.adresse' => 'nullable|string|max:255',
//         'org.tel' => 'nullable|string|max:20',
//         'org.fax' => 'nullable|string|max:20',
//         'org.email' => 'nullable|email|max:255',
//         'org.type_formulaire_id' => 'nullable|integer',
//         // EvenementSportif
//         'nom_even' => 'required_with:date|string|max:100',
//         'objectifs' => 'nullable|string',
//         'contenus' => 'nullable|string',
//         'date' => 'required_with:nom_even|date',
//         'heure' => 'nullable|date_format:H:i',
//         'instalation_sportives' => 'nullable|string|max:200',
//         'reference' => 'nullable|string|max:100',
//         'estimation_evenement' => 'nullable|numeric',
//         'cout_total_evenement' => 'nullable|numeric',
//         'difference_estimee' => 'nullable|numeric',
//         'recompense' => 'nullable|string',
//         'moyen_transport' => 'nullable|string|max:200',
//         'gouvernorat_id' => 'required_with:nom_even|integer',
//         'delegation_id' => 'required_with:nom_even|integer',
//         // collections
//         'membres.*.nom_prenom' => 'required_with:membres|string|max:255',
//         'invites.*.nom_prenom' => 'required_with:invites|string|max:255',
//         'assoc_participantes.*.nom' => 'required_with:assoc_participantes|string|max:255',
//         'athletes.*.nom_prenom_sportif' => 'nullable|string|max:255',
//         'sportifs.*.nom_prenom' => 'required_with:sportifs|string|max:255',
//         // attachements
//         'assurance_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
//         'technique_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
//         'accord_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
//         'demande_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
//         // touristes
//         'touristes.*.nom_prenom' => 'nullable|string|max:255',
//         'touristes.*.pays_origine' => 'nullable|string|max:255',
//         'touristes.*.num_passport' => 'nullable|string|max:50',
//         'touristes.*.date_arrive' => 'nullable|date',
//         'touristes.*.lieu_residence' => 'nullable|string|max:255',
//         'touristes.*.date_depart' => 'nullable|date',
//         'touriste2s.*.nom_prenom' => 'nullable|string|max:255',
//         'touriste2s.*.pays_origine' => 'nullable|string|max:255',
//         'touriste2s.*.num_passport' => 'nullable|string|max:50',
//         'touriste2s.*.date_arrive' => 'nullable|date',
//         'touriste2s.*.lieu_residence' => 'nullable|string|max:255',
//         'touriste2s.*.date_depart' => 'nullable|date',
//         'touriste3s.*.nom_prenom' => 'nullable|string|max:255',
//         'touriste3s.*.pays_origine' => 'nullable|string|max:255',
//         'touriste3s.*.num_passport' => 'nullable|string|max:50',
//         'touriste3s.*.date_arrive' => 'nullable|date',
//         'touriste3s.*.lieu_residence' => 'nullable|string|max:255',
//         'touriste3s.*.date_depart' => 'nullable|date',
//     ]);

//     DB::beginTransaction();

//     try {
//         $demande = DemandeManifestation::findOrFail($id);

//         // -------------------------
//         // Organisme: update or create
//         // -------------------------
//         $organisme = null;
//         $orgInput = $request->input('org', null);
//         if (is_array($orgInput) && count(array_filter($orgInput)) > 0) {
//             $orgInput['type_formulaire_id'] = $orgInput['type_formulaire_id'] ?? 14;

//             if ($demande->organisme_non_sportif_id) {
//                 $organisme = OrganismeNonSportif::find($demande->organisme_non_sportif_id);
//                 if ($organisme) {
//                     $organisme->fill($orgInput);
//                     $organisme->save();
//                 } else {
//                     $organisme = OrganismeNonSportif::create($orgInput);
//                 }
//             } else {
//                 $organisme = OrganismeNonSportif::create($orgInput);
//             }

//             $pkName = $organisme->getKeyName();
//             $demande->organisme_non_sportif_id = $organisme->{$pkName};
//         }

//         // -------------------------
//         // Main file handling (LONGBLOB approach)
//         // -------------------------
//         // Keep the existing file unless a new one is uploaded.
//         $hasUploadedMainFile = $request->hasFile('file');
//         $mainFileBinary = null;
//         $mainFileMime = null;
//         if ($hasUploadedMainFile) {
//             $uploadedFile = $request->file('file');
//             $mainFileBinary = file_get_contents($uploadedFile->getRealPath());
//             $mainFileMime = $uploadedFile->getMimeType();
//         }

//         // capture old status values
//         $ancienStatut  = $demande->getOriginal('id_type');
//         $ancienStatut1 = $demande->getOriginal('statut_id');
//         $ancienStatut2 = $demande->getOriginal('statut2_id');

//         // -------------------------
//         // Build update array (avoid undefined vars)
//         // -------------------------
//         $updateData = [
//             'sujet' => $request->input('sujet'),
//             'sport_type' => $request->input('sport_type'),
//             'event_name' => $request->input('event_name'),
//             'objectif' => $request->input('objectif'),
//             'commentaire_motif' => $request->input('commentaire_motif'),
//             'commentaire_motif2' => $request->input('commentaire_motif2'),
//             'commentaire_motif3' => $request->input('commentaire_motif3'),
//             'type_formulaire_id' => $request->input('type_formulaire_id', $demande->type_formulaire_id),
//             'user_id' => $demande->user_id,
//             'id_type' => $request->input('id_type', $demande->id_type),
//             'statut_id' => $request->input('statut_id', $demande->statut_id),
//             'statut2_id' => $request->input('statut2_id', $demande->statut2_id),
//             'role' => $request->input('role'),
//             'periode_min' => $request->input('periode_min'),
//             'periode_max' => $request->input('periode_max'),
//             'lieu' => $request->input('lieu'),
//             'organisme_non_sportif_id' => $demande->organisme_non_sportif_id,
//         ];

//         // include main file binary only if uploaded (otherwise keep existing DB value)
//         if ($hasUploadedMainFile) {
//             $updateData['file'] = $mainFileBinary;
//         }

//         // Perform update on DemandeManifestation
//         $demande->update($updateData);

//         // -------------------------
//         // Attachments (store binary + mime_type)
//         // -------------------------
//         $attachmentsMap = [
//             'assurance_file' => 2,
//             'accord_file'    => 7,
//             'technique_file' => 8,
//             'demande_file'   => 9,
//         ];

//         foreach ($attachmentsMap as $inputName => $typeId) {
//             if ($request->hasFile($inputName)) {
//                 $file = $request->file($inputName);
//                 $binary = file_get_contents($file->getRealPath());
//                 $mime = $file->getMimeType();

//                 $oldAttachment = Attachement::where('id_demande', $demande->id_demande)
//                     ->where('id_type_attach', $typeId)
//                     ->first();

//                 if ($oldAttachment) {
//                     $oldAttachment->update([
//                         'file' => $binary,
//                         'mime_type' => $mime,
//                     ]);
//                 } else {
//                     Attachement::create([
//                         'id_demande' => $demande->id_demande,
//                         'id_type_attach' => $typeId,
//                         'file' => $binary,
//                         'mime_type' => $mime,
//                     ]);
//                 }
//             }
//         }

//         // -------------------------
//         // EvenementSportif and related collections
//         // -------------------------
//         $evenement = EvenementSportif::where('demande_id', $demande->id_demande)->first();

//         if ($request->has('nom_even')) {
//             $evenData = [
//                 'nom_even' => $request->input('nom_even'),
//                 'objectifs' => $request->input('objectifs'),
//                 'contenus' => $request->input('contenus'),
//                 'date' => $request->input('date'),
//                 'heure' => $request->input('heure'),
//                 'instalation_sportives' => $request->input('instalation_sportives'),
//                 'reference' => $request->input('reference'),
//                 'estimation_evenement' => $request->input('estimation_evenement'),
//                 'cout_total_evenement' => $request->input('cout_total_evenement'),
//                 'difference_estimee' => $request->input('difference_estimee'),
//                 'recompense' => $request->input('recompense'),
//                 'moyen_transport' => $request->input('moyen_transport'),
//                 'user_id' => Auth::id(),
//                 'id_type' => $request->input('id_type', 2),
//                 'id_formulaire' => $request->input('id_formulaire', 15),
//                 'gouvernorat_id' => $request->input('gouvernorat_id'),
//                 'delegation_id' => $request->input('delegation_id'),
//                 'demande_id' => $demande->id_demande,
//             ];

//             if ($evenement) {
//                 $evenement->update($evenData);
//             } else {
//                 $evenement = EvenementSportif::create($evenData);
//             }

//             // delete old related rows then re-create
//             MembreOrgInvite::where('event_id', $evenement->id_even)->delete();
//             AssocParticipante::where('event_id', $evenement->id_even)->delete();
//             AthleteIndividuel::where('event_id', $evenement->id_even)->delete();
//             SportifParticipant::where('even_id', $evenement->id_even)->delete();
//             Etrangere::where('even_id', $evenement->id_even)->delete();

//             if ($request->has('membres')) {
//                 foreach ($request->input('membres', []) as $membre) {
//                     MembreOrgInvite::create([
//                         'nom_prenom' => $membre['nom_prenom'],
//                         'role' => $membre['role'] ?? null,
//                         'nationalite' => $membre['nationalite'] ?? null,
//                         'event_id' => $evenement->id_even,
//                         'type_membre_id' => 1,
//                     ]);
//                 }
//             }

//             if ($request->has('invites')) {
//                 foreach ($request->input('invites', []) as $invite) {
//                     MembreOrgInvite::create([
//                         'nom_prenom' => $invite['nom_prenom'],
//                         'role' => $invite['role'] ?? null,
//                         'nationalite' => $invite['nationalite'] ?? null,
//                         'event_id' => $evenement->id_even,
//                         'type_membre_id' => 2,
//                     ]);
//                 }
//             }

//             if ($request->has('assoc_participantes')) {
//                 foreach ($request->input('assoc_participantes', []) as $assoc) {
//                     $num_h = isset($assoc['num_athlete_h']) ? (int)$assoc['num_athlete_h'] : 0;
//                     $num_f = isset($assoc['num_athlete_f']) ? (int)$assoc['num_athlete_f'] : 0;
//                     $accomp = isset($assoc['accompagnants']) ? (int)$assoc['accompagnants'] : 0;
//                     $total = $num_h + $num_f + $accomp;

//                     AssocParticipante::create([
//                         'nom' => $assoc['nom'] ?? null,
//                         'num_athlete_h' => $num_h,
//                         'num_athlete_f' => $num_f,
//                         'accompagnants' => $accomp,
//                         'total' => $total,
//                         'event_id' => $evenement->id_even,
//                     ]);
//                 }
//             }

//             if ($request->has('athletes')) {
//                 foreach ($request->input('athletes', []) as $athlete) {
//                     AthleteIndividuel::create([
//                         'nom_prenom_sportif' => $athlete['nom_prenom_sportif'],
//                         'num_athlete_h' => $athlete['num_athlete_h'] ?? 0,
//                         'num_athlete_f' => $athlete['num_athlete_f'] ?? 0,
//                         'accompagnants' => $athlete['accompagnants'] ?? 0,
//                         'event_id' => $evenement->id_even,
//                     ]);
//                 }
//             }

//             if ($request->has('sportifs')) {
//                 foreach ($request->input('sportifs', []) as $sportif) {
//                     SportifParticipant::create([
//                         'nom_prenom' => $sportif['nom_prenom'],
//                         'tranch_age' => $sportif['tranch_age'] ?? null,
//                         'date_naissance' => $sportif['date_naissance'] ?? null,
//                         'num_cin' => $sportif['num_cin'] ?? null,
//                         'invitee' => $sportif['invitee'] ?? null,
//                         'even_id' => $evenement->id_even,
//                         'jeune_id' => $sportif['jeune_id'] ?? null,
//                     ]);
//                 }
//             }

//             // touristes (Etrangere)
//             if ($request->has('touristes')) {
//                 foreach ($request->input('touristes', []) as $touriste) {
//                     Etrangere::create([
//                         'nom_prenom' => $touriste['nom_prenom'] ?? null,
//                         'pays_origine' => $touriste['pays_origine'] ?? null,
//                         'num_passport' => $touriste['num_passport'] ?? null,
//                         'date_arrive' => $touriste['date_arrive'] ?? null,
//                         'lieu_residence' => $touriste['lieu_residence'] ?? null,
//                         'date_depart' => $touriste['date_depart'] ?? null,
//                         'even_id' => $evenement->id_even,
//                         'type_etranger_id' => 1,
//                     ]);
//                 }
//             }
//             if ($request->has('touriste2s')) {
//                 foreach ($request->input('touriste2s', []) as $touriste2) {
//                     Etrangere::create([
//                         'nom_prenom' => $touriste2['nom_prenom'] ?? null,
//                         'pays_origine' => $touriste2['pays_origine'] ?? null,
//                         'num_passport' => $touriste2['num_passport'] ?? null,
//                         'date_arrive' => $touriste2['date_arrive'] ?? null,
//                         'lieu_residence' => $touriste2['lieu_residence'] ?? null,
//                         'date_depart' => $touriste2['date_depart'] ?? null,
//                         'even_id' => $evenement->id_even,
//                         'type_etranger_id' => 2,
//                     ]);
//                 }
//             }
//             if ($request->has('touriste3s')) {
//                 foreach ($request->input('touriste3s', []) as $touriste3) {
//                     Etrangere::create([
//                         'nom_prenom' => $touriste3['nom_prenom'] ?? null,
//                         'pays_origine' => $touriste3['pays_origine'] ?? null,
//                         'num_passport' => $touriste3['num_passport'] ?? null,
//                         'date_arrive' => $touriste3['date_arrive'] ?? null,
//                         'lieu_residence' => $touriste3['lieu_residence'] ?? null,
//                         'date_depart' => $touriste3['date_depart'] ?? null,
//                         'even_id' => $evenement->id_even,
//                         'type_etranger_id' => 3,
//                     ]);
//                 }
//             }
//         } // end evenement handling

//         // -------------------------
//         // Status history creation (after update)
//         // -------------------------
//         $normalize = function ($v) {
//             if (is_null($v) || $v === '') return null;
//             $i = (int) $v;
//             return ($i > 0) ? $i : null;
//         };

//         $old_id_type    = $normalize($ancienStatut);
//         $old_statut_id  = $normalize($ancienStatut1);
//         $old_statut2_id = $normalize($ancienStatut2);

//         // refresh model to ensure we compare current persisted values
//         $demande->refresh();

//         $new_id_type    = $normalize($demande->id_type);
//         $new_statut_id  = $normalize($demande->statut_id);
//         $new_statut2_id = $normalize($demande->statut2_id);

//         $statExists = function ($id) {
//             if (is_null($id)) return false;
//             return DB::table('tp_statut')->where('id_statut', $id)->exists();
//         };

//         $commentForHistory = null;
//         if ($request->filled('commentaire_motif')) {
//             $commentForHistory = trim($request->input('commentaire_motif'));
//         } elseif ($request->filled('commentaire_motif2')) {
//             $commentForHistory = trim($request->input('commentaire_motif2'));
//         } elseif ($request->filled('commentaire_motif3')) {
//             $commentForHistory = trim($request->input('commentaire_motif3'));
//         }

//         if ($old_id_type !== $new_id_type) {
//             ImmobilierStatutHistory::create([
//                 'demande_manifestation_id' => $demande->id_demande,
//                 'from_statut_id' => $old_id_type,
//                 'to_statut_id' => $statExists($new_id_type) ? $new_id_type : null,
//                 'changed_by' => Auth::id() ?? null,
//                 'commentaire' => $commentForHistory,
//             ]);
//         }

//         if ($old_statut_id !== $new_statut_id) {
//             ImmobilierStatutHistory::create([
//                 'demande_manifestation_id' => $demande->id_demande,
//                 'from_statut_id' => $old_statut_id,
//                 'to_statut_id' => $statExists($new_statut_id) ? $new_statut_id : null,
//                 'changed_by' => Auth::id() ?? null,
//                 'commentaire' => $commentForHistory,
//             ]);
//         }

//         if ($old_statut2_id !== $new_statut2_id) {
//             ImmobilierStatutHistory::create([
//                 'demande_manifestation_id' => $demande->id_demande,
//                 'from_statut_id' => $old_statut2_id,
//                 'to_statut_id' => $statExists($new_statut2_id) ? $new_statut2_id : null,
//                 'changed_by' => Auth::id() ?? null,
//                 'commentaire' => $commentForHistory,
//             ]);
//         }

//         // -------------------------
//         // Notifications & Mail
//         // -------------------------
        
// try {
//         // Refresh the model and user
//         $demande = DemandeManifestation::with('utilisateur')->findOrFail($id);
//         $user = $demande->utilisateur;

//         // Determine which status was changed (prefer request inputs)
//         $resolved = (int) ($request->input('id_type') ?? $request->input('statut_id') ?? $request->input('statut2_id') ?? 0);
//         if ($resolved <= 0) {
//             // nothing to notify
//             return redirect()->route('admin.manifestation2.index', $demande->id_demande)
//                              ->with('success', 'تم تحديث الطلب بنجاح');
//         }

//         // Status normalization
//         $statusMap = [
//             1 => 'accepted',
//             3 => 'rejected',
//             4 => 'incomplete',
//             5 => 'deferred',
//         ];
//         $type = $statusMap[$resolved] ?? 'status_changed';

//         // Build dossier reference
//         $idPad = str_pad($demande->id_demande, 3, '0', STR_PAD_LEFT);
//         $cin = $user->num_cin ?? $user->cin ?? '';
//         $cinDigits = preg_replace('/\D+/', '', $cin);
//         $cinPad = $cinDigits ? str_pad($cinDigits, 9, '0', STR_PAD_LEFT) : '000000000';
//         $year = $demande->created_at ? $demande->created_at->format('Y') : now()->format('Y');
//         $num_dossier = "{$idPad}-{$cinPad}-{$year}";

//         // Prepare comment (prefer saved model fields, fallback to request)
//         $messageComment = trim(($demande->commentaire_motif ?? '') . ' ' . ($demande->commentaire_motif2 ?? '') . ' ' . ($demande->commentaire_motif3 ?? ''));
//         if ($messageComment === '') {
//             $messageComment = trim($request->input('commentaire_motif') ?? $request->input('commentaire_motif2') ?? $request->input('commentaire_motif3') ?? '');
//         }
//         $messageComment = $messageComment !== '' ? $messageComment : null;

//         // Build HTML messageStatus (comments are escaped with e())
//         $nomUtilisateur = $user->nom_prenom ?? 'المستخدم';
//         $date = now()->format('Y-m-d');

//         switch ($resolved) {
//             case 1: // accepted
//                 $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم قبول طلبكم بتاريخ: <strong>{$date}</strong>.<br>نهنئكم على هذا القبول.";
//                 break;

//             case 3: // rejected
//                 $reason = e($messageComment ?? 'سبب غير محدد');
//                 $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم رفض طلبكم.<br>السبب: <b>{$reason}</b>.";
//                 break;

//             case 4: // incomplete
//                 $missing = e($request->input('commentaire_acceptation') ?? $messageComment ?? 'يرجى استكمال الوثائق المطلوبة');
//                 $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>طلبكم <strong>غير مكتمل</strong>.<br>التوضيح: <b>{$missing}</b>.";
//                 break;

//             case 5: // deferred
//                 $note = e($request->input('commentaire_avis') ?? $messageComment ?? 'لا يوجد ملاحظات');
//                 $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم إرجاء طلبكم.<br>الملاحظة: <b>{$note}</b>.";
//                 break;

//             default:
//                 $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم تحديث حالة ملفكم.";
//         }

//         // Build translation params for DB notification
//         $params = [];
//         if ($resolved === 3) $params['reason'] = $messageComment ?? '';
//         if ($resolved === 4) $params['missing'] = $request->input('commentaire_acceptation') ?? ($messageComment ?? '');
//         if ($resolved === 5) $params['note'] = $request->input('commentaire_avis') ?? ($messageComment ?? '');
//         if ($resolved === 1) $params['date'] = $date;
//         $params['reference'] = $num_dossier;
//         if (!empty($messageComment)) $params['comment'] = $messageComment;

//         // Send mail (best-effort)
//         if (!empty($user->email)) {
//             try {
//                 Mail::to($user->email)->send(new \App\Mail\StatutDemande2Mail($user, $num_dossier, $messageStatus, $type, $messageComment));
//             } catch (\Exception $ex) {
//                 Log::error("Mail error after update for DemandeManifestation {$demande->id_demande}: " . $ex->getMessage());
//             }
//         }

//         // DB Notification (best-effort)
//         try {
//             if ($user) {
//                 $translationKey = "site.notifications.manifestation.{$type}";
//                 $user->notify(new \App\Notifications\StatutDemande2Notification($demande->fresh('utilisateur'), $type, $params, $demande->id_demande, $translationKey));
//             }
//         } catch (\Exception $ex) {
//             Log::error("Notification error after update for DemandeManifestation {$demande->id_demande}: " . $ex->getMessage());
//         }

//         return redirect()->route('admin.manifestation2.index', $demande->id_demande)
//                          ->with('success', 'تم تحديث الطلب بنجاح');
//     } catch (\Exception $e) {
//         Log::error("Error notifying after update DemandeManifestation {$id}: " . $e->getMessage());
//         // fallback redirect (your existing exception handling likely already does DB::rollBack earlier)
//         return redirect()->back()->with('error', 'خطأ أثناء إرسال الإشعار: ' . $e->getMessage());
//     }
     

// 	 DB::commit();

//         session()->forget('_old_input');

//         return redirect()->route('admin.manifestation2.index', $demande->id_demande)
//                          ->with('success', 'تم تحديث الطلب بنجاح');
//     } catch (\Exception $e) {
//         DB::rollBack();
//         Log::error("Error updating DemandeManifestation {$id}: " . $e->getMessage());
//         return redirect()->back()->withInput()->with('error', 'حدث خطأ أثناء التحديث: ' . $e->getMessage());
//     }
// }






    public function destroy($id)
    {
        $demande = DemandeManifestation::findOrFail($id);

        foreach ($demande->attachements as $attachement) {
            if ($attachement->chemin && Storage::exists($attachement->chemin)) {
                Storage::delete($attachement->chemin);
            }
            $attachement->delete();
        }

        if ($demande->teamsAssociations) {
            foreach ($demande->teamsAssociations as $team) {
                $team->delete();
            }
        }

        if ($demande->evenementSportif) {
            $demande->evenementSportif->delete();
        }

        if ($demande->organismeNonSportif) {
            $demande->organismeNonSportif->delete();
        }

        $demande->delete();

        return redirect()->route('admin.manifestation2.index')->with('success', 'تم حذف الطلب بنجاح.');
    }

public function toggleStatut(Request $request, $id)
{
    $request->validate([
        'id_statut' => 'nullable|integer|in:1,2,3,4,5',
        'statut_id' => 'nullable|integer|in:1,2,3,4,5',
        'statut2_id'=> 'nullable|integer|in:1,2,3,4,5',
        'commentaire_motif'  => 'nullable|string',
        'commentaire_motif2' => 'nullable|string',
        'commentaire_motif3' => 'nullable|string',
        'commentaire_acceptation' => 'nullable|string',
        'commentaire_avis' => 'nullable|string',
        'file' => 'nullable|file',
    ]);

    $demande = DemandeManifestation::with('utilisateur')->findOrFail($id);
    $user = $demande->utilisateur;

    // Capture originals for history
    $orig_id_type   = $demande->getOriginal('id_type');
    $orig_statut_id = $demande->getOriginal('statut_id');
    $orig_statut2   = $demande->getOriginal('statut2_id');

    // Apply incoming values and comments
    if ($request->has('id_statut')) {
        $demande->id_type = $request->input('id_statut');
        if ($request->filled('commentaire_motif')) {
            $demande->commentaire_motif = $request->input('commentaire_motif');
        }
    }
    if ($request->has('statut_id')) {
        $demande->statut_id = $request->input('statut_id');
        if ($request->filled('commentaire_motif2')) {
            $demande->commentaire_motif2 = $request->input('commentaire_motif2');
        }
    }
    if ($request->has('statut2_id')) {
        $demande->statut2_id = $request->input('statut2_id');
        if ($request->filled('commentaire_motif3')) {
            $demande->commentaire_motif3 = $request->input('commentaire_motif3');
        }
    }
    if ($request->hasFile('file')) {
        $f = $request->file('file');
        $filename = time() . '_' . $f->getClientOriginalName();
        $path = $f->storeAs('public/files', $filename);
        $demande->file = $filename;
    }

    // Determine which field changed and new value (priority: id_type, statut_id, statut2_id)
    $changedField = null;
    $newValue = null;
    if ($request->has('id_statut') && ((int)$orig_id_type !== (int)$demande->id_type)) {
        $changedField = 'id_type';
        $newValue = (int) $demande->id_type;
    } elseif ($request->has('statut_id') && ((int)$orig_statut_id !== (int)$demande->statut_id)) {
        $changedField = 'statut_id';
        $newValue = (int) $demande->statut_id;
    } elseif ($request->has('statut2_id') && ((int)$orig_statut2 !== (int)$demande->statut2_id)) {
        $changedField = 'statut2_id';
        $newValue = (int) $demande->statut2_id;
    }

    // Save and record history only if something changed
    DB::beginTransaction();
    try {
        $demande->save();

        if ($changedField) {
            ImmobilierStatutHistory::create([
                'demande_manifestation_id' => $demande->id_demande,
                'from_statut_id' => ($changedField === 'id_type' ? $orig_id_type : ($changedField === 'statut_id' ? $orig_statut_id : $orig_statut2)) ?: null,
                'to_statut_id'   => $newValue ?: null,
                'changed_by'     => Auth::id() ?? null,
                'commentaire'    => trim($request->input('commentaire_motif') ?? $request->input('commentaire_motif2') ?? $request->input('commentaire_motif3') ?? ''),
            ]);
        }

        DB::commit();
    } catch (\Exception $e) {
        DB::rollBack();
        Log::error("toggleStatut error for DemandeManifestation #{$id}: " . $e->getMessage());
        return back()->withErrors(['error' => 'خطأ أثناء تغيير الحالة: ' . $e->getMessage()]);
    }

    // Build dossier + message like update()
    $idPad = str_pad($demande->id_demande, 3, '0', STR_PAD_LEFT);
    $cin = $user->num_cin ?? $user->cin ?? '';
    $cinDigits = preg_replace('/\D+/', '', $cin);
    $cinPad = $cinDigits ? str_pad($cinDigits, 9, '0', STR_PAD_LEFT) : '000000000';
    $year = $demande->created_at ? $demande->created_at->format('Y') : now()->format('Y');
    $num_dossier = "{$idPad}-{$cinPad}-{$year}";
    $nomUtilisateur = $user->nom_prenom ?? 'المستخدم';
    $date = now()->format('Y-m-d');

    $resolved = (int) ($newValue ?? ($request->input('id_statut') ?? $request->input('statut_id') ?? $request->input('statut2_id') ?? 0));
    $statusMap = [1 => 'accepted', 3 => 'rejected', 4 => 'incomplete', 5 => 'deferred'];
    $type = $statusMap[$resolved] ?? 'status_changed';

    $messageComment = trim(($demande->commentaire_motif ?? '') . ' ' . ($demande->commentaire_motif2 ?? '') . ' ' . ($demande->commentaire_motif3 ?? ''));
    $messageComment = $messageComment !== '' ? $messageComment : null;

    switch ($resolved) {
        case 1:
            $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم قبول طلبكم بتاريخ: <strong>{$date}</strong>.<br>نهنئكم على هذا القبول.";
            break;
        case 3:
            $reason = e($messageComment ?? 'سبب غير محدد');
            $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم رفض طلبكم.<br>السبب: <b>{$reason}</b>.";
            break;
        case 4:
            $missing = e($request->input('commentaire_acceptation') ?? $messageComment ?? 'يرجى استكمال الوثائق المطلوبة');
            $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>طلبكم <strong>غير مكتمل</strong>.<br>التوضيح: <b>{$missing}</b>.";
            break;
        case 5:
            $note = e($request->input('commentaire_avis') ?? $messageComment ?? 'لا يوجد ملاحظات');
            $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم إرجاء طلبكم.<br>الملاحظة: <b>{$note}</b>.";
            break;
        default:
            $messageStatus = "مرحباً <strong>{$nomUtilisateur}</strong>،<br>رقم الملف: <strong>{$num_dossier}</strong><br>تم تحديث حالة ملفكم.";
    }

    // Send mail
    if (!empty($user->email)) {
        try {
            Mail::to($user->email)->send(new \App\Mail\StatutDemande2Mail($user, $num_dossier, $messageStatus, $type, $messageComment));
        } catch (\Exception $ex) {
            Log::error("toggleStatut mail failed for DemandeManifestation {$demande->id_demande}: " . $ex->getMessage());
        }
    }

    // DB notification
    try {
        if ($user) {
            $params = [];
            if ($resolved === 3) $params['reason'] = $messageComment ?? '';
            if ($resolved === 4) $params['missing'] = $request->input('commentaire_acceptation') ?? ($messageComment ?? '');
            if ($resolved === 5) $params['note'] = $request->input('commentaire_avis') ?? ($messageComment ?? '');
            if ($resolved === 1) $params['date'] = $date;
            $params['reference'] = $num_dossier;

            $translationKey = "site.notifications.manifestation.{$type}";
            $user->notify(new \App\Notifications\StatutDemande2Notification($demande->fresh('utilisateur'), $type, $params, $demande->id_demande, $translationKey));
        }
    } catch (\Exception $ex) {
        Log::error("toggleStatut notification failed for DemandeManifestation {$demande->id_demande}: " . $ex->getMessage());
    }

    $statut_ar = $resolved == 1 ? 'قبول' : ($resolved == 3 ? 'رفض' : 'تم التغيير');
    return redirect()->back()->with('success', "تم تغيير الحالة إلى $statut_ar");
}

    
	    public function getDelegations2_manifestation($gouvernoratId)    {
			$delegations = Delegation::where('gouver_id', $gouvernoratId)->get();
			return response()->json($delegations);   
		}
}