<?php

namespace App\Http\Controllers\Investissement;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\TypeFormulaire;
use App\Models\Identite_personnel;
use App\Models\TpStatut;
use App\Models\Utilisateur;
use App\Models\Gouvernorat;
use App\Models\Delegation;
use App\Models\Immobilier;
use App\Models\Type_immobilier;
use App\Models\Usage_immobilier;
use App\Mail\SalleSportStatutMail;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;
use App\Notifications\SalleSportStatutNotification;
use App\Models\DocumentsFormulaire;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Mpdf\Mpdf;
use PDF;
use App\Models\ImmobilierStatutHistory;

class SalleSportController extends Controller
{
    public function index(Request $request)
{
    $query = Immobilier::with(['utilisateur', 'statut', 'debutActivite'])
        ->where('id_type_formulaire', 1);

    if ($request->filled('search_option') && $request->search_option === 'date' && $request->filled('date')) {
        $query->whereDate('created_at', $request->date);
    }

    if ($request->filled('search_option') && $request->search_option === 'type_identite' && $request->filled('type_identite')) {
        $type = $request->type_identite;

        if ($type == 1 && $request->filled('cin')) {
            $query->whereHas('utilisateur', fn($q) => $q->where('cin', $request->cin));
        }
        if ($type == 2 && $request->filled('passport')) {
            $query->whereHas('utilisateur', fn($q) => $q->where('passport', $request->passport));
        }
        if ($type == 3 && $request->filled('num_fiscal')) {
            $query->whereHas('utilisateur', fn($q) => $q->where('num_fiscal', $request->num_fiscal));
        }
    }

    $salles = $query->latest()->paginate(10)->withQueryString();

    $typesIdentite = Identite_personnel::all(); 
    return view('backoffice.investissement.gestion_salle_sport.salle_sport.index', compact('salles', 'typesIdentite'));
}



public function exportPdf()
{
    $salles = Immobilier::with(['utilisateur', 'statut'])
        ->where('id_type_formulaire', 1)
        ->latest()
        ->get();

    $html = view('backoffice.investissement.gestion_salle_sport.exports.salles_sport_pdf', compact('salles'))->render();

    $mpdf = new Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
    ]);

    $mpdf->WriteHTML($html);

    return response($mpdf->Output('salles_sport.pdf', 'S'))
        ->header('Content-Type', 'application/pdf');
}



/*public function exportPdf(Request $request)
{
    $query = Immobilier::with(['utilisateur', 'statut'])
        ->where('id_type_formulaire', 1);

    // نفس الفلاتر (اختياري)
    if ($request->filled('search_option') && $request->search_option === 'date' && $request->filled('date')) {
        $query->whereDate('created_at', $request->date);
    }

    $salles = $query->latest()->get();

    $pdf = Pdf::loadView('backoffice.investissement.gestion_salle_sport.exports.salles_sport_pdf', [
        'salles' => $salles
    ])->setPaper('a4', 'landscape'); // أفقي أفضل للجدول

    return $pdf->download('salles_sport.pdf');
}*/


public function exportExcel(Request $request)
{
    $query = Immobilier::with(['utilisateur', 'statut'])
        ->where('id_type_formulaire', 1);

    // (اختياري) نفس الفلاتر الموجودة في index
    if ($request->filled('search_option') && $request->search_option === 'date' && $request->filled('date')) {
        $query->whereDate('created_at', $request->date);
    }

    $salles = $query->latest()->get();

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setRightToLeft(true); // عربي RTL

    // Header
    $sheet->fromArray([
        'المعرف',
        'تاريخ الإيداع',
        'إسم مقدم الطلب',
        'وضعية الطلب',
    ], null, 'A1');

    // Style header
    $sheet->getStyle('A1:D1')->getFont()->setBold(true);

    // Data
    $row = 2;
    foreach ($salles as $salle) {
        $sheet->setCellValue('A'.$row, $salle->id_imm);
        $sheet->setCellValue('B'.$row, $salle->created_at->format('Y-m-d H:i'));
        $sheet->setCellValue('C'.$row, $salle->utilisateur->nom_prenom ?? '---');
        $sheet->setCellValue('D'.$row, $salle->statut->statut_ar ?? 'في الانتظار');
        $row++;
    }

    // Auto size
    foreach (range('A', 'D') as $col) {
        $sheet->getColumnDimension($col)->setAutoSize(true);
    }

    $writer = new Xlsx($spreadsheet);
    $fileName = 'salles_sport.xlsx';

    return response()->streamDownload(function () use ($writer) {
        $writer->save('php://output');
    }, $fileName);
}


    public function create()
    {
        $formulaire = TypeFormulaire::find(1);
        $typesIdentite = Identite_personnel::all();
        $gouvernorats = Gouvernorat::all();
        $typesImmobilier = Type_immobilier::all();
        $usagesImmobilier = Usage_immobilier::all();

        return view('backoffice.investissement.gestion_salle_sport.salle_sport.create', compact(
            'formulaire', 'typesIdentite', 'gouvernorats', 'typesImmobilier', 'usagesImmobilier'
        ));
    }

    public function store(Request $request)
    {
        /*$request->validate([
            // Utilisateur
            'nom_prenom' => 'required|string|max:100',
            'id_type_identite' => 'required|exists:tp_type_identite_pers,id_type',
            'cin' => 'nullable|digits:8|unique:utilisateur,cin',
            'passport' => 'nullable|digits:12|unique:utilisateur,passport',
            'num_fiscal' => 'nullable|digits:12|unique:utilisateur,num_fiscal',
            'tel' => 'required|string|max:12',
            'email' => 'required|email|unique:utilisateur,email',
            'adresse' => 'required|string|max:100',

            // Immobilier
            'adresse_imm' => 'required|string|max:255',
            'gouvernorat_id' => 'required|exists:tp_gouvernorat,id_gouver',
            'delegation_id' => 'required|exists:tp_delegation,id_delegation',
            'type_imm_id' => 'required|exists:tp_immobilier,id_type',
            'usage_id' => 'required|exists:tp_usage_immobilier,id_usage_imm',
            'superfici_m2' => 'required|integer|min:100',
            'document_propriete' => 'required|file|mimes:pdf,jpg,jpeg,png',
            'salle_exercice' => 'required|in:0,1',
            'nbr_salle_exercice' => 'nullable|integer|min:1|required_if:salle_exercice,1',
            'superface_salle_exercice' => 'nullable|integer|min:1|required_if:salle_exercice,1',
            'piscine' => 'required|in:0,1',
            'nbr_piscine' => 'nullable|integer|min:1|required_if:piscine,1',
            'superface_piscine' => 'nullable|integer|min:1|required_if:piscine,1',
            'vestiaire' => 'required|in:0,1',
            'nbr_vestiaire' => 'nullable|integer|min:1|required_if:vestiaire,1',
            'superface_vestiaire' => 'nullable|integer|min:1|required_if:vestiaire,1',
            'unitaires_sanitaire' => 'required|in:0,1',
            'superface_unitaires_sanitaire' => 'nullable|integer|min:1|required_if:unitaires_sanitaire,1',
           'stockage_conservation' => 'required|in:0,1',
'superface_stockage_conservation' => 'nullable|integer|min:1|required_if:stockage_conservation,1',

            'espace_exterieur' => 'required|in:0,1',
            'superface_espace_exterieur' => 'nullable|integer|min:1|required_if:espace_exterieur,1',
            'garage' => 'required|in:0,1',
            'superface_garage' => 'nullable|integer|min:1|required_if:garage,1',
            'autres_surfaces' => 'nullable|integer|min:0',
        ]);
        */

        $rules = [

        // Utilisateur
        'nom_prenom' => 'required|string|max:100',
        'id_type_identite' => 'required|exists:tp_type_identite_pers,id_type',
        'tel' => 'required|string|max:12',
        'email' => 'required|email|unique:utilisateur,email',
        'adresse' => 'required|string|max:100',

        // Immobilier
        'adresse_imm' => 'required|string|max:255',
        'gouvernorat_id' => 'required|exists:tp_gouvernorat,id_gouver',
        'delegation_id' => 'required|exists:tp_delegation,id_delegation',
        'type_imm_id' => 'required|exists:tp_immobilier,id_type',
        'usage_id' => 'required|exists:tp_usage_immobilier,id_usage_imm',
        'superfici_m2' => 'required|integer|min:100',
        'document_propriete' => 'required|file|mimes:pdf,jpg,jpeg,png',

        'salle_exercice' => 'required|in:0,1',
        'nbr_salle_exercice' => 'nullable|required_if:salle_exercice,1|integer|min:1',
        'superface_salle_exercice' => 'nullable|required_if:salle_exercice,1|integer|min:1',

        'piscine' => 'required|in:0,1',
        'nbr_piscine' => 'nullable|required_if:piscine,1|integer|min:1',
        'superface_piscine' => 'nullable|required_if:piscine,1|integer|min:1',

        'vestiaire' => 'required|in:0,1',
        'nbr_vestiaire' => 'nullable|required_if:vestiaire,1|integer|min:1',
        'superface_vestiaire' => 'nullable|required_if:vestiaire,1|integer|min:1',

        'unitaires_sanitaire' => 'required|in:0,1',
        'superface_unitaires_sanitaire' => 'nullable|required_if:unitaires_sanitaire,1|integer|min:1',

        'stockage_conservation' => 'required|in:0,1',
        'superface_stockage_conservation' => 'nullable|required_if:stockage_conservation,1|integer|min:1',

        'espace_exterieur' => 'required|in:0,1',
        'superface_espace_exterieur' => 'nullable|required_if:espace_exterieur,1|integer|min:1',

        'garage' => 'required|in:0,1',
        'superface_garage' => 'nullable|required_if:garage,1|integer|min:1',

        'autres_surfaces' => 'nullable|integer|min:0',

        // Déclaration sur l’honneur
        'declaration' => 'accepted',
    ];

    $type = (int) $request->id_type_identite;

    // CIN
    if ($type === 1) {
        $rules['cin'] = 'required|digits:8|unique:utilisateur,cin';
    }

    // PASSPORT
    if ($type === 2) {
        $rules['passport'] = 'required|digits_between:8,12|unique:utilisateur,passport';
    }

    // NUM FISCAL (Association / Étranger)
    if ($type === 3) {
        $rules['num_fiscal'] = [
            'required',
            'string',
            'unique:utilisateur,num_fiscal',
            'regex:/^[A-Za-z0-9]{7}\/[A-Za-z]\/[A-Za-z]\/[A-Za-z]\/[A-Za-z0-9]{3}$/'
        ];
    }

    $request->validate($rules);

        // Création de l'utilisateur
        $user = new Utilisateur();
        $user->nom_prenom = $request->nom_prenom ?? null;
        $user->id_type_identite = $request->id_type_identite ?? null;
        $user->cin = $request->cin ?? null;
        $user->passport = $request->passport ?? null;
        $user->num_fiscal = $request->num_fiscal ?? null;
        $user->tel = $request->tel ?? null;
        $user->email = $request->email ?? null;
        $user->adresse = $request->adresse ?? null;
        $user->est_active = true;
        $user->save();

        
		if ($request->hasFile('document_propriete')) {
            $documentPath = $request->file('document_propriete')->store('documents_propriete');
        } else {
            $documentPath = null;
        }
		
		

        // Création de l'immobilier
        $immobilier = new Immobilier();
        $immobilier->adresse_imm = $request->adresse_imm ?? null;
        $immobilier->gouvernorat_id = $request->gouvernorat_id ?? null;
        $immobilier->delegation_id = $request->delegation_id ?? null;
        $immobilier->type_imm_id = $request->type_imm_id ?? null;
        $immobilier->usage_id = $request->usage_id ?? null;
        $immobilier->superfici_m2 = $request->superfici_m2 ?? null;
        $immobilier->document_propriete = $documentPath;
        $immobilier->id_type_formulaire = 1;
        $immobilier->id_statut = 2;
        $immobilier->salle_exercice = $request->salle_exercice;
        $immobilier->nbr_salle_exercice = $request->nbr_salle_exercice;
        $immobilier->superface_salle_exercice = $request->superface_salle_exercice;
        $immobilier->piscine = $request->piscine;
        $immobilier->nbr_piscine = $request->nbr_piscine;
        $immobilier->superface_piscine = $request->superface_piscine;
        $immobilier->vestiaire = $request->vestiaire;
        $immobilier->nbr_vestiaire = $request->nbr_vestiaire;
        $immobilier->superface_vestiaire = $request->superface_vestiaire;
        $immobilier->unitaires_sanitaire = $request->unitaires_sanitaire;
        $immobilier->superface_unitaires_sanitaire = $request->superface_unitaires_sanitaire;
        $immobilier->stockage_conservation = $request->stockage_conservation;
        $immobilier->superface_stockage_conservation = $request->superface_stockage_conservation;
        $immobilier->espace_exterieur = $request->espace_exterieur;
        $immobilier->superface_espace_exterieur = $request->superface_espace_exterieur;
        $immobilier->garage = $request->garage;
        $immobilier->superface_garage = $request->superface_garage;
        $immobilier->autres_surfaces = $request->autres_surfaces;
        $immobilier->user_id = $user->id;
        $immobilier->save();
         return redirect()->route('salle-sport.index')->with('ok', 'تم إنشاء الطلب بنجاح.');
    }

    public function show($id)
    {
        $immobilier = Immobilier::with('utilisateur')->findOrFail($id);
        $formulaire = TypeFormulaire::find(1);
        $typesIdentite = Identite_personnel::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::where('gouver_id', $immobilier->gouvernorat_id)->get();
        $typesImmobilier = Type_immobilier::all();
        $usagesImmobilier = Usage_immobilier::all();
		$statuts = TpStatut::orderBy('id_statut')->get(); 
        return view('backoffice.investissement.gestion_salle_sport.salle_sport.show', compact(
            'immobilier', 'formulaire', 'typesIdentite', 'gouvernorats', 'delegations', 'typesImmobilier', 'usagesImmobilier','statuts'
        ));
    }

    

public function pdf($id)
{
    $immobilier = Immobilier::with('utilisateur')->findOrFail($id);
        $formulaire = TypeFormulaire::find(1);
        $typesIdentite = Identite_personnel::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::where('gouver_id', $immobilier->gouvernorat_id)->get();
        $typesImmobilier = Type_immobilier::all();
        $usagesImmobilier = Usage_immobilier::all();

    $data = compact('immobilier', 'formulaire', 'typesIdentite', 'gouvernorats', 'delegations', 'typesImmobilier', 'usagesImmobilier');

    $html = view('backoffice.investissement.gestion_salle_sport.salle_sport.pdf', $data)->render();

    $mpdf = new \Mpdf\Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans', 
        'directionality' => 'rtl',
        'autoScriptToLang' => true,
        'autoLangToFont' => true,
    ]);

    $mpdf->setFooter('{PAGENO} / {nb}'); 

    $mpdf->WriteHTML($html);

    return $mpdf->Output('consultation_salle_sport.pdf', 'I');
}



    public function edit($id)
    {
        $immobilier = Immobilier::with(['utilisateur', 'statutHistories.toStatut', 'statutHistories.fromStatut', 'statutHistories.changer'])
                    ->findOrFail($id);

        $formulaire = TypeFormulaire::find(1);
        $typesIdentite = Identite_personnel::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::where('gouver_id', $immobilier->gouvernorat_id)->get();
        $typesImmobilier = Type_immobilier::all();
        $usagesImmobilier = Usage_immobilier::all();
		$statuts = TpStatut::orderBy('id_statut')->get(); 
        return view('backoffice.investissement.gestion_salle_sport.salle_sport.edit', compact(
            'immobilier', 'formulaire', 'typesIdentite', 'gouvernorats', 'delegations', 'typesImmobilier', 'usagesImmobilier', 'statuts'
        ));
    }
    
    public function update(Request $request, $id)
    {
        //$immobilier = Immobilier::with('utilisateur')->findOrFail($id);
		$immobilier = Immobilier::with('utilisateur')->where('id_imm', $id)->firstOrFail();
		$rules = [
			// Utilisateur
			'nom_prenom' => 'required|string|max:50',
			'id_type_identite' => 'required|exists:tp_type_identite_pers,id_type',

			'cin' => 'nullable|digits:8|unique:utilisateur,cin,' . $immobilier->utilisateur->id . ',id',
			'passport' => 'nullable|digits_between:8,12|unique:utilisateur,passport,' . $immobilier->utilisateur->id . ',id',
			'num_fiscal' => 'nullable|string|unique:utilisateur,num_fiscal,' . $immobilier->utilisateur->id . ',id',

			'tel' => 'nullable|string|max:12',
			'email' => 'required|email|unique:utilisateur,email,' . $immobilier->utilisateur->id . ',id',
			'adresse' => 'required|string|max:100',

			// Immobilier (inchangé)
			'id_statut' => 'required',
			'adresse_imm' => 'required|string|max:100',
			'commentaire_motif' => 'nullable|string|max:255',
			'gouvernorat_id' => 'required|exists:tp_gouvernorat,id_gouver',
			'delegation_id' => 'required|exists:tp_delegation,id_delegation',
			'type_imm_id' => 'required|exists:tp_immobilier,id_type',
			'usage_id' => 'required|exists:tp_usage_immobilier,id_usage_imm',
			'superfici_m2' => 'required|integer|min:100',
			'document_propriete' => 'sometimes|nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
			'salle_exercice' => 'required|in:0,1',
			'nbr_salle_exercice' => 'nullable|required_if:salle_exercice,1|integer|min:1',
			'superface_salle_exercice' => 'nullable|required_if:salle_exercice,1|integer|min:1',
			'piscine' => 'required|in:0,1',
			'nbr_piscine' => 'nullable|required_if:piscine,1|integer|min:1',
			'superface_piscine' => 'nullable|required_if:piscine,1|integer|min:1',
			'vestiaire' => 'required|in:0,1',
			'nbr_vestiaire' => 'nullable|required_if:vestiaire,1|integer|min:1',
			'superface_vestiaire' => 'nullable|required_if:vestiaire,1|integer|min:1',
			'unitaires_sanitaire' => 'required|in:0,1',
			'superface_unitaires_sanitaire' => 'nullable|required_if:unitaires_sanitaire,1|integer|min:1',
			'stockage_conservation' => 'nullable|in:0,1',
			'superface_stockage_conservation' => 'nullable|required_if:stockage_conservation,1|integer|min:1',
			'espace_exterieur' => 'required|in:0,1',
			'superface_espace_exterieur' => 'nullable|required_if:espace_exterieur,1|integer|min:1',
			'garage' => 'required|in:0,1',
			'superface_garage' => 'nullable|required_if:garage,1|integer|min:1',
			'autres_surfaces' => 'nullable|integer|min:0',
		];
			$type = (int) $request->id_type_identite;

			// CIN
			if ($type === 1) {
				$rules['cin'] = 'required|digits:8|unique:utilisateur,cin,' . $immobilier->utilisateur->id . ',id';
			}

			// PASSPORT
			if ($type === 2) {
				$rules['passport'] = 'required|digits_between:8,12|unique:utilisateur,passport,' . $immobilier->utilisateur->id . ',id';
			}

			// NUM FISCAL
			if ($type === 3) {
				$rules['num_fiscal'] = [
					'required',
					'string',
					'unique:utilisateur,num_fiscal,' . $immobilier->utilisateur->id . ',id',
					'regex:/^[A-Za-z0-9]{7}\/[A-Za-z]\/[A-Za-z]\/[A-Za-z]\/[A-Za-z0-9]{3}$/'
				];
			}
				$request->validate($rules);

			   $oldStatut = (int) $immobilier->id_statut;
			   $newStatut = (int) $request->id_statut;
			   $commentRefus  = $request->input('commentaire_refus');
			   $commentStatus = $request->input('commentaire_status');
		       $comment = null;
			if ($newStatut === 3) { // refusal
				$comment = is_string($commentRefus) ? trim($commentRefus) : null;
			} elseif (in_array($newStatut, [4,5])) { // conditional approval / other
				$comment = is_string($commentStatus) ? trim($commentStatus) : null;
			} else {
				// for other statuses maybe use either if present
				$comment = is_string($commentRefus) && $commentRefus !== '' ? trim($commentRefus)
						 : (is_string($commentStatus) && $commentStatus !== '' ? trim($commentStatus) : null);
			}
		   
        // Update Utilisateur
        $user = $immobilier->utilisateur;
        $user->nom_prenom = $request->nom_prenom;
        $user->id_type_identite = $request->id_type_identite;
        $user->cin = $request->cin;
        $user->passport = $request->passport;
        $user->num_fiscal = $request->num_fiscal;
        $user->tel = $request->tel;
        $user->email = $request->email;
        $user->adresse = $request->adresse;
        $user->save();
		$history = null;
		if ($oldStatut !== $newStatut) {
			$history = ImmobilierStatutHistory::create([
				'immobilier_id'   => $immobilier->id_imm,
				'from_statut_id'  => $oldStatut ?: null,
				'to_statut_id'    => $newStatut ?: null,
				'changed_by'      => Auth::id() ?? null,
				'commentaire'     => $comment,
			]);
		}

if ($request->hasFile('document_propriete')) {

    $file = $request->file('document_propriete');

    // 📌 DOSSIER RÉEL UNIQUE
    $uploadDir = '/home/preprov/www/mjs/shared_uploads/images';

    if (!is_dir($uploadDir) || !is_writable($uploadDir)) {
        abort(500, 'Dossier upload non accessible');
    }

    // 🧹 supprimer ancien fichier
    if (!empty($immobilier->document_propriete) && file_exists($immobilier->document_propriete)) {
        @unlink($immobilier->document_propriete);
    }

    // 🔒 nom sécurisé
    $original = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
    $ext = $file->getClientOriginalExtension();

    $safe = Str::slug(mb_substr($original, 0, 40));
    if ($safe === '') {
        $safe = 'document';
    }

    $filename = $safe . '-' . time() . '.' . $ext;
    $targetPath = $uploadDir . DIRECTORY_SEPARATOR . $filename;

    // 🚀 upload réel
    $file->move($uploadDir, $filename);

    // 🔐 chemin canonique
    $realPath = realpath($targetPath);
    if ($realPath === false) {
        abort(500, 'Erreur lors de la sauvegarde du fichier');
    }

    // 💾 STOCKAGE DB
    $immobilier->document_propriete = $realPath;
}

        $immobilier->update([
            'adresse_imm' => $request->input('adresse_imm', $immobilier->adresse_imm),
             'commentaire_motif' => $comment,
            'id_statut' => $newStatut,
           
            'gouvernorat_id' => $request->input('gouvernorat_id', $immobilier->gouvernorat_id),
            'delegation_id' => $request->input('delegation_id', $immobilier->delegation_id),
            'type_imm_id' => $request->input('type_imm_id', $immobilier->type_imm_id),
            'usage_id' => $request->input('usage_id', $immobilier->usage_id),
            'superfici_m2' => $request->input('superfici_m2', $immobilier->superfici_m2),
            'salle_exercice' => $request->input('salle_exercice', $immobilier->salle_exercice),
            'nbr_salle_exercice' => $request->input('nbr_salle_exercice', $immobilier->nbr_salle_exercice),
            'superface_salle_exercice' => $request->input('superface_salle_exercice', $immobilier->superface_salle_exercice),
            'piscine' => $request->input('piscine', $immobilier->piscine),
            'nbr_piscine' => $request->input('nbr_piscine', $immobilier->nbr_piscine),
            'superface_piscine' => $request->input('superface_piscine', $immobilier->superface_piscine),
            'vestiaire' => $request->input('vestiaire', $immobilier->vestiaire),
            'nbr_vestiaire' => $request->input('nbr_vestiaire', $immobilier->nbr_vestiaire),
            'superface_vestiaire' => $request->input('superface_vestiaire', $immobilier->superface_vestiaire),
            'unitaires_sanitaire' => $request->input('unitaires_sanitaire', $immobilier->unitaires_sanitaire),
            'superface_unitaires_sanitaire' => $request->input('superface_unitaires_sanitaire', $immobilier->superface_unitaires_sanitaire),
            'stockage_conservation' => $request->input('stockage_conservation', $immobilier->stockage_conservation),
            'superface_stockage_conservation' => $request->input('superface_stockage_conservation', $immobilier->superface_stockage_conservation),
            'espace_exterieur' => $request->input('espace_exterieur', $immobilier->espace_exterieur),
            'superface_espace_exterieur' => $request->input('superface_espace_exterieur', $immobilier->superface_espace_exterieur),
            'garage' => $request->input('garage', $immobilier->garage),
            'superface_garage' => $request->input('superface_garage', $immobilier->superface_garage),
            'autres_surfaces' => $request->input('autres_surfaces', $immobilier->autres_surfaces),
        ]);
$immobilier->save();

		$statusMap = [
			1 => 'accepted',
			3 => 'rejected',
			4 => 'incomplete',
			5 => 'deferred',
		];
		$normType = $statusMap[$newStatut] ?? 'status_changed';
		$translationParams = [];

		if ($normType === 'rejected') {
			$translationParams['reason'] = $comment ?? ($request->input('commentaire_refus') ?? null);
		} elseif ($normType === 'incomplete') {
			$translationParams['missing'] = $request->input('commentaire_acceptation') ?? ($comment ?? null);
		} elseif ($normType === 'deferred') {
			$translationParams['note'] = $request->input('commentaire_avis') ?? ($comment ?? null);
		} elseif ($normType === 'accepted') {
			if (isset($dateDebut)) {
				$translationParams['date'] = $dateDebut->format('Y-m-d');
			}
		}


try {
    if ($oldStatut !== $newStatut && $user && !empty($user->email)) {

        $mailTypeMap = [
            1 => 'accepte',
            3 => 'refuse',
            4 => 'incomplet', // status 4 -> incomplet
            5 => 'deferre',   // status 5 -> deferre
        ];
        $mailType = $mailTypeMap[$newStatut] ?? 'status_changed';

        $notifyTypeMap = [
            1 => 'accepted',
            3 => 'rejected',
            4 => 'incomplete',
            5 => 'deferred',
        ];
        $notifyType = $notifyTypeMap[$newStatut] ?? 'status_changed';
        if ($newStatut === 3) {
            $mailComment = $request->input('commentaire_refus') ?? $comment ?? null;
        } elseif ($newStatut === 4) {
            $mailComment = $request->input('commentaire_acceptation') ?? $comment ?? null;
        } elseif ($newStatut === 5) {
            $mailComment = $request->input('commentaire_avis') ?? $comment ?? null;
        } else {
            $mailComment = $request->input('commentaire_motif') ?? $comment ?? null;
        }
        $mailComment = is_string($mailComment) ? trim($mailComment) : null;
        $dateDebut = ($newStatut === 1) ? \Carbon\Carbon::now()->addDays(15) : null;

        \Log::info("Immobilier status changed - preparing mail/notification", [
            'immobilier_id' => $immobilier->id_imm,
            'old' => $oldStatut,
            'new' => $newStatut,
            'mailType' => $mailType,
            'mailComment' => $mailComment,
            'user_email' => $user->email,
        ]);
        try {
            Mail::to($user->email)->send(
                new \App\Mail\SalleSportStatutMail($mailType, $user, $dateDebut, $mailComment, $immobilier->id_imm)
            );
            \Log::info("Status mail sent", ['immobilier_id' => $immobilier->id_imm, 'to' => $user->email, 'type' => $mailType]);
        } catch (\Throwable $mailExInner) {
            \Log::error("Failed sending status mail (non-fatal): " . $mailExInner->getMessage(), [
                'immobilier_id' => $immobilier->id_imm,
                'to' => $user->email,
                'type' => $mailType,
                'trace' => $mailExInner->getTraceAsString()
            ]);
        }
        $notifParams = [];
        if ($notifyType === 'rejected') {
            $notifParams['reason'] = $mailComment ?? '';
        } elseif ($notifyType === 'incomplete') {
            $notifParams['missing'] = $mailComment ?? '';
        } elseif ($notifyType === 'deferred') {
            $notifParams['note'] = $mailComment ?? '';
        } elseif ($notifyType === 'accepted') {
            if ($dateDebut) $notifParams['date'] = $dateDebut->format('Y-m-d');
        }
        try {
            $user->notify(new \App\Notifications\SalleSportStatutNotification($notifyType, $notifParams, $immobilier->id_imm));
            \Log::info("Status notification created in DB", ['immobilier_id' => $immobilier->id_imm, 'user_id' => $user->id, 'type' => $notifyType]);
        } catch (\Throwable $notifEx) {
            \Log::error("Failed creating DB notification (non-fatal): " . $notifEx->getMessage(), [
                'immobilier_id' => $immobilier->id_imm,
                'user_id' => $user->id,
                'type' => $notifyType,
                'trace' => $notifEx->getTraceAsString()
            ]);
        }

    } else {
        \Log::debug("No status change or missing user email — skipping mail/notification", [
            'immobilier_id' => $immobilier->id_imm ?? null,
            'old' => $oldStatut,
            'new' => $newStatut,
            'has_user' => (bool)$user,
            'user_email' => $user->email ?? null,
        ]);
    }
} catch (\Throwable $mailEx) {
    \Log::error('Error in mail/notify post-update block: '.$mailEx->getMessage(), [
        'immobilier_id' => $immobilier->id_imm ?? null,
        'trace' => $mailEx->getTraceAsString()
    ]);
}
        return redirect()->route('salle-sport.index')->with('ok', 'تم تعديل الطلب بنجاح.');
    }
	
public function download($id)
{
    $immobilier = Immobilier::where('id_imm', $id)->firstOrFail();
    $path = $immobilier->document_propriete;

    if (empty($path) || !file_exists($path)) {
        abort(404, 'Fichier introuvable');
    }

    return response()->file($path, [
        'Content-Type' => mime_content_type($path),
        'Content-Disposition' => 'inline; filename="' . basename($path) . '"',

        // 🚫 ANTI-CACHE (CRITIQUE)
        'Cache-Control' => 'no-store, no-cache, must-revalidate, max-age=0',
        'Pragma' => 'no-cache',
        'Expires' => '0',
    ]);
}





   /* public function download($id)
{
    $immobilier = Immobilier::findOrFail($id);

    if (!$immobilier->document_propriete) {
        abort(404);
    }

    // Si tu stockes le fichier dans la base (BLOB), tu peux détecter le type MIME
    // Utilisation de finfo pour détecter le type MIME
    $finfo = new \finfo(FILEINFO_MIME_TYPE);
    $mimeType = $finfo->buffer($immobilier->document_propriete);

    // Détecter l'extension pour le nom du fichier
    switch($mimeType) {
        case 'application/pdf':
            $extension = 'pdf';
            break;
        case 'image/jpeg':
            $extension = 'jpg';
            break;
        case 'image/png':
            $extension = 'png';
            break;
        case 'image/gif':
            $extension = 'gif';
            break;
        default:
            $extension = 'bin'; // fichier inconnu
    }

    $filename = "document_propriete." . $extension;

    return response($immobilier->document_propriete)
        ->header('Content-Type', $mimeType)
        ->header('Content-Disposition', 'inline; filename="' . $filename . '"');
}*/















/*
    public function toggleStatut(Request $request, $id)
    {
        $salle = Immobilier::with('utilisateur')->findOrFail($id);

        if ($salle->id_statut != 2) {
            return redirect()->back()->with('error', 'لا يمكن تغيير الحالة بعد تحديدها.');
        }

        $salle->id_statut = $request->id_statut;
        $user = $salle->utilisateur;

        if ($request->id_statut == 3 && $request->commentaire_motif) {
            $salle->commentaire_motif = $request->commentaire_motif;
            Mail::to($user->email)->send(new SalleSportStatutMail('refuse', $user, null, $request->commentaire_motif));
            $user->notify(new SalleSportStatutNotification('refuse', null, $request->commentaire_motif));
        } elseif ($request->id_statut == 1) {
            $dateDebut = Carbon::now()->addDays(15);
            Mail::to($user->email)->send(new SalleSportStatutMail('accepte', $user, $dateDebut));
            $user->notify(new SalleSportStatutNotification('accepte', $dateDebut));
        }

        $salle->save();
        return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح');
    } */



public function toggleStatut(Request $request, $id)
{
    $request->validate([
        'id_statut' => 'required|integer|in:1,2,3,4,5',
        'commentaire_motif' => 'nullable|string',
        'commentaire_refus' => 'nullable|string',
        'commentaire_status' => 'nullable|string',
        'commentaire_acceptation' => 'nullable|string',
        'commentaire_avis' => 'nullable|string',
    ]);

    DB::beginTransaction();
    try {
        $salle = Immobilier::with('utilisateur')->findOrFail($id);

        // allowed "from" statuses — adjust this if you want to allow toggling from other statuses
        $allowedFrom = [2, 4, 5];

        if (!in_array((int)$salle->id_statut, $allowedFrom, true)) {
            DB::rollBack();
            return redirect()->back()->with('error', 'لا يمكن تغيير الحالة من هذه الوضعية.');
        }

        $oldStatut = (int) ($salle->id_statut ?? 0);
        $newStatut = (int) $request->input('id_statut');

        if ($oldStatut === $newStatut) {
            DB::rollBack();
            return redirect()->back()->with('info', 'لا تغيير في الوضعية.');
        }

        // choose comment (same logic as in update)
        $comment = null;
        if ($request->filled('commentaire_refus')) {
            $comment = trim($request->input('commentaire_refus'));
        } elseif ($request->filled('commentaire_status')) {
            $comment = trim($request->input('commentaire_status'));
        } elseif ($request->filled('commentaire_motif')) {
            $comment = trim($request->input('commentaire_motif'));
        }

        // fallback on other comment fields
        if (($comment === null || $comment === '') && $request->filled('commentaire_acceptation')) {
            $comment = trim($request->input('commentaire_acceptation'));
        }
        if (($comment === null || $comment === '') && $request->filled('commentaire_avis')) {
            $comment = trim($request->input('commentaire_avis'));
        }
        if ($comment === '') $comment = null;

        // update model fields (store a copy of comment where you used to store it — you said you want to use history for all comments,
        // but storing it on the immobilier row too helps (display, fallback) - adapt as you like):
        $salle->id_statut = $newStatut;

        // here we put the "unified" comment into commentaire_motif for backward compatibility,
        // but the canonical copy will be saved in the history row below.
        $salle->commentaire_motif = $comment ?: $salle->commentaire_motif;
        $salle->save();

        // create history with the comment (this is the canonical place you said you want comments)
        $history = ImmobilierStatutHistory::create([
            'immobilier_id'   => $salle->id_imm,
            'from_statut_id'  => $oldStatut ?: null,
            'to_statut_id'    => ($newStatut > 0) ? $newStatut : null,
            'changed_by'      => Auth::id() ?? null,
            'commentaire'     => $comment,
        ]);

        DB::commit();
    } catch (\Exception $e) {
        DB::rollBack();
        \Log::error("toggleStatut error for Immobilier ID {$id}: " . $e->getMessage(), [
            'trace' => $e->getTraceAsString(),
            'request' => $request->all(),
        ]);
        return back()->withErrors(['error' => 'حدث خطأ أثناء تغيير الحالة: ' . $e->getMessage()]);
    }

    // --- After commit: send mail + DB notification (do not rollback if mail/notify fails) ---
    try {
        $user = $salle->utilisateur; // loaded with the model earlier

        if ($oldStatut !== $newStatut && $user && !empty($user->email)) {

            // mail type strings expected by your SalleSportStatutMail view
            $mailTypeMap = [
                1 => 'accepte',
                3 => 'refuse',
                4 => 'incomplet',
                5 => 'deferre',
            ];
            $mailType = $mailTypeMap[$newStatut] ?? 'status_changed';

            // normalized notification type for DB notification
            $notifyTypeMap = [
                1 => 'accepted',
                3 => 'rejected',
                4 => 'incomplete',
                5 => 'deferred',
            ];
            $notifyType = $notifyTypeMap[$newStatut] ?? 'status_changed';

            // Prefer the comment saved in history (canonical). Fall back to request/comment variable.
            $historyComment = $history->commentaire ?? null;
            if ($historyComment !== null && trim((string)$historyComment) !== '') {
                $mailComment = trim((string)$historyComment);
            } else {
                if ($newStatut === 3) {
                    $mailComment = $request->input('commentaire_refus') ?? $comment ?? null;
                } elseif ($newStatut === 4) {
                    $mailComment = $request->input('commentaire_acceptation') ?? $comment ?? null;
                } elseif ($newStatut === 5) {
                    $mailComment = $request->input('commentaire_avis') ?? $comment ?? null;
                } else {
                    $mailComment = $request->input('commentaire_motif') ?? $comment ?? null;
                }
            }
            $mailComment = is_string($mailComment) ? trim($mailComment) : null;

            // optional parameter for accepted
            $dateDebut = ($newStatut === 1) ? \Carbon\Carbon::now()->addDays(15) : null;

            \Log::info("Immobilier status changed - preparing mail/notification", [
                'immobilier_id' => $salle->id_imm,
                'old' => $oldStatut,
                'new' => $newStatut,
                'mailType' => $mailType,
                'mailComment' => $mailComment,
                'user_email' => $user->email,
            ]);

            // Send mail (wrapped so mail failure won't rollback DB)
            try {
                Mail::to($user->email)->send(
                    new \App\Mail\SalleSportStatutMail($mailType, $user, $dateDebut, $mailComment, $salle->id_imm)
                );
                \Log::info("Status mail sent", ['immobilier_id' => $salle->id_imm, 'to' => $user->email, 'type' => $mailType]);
            } catch (\Throwable $mailExInner) {
                \Log::error("Failed sending status mail (non-fatal): " . $mailExInner->getMessage(), [
                    'immobilier_id' => $salle->id_imm,
                    'to' => $user->email,
                    'type' => $mailType,
                    'trace' => $mailExInner->getTraceAsString()
                ]);
            }

            // Build notification params and create DB notification
            $notifParams = [];
            if ($notifyType === 'rejected') {
                $notifParams['reason'] = $mailComment ?? '';
            } elseif ($notifyType === 'incomplete') {
                $notifParams['missing'] = $mailComment ?? '';
            } elseif ($notifyType === 'deferred') {
                $notifParams['note'] = $mailComment ?? '';
            } elseif ($notifyType === 'accepted') {
                if ($dateDebut) $notifParams['date'] = $dateDebut->format('Y-m-d');
            }

            try {
                $user->notify(new \App\Notifications\SalleSportStatutNotification($notifyType, $notifParams, $salle->id_imm));
                \Log::info("Status notification created in DB", ['immobilier_id' => $salle->id_imm, 'user_id' => $user->id, 'type' => $notifyType]);
            } catch (\Throwable $notifEx) {
                \Log::error("Failed creating DB notification (non-fatal): " . $notifEx->getMessage(), [
                    'immobilier_id' => $salle->id_imm,
                    'user_id' => $user->id ?? null,
                    'type' => $notifyType,
                    'trace' => $notifEx->getTraceAsString()
                ]);
            }
        } else {
            \Log::debug("No status change or missing user email — skipping mail/notification", [
                'immobilier_id' => $salle->id_imm ?? null,
                'old' => $oldStatut,
                'new' => $newStatut,
                'has_user' => (bool)$user,
                'user_email' => $user->email ?? null,
            ]);
        }
    } catch (\Throwable $mailEx) {
        \Log::error('Error in mail/notify post-update block: '.$mailEx->getMessage(), [
            'immobilier_id' => $salle->id_imm ?? null,
            'trace' => $mailEx->getTraceAsString()
        ]);
    }

    return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح');
}

    public function destroy($id)
    {
        $salle = Immobilier::findOrFail($id);
        if ($salle->document_propriete && file_exists(storage_path('app/' . $salle->document_propriete))) {
            unlink(storage_path('app/' . $salle->document_propriete));
        }
        $salle->delete();
        return redirect()->route('salle-sport.index')->with('success', 'تم حذف الاستمارة بنجاح.');
    }

    public function getDelegations_salle($gouvernoratId)
    {
        $delegations = Delegation::where('gouver_id', $gouvernoratId)->get();
        return response()->json($delegations);
    }		
	/*public function getDistrictsalle($gouvernoratId)      {          $delegations = Delegation::where('gouver_id', $gouvernoratId)->get();		$delegations = Delegation::where('gouver_id', $gouvernoratId)			->select('id_delegation', 'nom_ar') 			->get();        return response()->json($delegations);        }*/				
    //Front
    public function index2()
    {
        $userId = Auth::id();

        $salles = Immobilier::with(['utilisateur', 'statut'])
            ->where('id_type_formulaire', 1)
            ->where('user_id', $userId) 
            ->latest()
            ->paginate(10);
        return view('investissement.gestion_salle_sport.salle_sport.index', compact('salles'));
    }

    public function create3()
    {
        $user = Auth::user();
        $formulaire = TypeFormulaire::find(1);
        $typesIdentite = Identite_personnel::all();
        $gouvernorats = Gouvernorat::all();
        $typesImmobilier = Type_immobilier::all();
        $usagesImmobilier = Usage_immobilier::all();

        return view('investissement.gestion_salle_sport.salle_sport.create', compact('user',
            'formulaire', 'typesIdentite', 'gouvernorats', 'typesImmobilier', 'usagesImmobilier'
        ));
    }

    public function store2(Request $request)
    {
        $request->validate([
            // Immobilier
            'adresse_imm' => 'required|string|max:255',
            'gouvernorat_id' => 'required|exists:tp_gouvernorat,id_gouver',
            'delegation_id' => 'required|exists:tp_delegation,id_delegation',
            'type_imm_id' => 'required|exists:tp_immobilier,id_type',
            'usage_id' => 'required|exists:tp_usage_immobilier,id_usage_imm',
            'superfici_m2' => 'required|integer|min:100',
            'document_propriete' => 'required|file|mimes:pdf,jpg,jpeg,png',
            'salle_exercice' => 'required|in:0,1',
            'nbr_salle_exercice' => 'nullable|integer|min:1|required_if:salle_exercice,1',
            'superface_salle_exercice' => 'nullable|integer|min:1|required_if:salle_exercice,1',
            'piscine' => 'required|in:0,1',
            'nbr_piscine' => 'nullable|integer|min:1|required_if:piscine,1',
            'superface_piscine' => 'nullable|integer|min:1|required_if:piscine,1',
            'vestiaire' => 'required|in:0,1',
            'nbr_vestiaire' => 'nullable|integer|min:1|required_if:vestiaire,1',
            'superface_vestiaire' => 'nullable|integer|min:1|required_if:vestiaire,1',
            'unitaires_sanitaire' => 'required|in:0,1',
            'superface_unitaires_sanitaire' => 'nullable|integer|min:1|required_if:unitaires_sanitaire,1',
            'stockage_conservation' => 'nullable|integer|in:0,1',
            'superface_stockage_conservation' => 'nullable|integer|min:1|required_if:stockage_conservation,1',
            'espace_exterieur' => 'required|in:0,1',
            'superface_espace_exterieur' => 'nullable|integer|min:1|required_if:espace_exterieur,1',
            'garage' => 'required|in:0,1',
            'superface_garage' => 'nullable|integer|min:1|required_if:garage,1',
            'autres_surfaces' => 'nullable|integer|min:0',
        ]);

        // Upload du document de propriété
        if ($request->hasFile('document_propriete')) {
            $documentPath = $request->file('document_propriete')->store('documents_propriete');
        } else {
            $documentPath = null;
        }

        // Création de l'immobilier
        /*$immobilier = new Immobilier();
        $immobilier->adresse_imm = $request->adresse_imm ?? null;
        $immobilier->gouvernorat_id = $request->gouvernorat_id ?? null;
        $immobilier->delegation_id = $request->delegation_id ?? null;
        $immobilier->type_imm_id = $request->type_imm_id ?? null;
        $immobilier->usage_id = $request->usage_id ?? null;
        $immobilier->superfici_m2 = $request->superfici_m2 ?? null;
        $immobilier->document_propriete = $documentPath;
        $immobilier->id_type_formulaire = 1;
        $immobilier->id_statut = 2;
        $immobilier->salle_exercice = $request->salle_exercice;
        $immobilier->nbr_salle_exercice = $request->nbr_salle_exercice;
        $immobilier->superface_salle_exercice = $request->superface_salle_exercice;
        $immobilier->piscine = $request->piscine;
        $immobilier->nbr_piscine = $request->nbr_piscine;
        $immobilier->superface_piscine = $request->superface_piscine;
        $immobilier->vestiaire = $request->vestiaire;
        $immobilier->nbr_vestiaire = $request->nbr_vestiaire;
        $immobilier->superface_vestiaire = $request->superface_vestiaire;
        $immobilier->unitaires_sanitaire = $request->unitaires_sanitaire;
        $immobilier->superface_unitaires_sanitaire = $request->superface_unitaires_sanitaire;
        $immobilier->stockage_conservation = $request->stockage_conservation;
        $immobilier->superface_stockage_conservation = $request->superface_stockage_conservation;
        $immobilier->espace_exterieur = $request->espace_exterieur;
        $immobilier->superface_espace_exterieur = $request->superface_espace_exterieur;
        $immobilier->garage = $request->garage;
        $immobilier->superface_garage = $request->superface_garage;
        $immobilier->autres_surfaces = $request->autres_surfaces;
        $immobilier->user_id = Auth::id();
        $immobilier->save();*/

$immobilier = new Immobilier();
        $immobilier->adresse_imm = $request->adresse_imm ?? null;
        $immobilier->gouvernorat_id = $request->gouvernorat_id ?? null;
        $immobilier->delegation_id = $request->delegation_id ?? null;
        $immobilier->type_imm_id = $request->type_imm_id ?? null;
        $immobilier->usage_id = $request->usage_id ?? null;
        $immobilier->superfici_m2 = $request->superfici_m2 ?? null;
        $immobilier->document_propriete = $documentPath;
        $immobilier->id_type_formulaire = 1;
        $immobilier->id_statut = 2;
        $immobilier->salle_exercice = $request->salle_exercice;
        $immobilier->nbr_salle_exercice = $request->nbr_salle_exercice;
        $immobilier->superface_salle_exercice = $request->superface_salle_exercice;
        $immobilier->piscine = $request->piscine;
        $immobilier->nbr_piscine = $request->nbr_piscine;
        $immobilier->superface_piscine = $request->superface_piscine;
        $immobilier->vestiaire = $request->vestiaire;
        $immobilier->nbr_vestiaire = $request->nbr_vestiaire;
        $immobilier->superface_vestiaire = $request->superface_vestiaire;
        $immobilier->unitaires_sanitaire = $request->unitaires_sanitaire;
        $immobilier->superface_unitaires_sanitaire = $request->superface_unitaires_sanitaire;
        $immobilier->stockage_conservation = $request->stockage_conservation;
        $immobilier->superface_stockage_conservation = $request->superface_stockage_conservation;
        $immobilier->espace_exterieur = $request->espace_exterieur;
        $immobilier->superface_espace_exterieur = $request->superface_espace_exterieur;
        $immobilier->garage = $request->garage;
        $immobilier->superface_garage = $request->superface_garage;
        $immobilier->autres_surfaces = $request->autres_surfaces;
        $immobilier->user_id = Auth::id();
        $immobilier->save();

        return redirect()->route('salle-sport.index2')->with('ok', 'تم إنشاء الطلب بنجاح.');
    }




    public function show2($id)
    {
        $immobilier = Immobilier::with('utilisateur')->findOrFail($id);
        $formulaire = TypeFormulaire::find(1);
        $typesIdentite = Identite_personnel::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::where('gouver_id', $immobilier->gouvernorat_id)->get();
        $typesImmobilier = Type_immobilier::all();
        $usagesImmobilier = Usage_immobilier::all();
        return view('investissement.gestion_salle_sport.salle_sport.show', compact(
            'immobilier', 'formulaire', 'typesIdentite', 'gouvernorats', 'delegations', 'typesImmobilier', 'usagesImmobilier'
        ));
    }

    public function edit2($id)
    {
        $immobilier = Immobilier::with('utilisateur')->findOrFail($id);
        $formulaire = TypeFormulaire::find(1);
        $typesIdentite = Identite_personnel::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::where('gouver_id', $immobilier->gouvernorat_id)->get();
        $typesImmobilier = Type_immobilier::all();
        $usagesImmobilier = Usage_immobilier::all();
        return view('investissement.gestion_salle_sport.salle_sport.edit', compact(
            'immobilier', 'formulaire', 'typesIdentite', 'gouvernorats', 'delegations', 'typesImmobilier', 'usagesImmobilier'
        ));
    }

    public function update2(Request $request, $id)
    {
        $immobilier = Immobilier::with('utilisateur')->findOrFail($id);

        $request->validate([
            // Utilisateur
            'nom_prenom' => 'required|string|max:50',
            'id_type_identite' => 'required|exists:tp_type_identite_pers,id_type',
            'cin' => 'nullable|digits:8|unique:utilisateur,cin,' . $immobilier->utilisateur->id . ',id',
            'passport' => 'nullable|digits:12|unique:utilisateur,passport,' . $immobilier->utilisateur->id . ',id',
            'num_fiscal' => 'nullable|digits:12|unique:utilisateur,num_fiscal,' . $immobilier->utilisateur->id . ',id',
            'tel' => 'required|string|max:12',
            'email' => 'required|email|unique:utilisateur,email,' . $immobilier->utilisateur->id . ',id',
            'adresse' => 'required|string|max:100',

            // Immobilier
            'adresse_imm' => 'required|string|max:100',
            'commentaire_motif' => 'nullable|string|max:255',
            'gouvernorat_id' => 'required|exists:tp_gouvernorat,id_gouver',
            'delegation_id' => 'required|exists:tp_delegation,id_delegation',
            'type_imm_id' => 'required|exists:tp_immobilier,id_type',
            'usage_id' => 'required|exists:tp_usage_immobilier,id_usage_imm',
            'superfici_m2' => 'required|integer|min:100',
            'document_propriete' => 'sometimes|nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'salle_exercice' => 'required|in:0,1',
            'nbr_salle_exercice' => 'nullable|integer|min:1|required_if:salle_exercice,1',
            'superface_salle_exercice' => 'nullable|integer|min:1|required_if:salle_exercice,1',
            'piscine' => 'required|in:0,1',
            'nbr_piscine' => 'nullable|integer|min:1|required_if:piscine,1',
            'superface_piscine' => 'nullable|integer|min:1|required_if:piscine,1',
            'vestiaire' => 'required|in:0,1',
            'nbr_vestiaire' => 'nullable|integer|min:1|required_if:vestiaire,1',
            'superface_vestiaire' => 'nullable|integer|min:1|required_if:vestiaire,1',
            'unitaires_sanitaire' => 'required|in:0,1',
            'superface_unitaires_sanitaire' => 'nullable|integer|min:1|required_if:unitaires_sanitaire,1',
            'stockage_conservation' => 'nullable|integer|in:0,1',
            'superface_stockage_conservation' => 'nullable|integer|min:1|required_if:stockage_conservation,1',
            'espace_exterieur' => 'required|in:0,1',
            'superface_espace_exterieur' => 'nullable|integer|min:1|required_if:espace_exterieur,1',
            'garage' => 'required|in:0,1',
            'superface_garage' => 'nullable|integer|min:1|required_if:garage,1',
            'autres_surfaces' => 'nullable|integer|min:0',
        ]);

        // Update Utilisateur
        $user = $immobilier->utilisateur;
        $user->nom_prenom = $request->nom_prenom;
        $user->id_type_identite = $request->id_type_identite;
        $user->cin = $request->cin;
        $user->passport = $request->passport;
        $user->num_fiscal = $request->num_fiscal;
        $user->tel = $request->tel;
        $user->email = $request->email;
        $user->adresse = $request->adresse;
        $user->save();

        // Upload document si nouveau
        if ($request->hasFile('document_propriete')) {
            $documentPath = $request->file('document_propriete')->store('documents_propriete');
            $immobilier->document_propriete = $documentPath;
        }

        // Update Immobilier
        $immobilier->update([
            'adresse_imm' => $request->input('adresse_imm', $immobilier->adresse_imm),
            'commentaire_motif' => $request->input('commentaire_motif', $immobilier->commentaire_motif),
            'gouvernorat_id' => $request->input('gouvernorat_id', $immobilier->gouvernorat_id),
            'delegation_id' => $request->input('delegation_id', $immobilier->delegation_id),
            'type_imm_id' => $request->input('type_imm_id', $immobilier->type_imm_id),
            'usage_id' => $request->input('usage_id', $immobilier->usage_id),
            'superfici_m2' => $request->input('superfici_m2', $immobilier->superfici_m2),
            'salle_exercice' => $request->input('salle_exercice', $immobilier->salle_exercice),
            'nbr_salle_exercice' => $request->input('nbr_salle_exercice', $immobilier->nbr_salle_exercice),
            'superface_salle_exercice' => $request->input('superface_salle_exercice', $immobilier->superface_salle_exercice),
            'piscine' => $request->input('piscine', $immobilier->piscine),
            'nbr_piscine' => $request->input('nbr_piscine', $immobilier->nbr_piscine),
            'superface_piscine' => $request->input('superface_piscine', $immobilier->superface_piscine),
            'vestiaire' => $request->input('vestiaire', $immobilier->vestiaire),
            'nbr_vestiaire' => $request->input('nbr_vestiaire', $immobilier->nbr_vestiaire),
            'superface_vestiaire' => $request->input('superface_vestiaire', $immobilier->superface_vestiaire),
            'unitaires_sanitaire' => $request->input('unitaires_sanitaire', $immobilier->unitaires_sanitaire),
            'superface_unitaires_sanitaire' => $request->input('superface_unitaires_sanitaire', $immobilier->superface_unitaires_sanitaire),
            'stockage_conservation' => $request->input('stockage_conservation', $immobilier->stockage_conservation),
            'superface_stockage_conservation' => $request->input('superface_stockage_conservation', $immobilier->superface_stockage_conservation),
            'espace_exterieur' => $request->input('espace_exterieur', $immobilier->espace_exterieur),
            'superface_espace_exterieur' => $request->input('superface_espace_exterieur', $immobilier->superface_espace_exterieur),
            'garage' => $request->input('garage', $immobilier->garage),
            'superface_garage' => $request->input('superface_garage', $immobilier->superface_garage),
            'autres_surfaces' => $request->input('autres_surfaces', $immobilier->autres_surfaces),
        ]);

        return redirect()->route('salle-sport.index2')->with('ok', 'تم تعديل الطلب بنجاح.');
    }

    public function toggleStatut2(Request $request, $id)
    {
        $salle = Immobilier::findOrFail($id);
        $salle->id_statut = $request->id_statut;

        if($request->id_statut == 3 && $request->commentaire_motif) {
            $salle->commentaire_motif = $request->commentaire_motif;
        }

        $salle->save();

        return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح!');
    }    

    public function destroy2($id)
    {
        $salle = Immobilier::findOrFail($id);
        if ($salle->document_propriete && file_exists(storage_path('app/' . $salle->document_propriete))) {
            unlink(storage_path('app/' . $salle->document_propriete));
        }
        $salle->delete();
        return redirect()->route('salle-sport.index2')->with('success', 'تم حذف الاستمارة بنجاح.');
    }


    /**  Exoneration  */

    public function createExoneration($id_imm)
    {
        $immobilier = Immobilier::findOrFail($id_imm);
        $formulaire = TypeFormulaire::find(22);
        return view('backoffice.investissement.gestion_salle_sport.exoneration.create', compact('immobilier','formulaire'));
    }

    public function storeExoneration(Request $request, $id_imm)
    {
        $immobilier = Immobilier::findOrFail($id_imm);

        $request->validate([
            'nom_projet'       => 'required|string|max:255',
            'adresse_projet'   => 'required|string|max:255',
            'copie_cahier_des_charges'           => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_originale'                    => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'facture'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'contrat'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'fichier_arrivage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'fichier_colisage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_registre_fiscal'              => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_registre_national_institutions' => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_certificat_propriete'         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'engagement'                         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'exemple_projet'                     => 'nullable|file|mimes:pdf,jpg,jpeg,png',
        ]);

        $files = [
                'copie_cahier_des_charges',
                'copie_originale',
                'facture',
                'contrat',
                'fichier_arrivage',
                'fichier_colisage',
                'copie_registre_fiscal',
                'copie_registre_national_institutions',
                'copie_certificat_propriete',
                'engagement',
                'exemple_projet'
            ];

        $fileData = [];
        foreach ($files as $fileField) {
            if ($request->hasFile($fileField)) {
                $originalName = $request->file($fileField)->getClientOriginalName();
                $path = $request->file($fileField)->storeAs('documents/exoneration', $originalName, 'public');
                $fileData[$fileField] = $path;
            }
        }  

        DocumentsFormulaire::create(array_merge($fileData, [
            'id_user' => $immobilier->user_id,
            'id_formulaire' => 22, 
            'id_type_formulaire' => 1,
            'nom_projet' => $request->nom_projet,
            'adresse_projet' => $request->adresse_projet,
            'id_statut' => 2,
            'immobilier_id' => $id_imm,
            'etat_formulaire' => 'remplir',
        ]));
        return redirect()->route('salle-sport.index')->with('success', 'تم تسجيل المشروع بنجاح');
    }

    public function editExoneration($id)
    {
        $document = DocumentsFormulaire::findOrFail($id);
        $immobilier = $document->immobilier;
        $formulaire = TypeFormulaire::find(22);
        $typesIdentite = Identite_personnel::all();


        return view('backoffice.investissement.gestion_salle_sport.exoneration.edit', compact('document', 'immobilier', 'formulaire','typesIdentite'));
    }

    public function updateExoneration(Request $request, $id)
    {
        $document = DocumentsFormulaire::findOrFail($id);
        $immobilier = $document->immobilier;

        $request->validate([
            'nom_projet'       => 'required|string|max:255',
            'adresse_projet'   => 'required|string|max:255',
            'copie_cahier_des_charges'           => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_originale'                    => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'facture'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'contrat'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'fichier_arrivage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'fichier_colisage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_registre_fiscal'              => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_registre_national_institutions' => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_certificat_propriete'         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'engagement'                         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'exemple_projet'                     => 'nullable|file|mimes:pdf,jpg,jpeg,png',
        ]);

        $files = [
            'copie_cahier_des_charges',
            'copie_originale',
            'facture',
            'contrat',
            'fichier_arrivage',
            'fichier_colisage',
            'copie_registre_fiscal',
            'copie_registre_national_institutions',
            'copie_certificat_propriete',
            'engagement',
            'exemple_projet'
        ];

        foreach ($files as $fileField) {
            if ($request->hasFile($fileField)) {
                $originalName = $request->file($fileField)->getClientOriginalName();
                $path = $request->file($fileField)->storeAs('documents/exoneration', $originalName, 'public');
                $document->$fileField = $path;
            }
        }

        $document->nom_projet = $request->nom_projet;
        $document->adresse_projet = $request->adresse_projet;
        $document->etat_formulaire = 'remplir';
        $document->save();

        return redirect()->route('salle-sport.index')->with('success', 'تم تعديل مشروع الإعفاء بنجاح');
    }

    public function showExoneration($id)
    {
        $document = DocumentsFormulaire::findOrFail($id);
        $immobilier = $document->immobilier;
        $formulaire = TypeFormulaire::find(22);
        $typesIdentite = Identite_personnel::all();

        return view('backoffice.investissement.gestion_salle_sport.exoneration.show', compact(
            'document',
            'immobilier',
            'formulaire',
            'typesIdentite'
        ));
    }
	
	public function pdfExoneration($id)
{
    $document = DocumentsFormulaire::with('utilisateur')->findOrFail($id);
    $formulaire = TypeFormulaire::find(22);
    $typesIdentite = Identite_personnel::all();

    $data = compact('document','formulaire','typesIdentite');

    $html = view('backoffice.investissement.gestion_salle_sport.exoneration.pdf', $data)->render();

    $mpdf = new \Mpdf\Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
        'autoScriptToLang' => true,
        'autoLangToFont' => true,
    ]);

    $mpdf->setFooter('{PAGENO} / {nb}');
    $mpdf->WriteHTML($html);

    return $mpdf->Output('exoneration.pdf', 'I');
}


}

