<?php

namespace App\Http\Controllers\Investissement;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\TypeFormulaire;
use App\Models\TypeEspaceInstitution;
use App\Models\ServiceInstitution;
use App\Models\SecteurFinancement;
use App\Models\SourceFinancement;
use App\Models\NatureProjet; 
use App\Models\NatureActivite;
use App\Models\StatutInv;
use App\Models\Gouvernorat;
use App\Models\Delegation;
use App\Models\DirecteurEtablissement;
use App\Models\InstitutionPriveJeunesse;
use App\Models\Identite_personnel;
use App\Models\Utilisateur;
use App\Models\Investissement;
use App\Mail\JeunesseStatutMail;
use App\Mail\Jeunesse2StatutMail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use App\Notifications\JeunesseStatutNotification;
use App\Notifications\Jeunesse2StatutNotification;
use App\Models\ActiviteJeuneEnfant;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Mpdf\Mpdf;
use App\Models\TpStatut;
use Illuminate\Support\Facades\Auth;
use App\Models\ImmobilierStatutHistory;



class JeunesseController extends Controller
{
    /*public function index(Request $request)
    {
        $institutions = InstitutionPriveJeunesse::with([
            'directeur',
            'investissements',
            'investissements.utilisateur',
            'natureProjet'
        ])
        ->orderByDesc('created_at')
        ->paginate(10);

        return view('backoffice.investissement.gestion_jeunesse.index', compact('institutions'));
    }*/
	
	public function index(Request $request)
{
    $query = InstitutionPriveJeunesse::with([
        'directeur',
        'investissements',
        'investissements.utilisateur',
        'natureProjet'
    ]);

    if ($request->search_option == "nom") {

        $nom = trim($request->nom);

        // Cas invalides → retour liste vide
        if (
            $nom === "" ||                     // vide ou espace
            $nom === "%" ||                    // %
            $nom === "%%" ||                   // %%
            preg_match('/^[^a-zA-Zأ-ي0-9]+$/u', $nom) // caractères spéciaux uniquement
        ) {
            $query->whereRaw('1 = 0'); // renvoie zéro résultat
        } else {
            $query->whereHas('investissements.utilisateur', function ($q) use ($nom) {
                $q->where('nom_prenom', 'LIKE', "%$nom%");
            });
        }
    }


    
	if ($request->search_option == "nature" && $request->filled('nature')) {
    $query->where('nature_projet_id', $request->nature);
}

    /*-------------------------------------------
     | 🔍 Recherche par نوع الهوية (cin/passport/fiscal)
       ⚠ les données viennent de utilisateur (table investissements.utilisateur)
    --------------------------------------------*/
    if ($request->search_option == "identite" && $request->filled('type_identite')) {

        /* --- CIN --- */
        if ($request->type_identite == 1 && $request->filled('cin')) {

            $cin = trim($request->cin);

            if ($cin === "" || preg_match('/[^0-9]/', $cin)) {
                $query->whereRaw('1 = 0');
            } else {
                $query->whereHas('investissements.utilisateur', function ($q) use ($cin) {
                    $q->where('cin', $cin);
                });
            }
        }

        /* --- Passeport --- */
        if ($request->type_identite == 2 && $request->filled('passport')) {

            $passport = trim($request->passport);

            if ($passport === "" || $passport === "%" || $passport === "%%") {
                $query->whereRaw('1 = 0');
            } else {
                $query->whereHas('investissements.utilisateur', function ($q) use ($passport) {
                    $q->where('passport', $passport);
                });
            }
        }

        /* --- Numéro fiscal --- */
        if ($request->type_identite == 3 && $request->filled('num_fiscal')) {

            $num = trim($request->num_fiscal);

            if ($num === "" || preg_match('/[^0-9]/', $num)) {
                $query->whereRaw('1 = 0');
            } else {
                $query->whereHas('investissements.utilisateur', function ($q) use ($num) {
                    $q->where('num_fiscal', $num);
                });
            }
        }
    }

    /*-------------------------------------------
     | Pagination
    --------------------------------------------*/
    $institutions = $query->orderByDesc('created_at')
        ->paginate(10)
        ->withQueryString();

    $natures = NatureProjet::all();

    return view('backoffice.investissement.gestion_jeunesse.index',
        compact('institutions', 'natures'));
}

public function exportExcel(Request $request)
{
    $query = InstitutionPriveJeunesse::with(['directeur','investissements.utilisateur','natureProjet','statut']);

    // Réutiliser les mêmes filtres que dans index
    if ($request->search_option == "nom" && $request->filled('nom')) {
        $nom = trim($request->nom);
        if ($nom !== "" && !preg_match('/^[^a-zA-Zأ-ي0-9]+$/u', $nom)) {
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('nom_prenom','LIKE',"%$nom%"));
        }
    }

    if ($request->search_option == "nature" && $request->filled('nature')) {
        $query->where('nature_projet_id', $request->nature);
    }

    if ($request->search_option == "identite" && $request->filled('type_identite')) {
        $type = $request->type_identite;

        if ($type == 1 && $request->filled('cin')) {
            $cin = trim($request->cin);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('cin',$cin));
        }
        if ($type == 2 && $request->filled('passport')) {
            $passport = trim($request->passport);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('passport',$passport));
        }
        if ($type == 3 && $request->filled('num_fiscal')) {
            $num = trim($request->num_fiscal);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('num_fiscal',$num));
        }
    }

    $institutions = $query->orderByDesc('created_at')->get();

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setRightToLeft(true);

    // Header
    $sheet->fromArray([
        ['المعرف','الاسم و اللقب','طبيعة المشروع','الحالة']
    ], null, 'A1');
    $sheet->getStyle('A1:D1')->getFont()->setBold(true);

    // Data
    $row = 2;
    foreach ($institutions as $inst) {
        $sheet->setCellValue('A'.$row, $inst->id_inst);
        $sheet->setCellValue('B'.$row, $inst->investissements->first()?->utilisateur?->nom_prenom ?? '---');
        $sheet->setCellValue('C'.$row, $inst->natureProjet?->nature_ar ?? '---');
        $sheet->setCellValue('D'.$row, $inst->statut?->statut_ar ?? 'في الانتظار');
        $row++;
    }

    foreach(range('A','D') as $col){ $sheet->getColumnDimension($col)->setAutoSize(true); }

    $writer = new Xlsx($spreadsheet);
    $fileName = 'institutions_jeunesse.xlsx';

    return response()->streamDownload(function() use ($writer){ $writer->save('php://output'); }, $fileName);
}
	
	public function exportPdf(Request $request)
{
    $query = InstitutionPriveJeunesse::with(['directeur','investissements.utilisateur','natureProjet','statut']);

    // Appliquer les mêmes filtres que index
    if ($request->search_option == "nom" && $request->filled('nom')) {
        $nom = trim($request->nom);
        if ($nom !== "" && !preg_match('/^[^a-zA-Zأ-ي0-9]+$/u', $nom)) {
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('nom_prenom','LIKE',"%$nom%"));
        }
    }

    if ($request->search_option == "nature" && $request->filled('nature')) {
        $query->where('nature_projet_id', $request->nature);
    }

    if ($request->search_option == "identite" && $request->filled('type_identite')) {
        $type = $request->type_identite;
        if ($type == 1 && $request->filled('cin')) {
            $cin = trim($request->cin);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('cin',$cin));
        }
        if ($type == 2 && $request->filled('passport')) {
            $passport = trim($request->passport);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('passport',$passport));
        }
        if ($type == 3 && $request->filled('num_fiscal')) {
            $num = trim($request->num_fiscal);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('num_fiscal',$num));
        }
    }

    $institutions = $query->orderByDesc('created_at')->get();

    $html = view('backoffice.investissement.gestion_jeunesse.exports.jeunesse_pdf', compact('institutions'))->render();

    $mpdf = new Mpdf([
        'mode'=>'utf-8',
        'format'=>'A4',
        'default_font'=>'dejavusans',
        'directionality'=>'rtl'
    ]);

    $mpdf->WriteHTML($html);

    return response($mpdf->Output('institutions_jeunesse.pdf','S'))
        ->header('Content-Type','application/pdf');
}



public function pdf($id)
{
    // =======================
    // 1️⃣ Charger l’institution + relations
    // =======================
    $institution = InstitutionPriveJeunesse::with([
        'directeur',
        'investissements',
        'investissements.utilisateur',
        
        'statut',
        'natureProjet'
    ])->findOrFail($id);

    $formulaire = TypeFormulaire::find(4);
    $types_espace = TypeEspaceInstitution::all();
    $secteurs   = SecteurFinancement::all();
    $source_fin = SourceFinancement::all();
    $nature_projet = NatureProjet::all();
    // =======================
    // 2️⃣ Langue & direction
    // =======================
    $lang = 'ar';
    $direction = 'rtl';

    // =======================
    // 3️⃣ Générer HTML du PDF
    // =======================
    $html = view(
        'backoffice.investissement.gestion_jeunesse.pdf',
        compact(
            'institution',
            'formulaire',
            'types_espace',
            'secteurs',
            'source_fin',
            'direction',
            'nature_projet',
            'lang'
        )
    )->render();

    // =======================
    // 4️⃣ Initialisation mPDF
    // =======================
    $mpdf = new Mpdf([
        'mode'              => 'utf-8',
        'format'            => 'A4',
        'default_font'      => 'dejavusans',
        'directionality'    => $direction,
        'autoScriptToLang'  => true,
        'autoLangToFont'    => true,
        'margin_top'        => 15,
        'margin_bottom'     => 15,
        'margin_left'       => 12,
        'margin_right'      => 12,
    ]);

    // Footer
    $mpdf->SetFooter('{PAGENO} / {nbpg}');

    $mpdf->WriteHTML($html);

    return $mpdf->Output(
        'institution_jeunesse_'.$id.'.pdf',
        'I'
    );
}



 public function pdf2($id)
{
    // =======================
    // 1️⃣ Charger l’activité + relations
    // =======================
    $activite = ActiviteJeuneEnfant::with([
        'investissements.utilisateur', 'investissements', 'gouvernorat'
    ])->findOrFail($id);

    $formulaire = TypeFormulaire::find(21);
    $secteurs = SecteurFinancement::all();
    $service_inst = ServiceInstitution::all();
    $source_fin = SourceFinancement::all();
    $nature = NatureActivite::all();
    $statut_inv = StatutInv::all();
   // $gouvernorats = Gouvernorat::all();
    $typesIdentite = Identite_personnel::all();

  /*  $delegations = [];
    if ($activite->id_gouvernorat) {
        $delegations = Delegation::where('gouver_id', $activite->id_gouvernorat)->get();
    }  */

    // =======================
    // 2️⃣ Langue & direction
    // =======================
    $lang = 'ar';
    $direction = 'rtl';
    // =======================
    // 3️⃣ Générer HTML du PDF
    // =======================
    $html = view(
        'backoffice.investissement.gestion_jeunesse.pdf2', // Crée une vue PDF dédiée pour show2
        compact(
            'activite',
            'formulaire',
            'service_inst',
            'secteurs',
            'source_fin',
            'nature',
            'statut_inv',
           // 'gouvernorats',
            'typesIdentite',
            //'delegations',
            'direction',
            'lang'
        )
    )->render();

    // =======================
    // 4️⃣ Initialisation mPDF
    // =======================
    $mpdf = new \Mpdf\Mpdf([
        'mode'              => 'utf-8',
        'format'            => 'A4',
        'default_font'      => 'dejavusans',
        'directionality'    => $direction,
        'autoScriptToLang'  => true,
        'autoLangToFont'    => true,
        'margin_top'        => 15,
        'margin_bottom'     => 15,
        'margin_left'       => 12,
        'margin_right'      => 12,
    ]);

    // Footer
    $mpdf->SetFooter('{PAGENO} / {nbpg}');

    // Générer le PDF
    $mpdf->WriteHTML($html);

    return $mpdf->Output(
        'activite_jeunesse_'.$id.'.pdf',
        'I'
    );
}


    public function create()
    {
        $formulaire = TypeFormulaire::find(4);
        $types_espace = TypeEspaceInstitution::all();
        $nature_projet = NatureProjet::all();
        $secteurs = SecteurFinancement::all();
        $service_inst = ServiceInstitution::all();
        $source_fin = SourceFinancement::all();


        $typesIdentite = Identite_personnel::all();

        return view('backoffice.investissement.gestion_jeunesse.create', compact(
            'formulaire','types_espace','service_inst','secteurs','nature_projet','source_fin',
            'typesIdentite'
        ));
    }

    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            // Validation
            $request->validate([
                // Investisseur
                'nom_prenom'       => 'required|string|max:255',
                'id_type_identite' => 'required|integer|exists:tp_type_identite_pers,id_type',
                'cin'              => 'nullable|string|max:20',
                'date_delivrance_cin' => 'nullable|date',
                'lieu_delivrance_cin' => 'nullable|string|max:255',
                'passport'         => 'nullable|string|max:50',
                'num_fiscal'       => 'nullable|string|max:50',
                'tel'              => 'nullable|string|max:20',
                'adresse'          => 'nullable|string|max:255',
                'lieu_naissance'   => 'nullable|string|max:100',
                'date_naissance'   => 'nullable|date',
                'niveau_etude'     => 'nullable|string|max:100',
                'dernier_diplome'  => 'nullable|string|max:100',
                'experience'       => 'nullable|string|max:100',

                // Directeur
                'nom_prenom_d'     => 'required|string|max:255',
                'num_cin'          => 'required|string|max:20',
                'date_delivrance'  => 'required|date',
                'lieu_delivrance'  => 'required|string|max:255',
                'niveau_etude'     => 'nullable|string|max:255',
                'dernier_diplome_obtenu' => 'nullable|string|max:255',

                // Investissement
                'investissements.*.secteur_invest_id' => 'required|integer|exists:tp_secteur_financement,id_secteur',
                'investissements.*.montant_inv'       => 'required|numeric',
                'investissements.*.id_source_financement' => 'required|integer|exists:tp_source_financement,id_source',
                'investissements.*.montant_fin'           => 'required|numeric',
                

                // Institution privée jeunesse
                'type_espace_id' => 'required|integer|exists:tp_types_espace_institution,id_type',
                'nom_projet'     => 'required|string|max:255',
                'nature_projet_id' => 'required|integer|exists:tp_nature_projet,id_nature_p',
                'nbr_chambre'    => 'nullable|integer|min:0',
                'nbr_salles'     => 'nullable|integer|min:0',
                'capacite_accueil_hebergement' => 'nullable|integer|min:0',
                'capacite_accueil_sous_tente'  => 'nullable|integer|min:0',
                'capacite_accueil_espace_animation' => 'nullable|integer|min:0',
                'nbr_emplois' => 'nullable|integer|min:0',
                'commentaire_motif' => 'nullable|string',
                'remarques' => 'nullable|string',
                'heberg_rest'=> 'required|in:0,1',
                'heberg_stage_activ'=> 'required|in:0,1',
                'camping'=> 'required|in:0,1',
                'activ_educative'=> 'required|in:0,1',
                'voyage'=> 'required|in:0,1',
                'evenement'=> 'required|in:0,1',
                'autre'=> 'required|in:0,1',
                'id_statut' => 'nullable|in:1,2,3',
                ]);

            $utilisateur = Utilisateur::create([
                'nom_prenom' => $request->nom_prenom,
                'id_type_identite' => $request->id_type_identite,
                'cin' => $request->cin,
                'date_delivrance_cin' => $request->date_delivrance_cin,
                'lieu_delivrance_cin' => $request->lieu_delivrance_cin,
                'passport' => $request->passport,
                'num_fiscal' => $request->num_fiscal,
                'tel' => $request->tel,
                'adresse' => $request->adresse,
                'lieu_naissance' => $request->lieu_naissance,
                'date_naissance' => $request->date_naissance,
                'niveau_etude' => $request->niveau_etude,
                'dernier_diplome' => $request->dernier_diplome,
                'experience' => $request->experience,
            ]);

            $directeur = DirecteurEtablissement::create([
                'nom_prenom_d' => $request->nom_prenom_d,
                'num_cin' => $request->num_cin,
                'date_delivrance' => $request->date_delivrance,
                'lieu_delivrance' => $request->lieu_delivrance,
                'niveau_etude' => $request->niveau_etude,
                'dernier_diplome_obtenu' => $request->dernier_diplome_obtenu,
            ]);

            $institution = InstitutionPriveJeunesse::create([
                'id_formulaire' => $request->id_formulaire,
                'id_statut'     => 2, 
                'type_espace_id' => $request->type_espace_id,
                'nbr_chambre' => $request->nbr_chambre,
                'nbr_salles' => $request->nbr_salles,
                'capacite_accueil_hebergement' => $request->capacite_accueil_hebergement,
                'capacite_accueil_sous_tente' => $request->capacite_accueil_sous_tente,
                'capacite_accueil_espace_animation' => $request->capacite_accueil_espace_animation,
                'nom_projet' => $request->nom_projet,
                'nature_projet_id' => $request->nature_projet_id,
                'nbr_emplois' => $request->nbr_emplois,
                'directeur_etabl_id' => $directeur->id_directeur,
                'commentaire_motif' => $request->commentaire_motif,
                'remarques' => $request->remarques,
                'heberg_rest'=> $request->heberg_rest,
                'heberg_stage_activ'=> $request->heberg_stage_activ,
                'camping'=> $request->camping,
                'activ_educative'=> $request->activ_educative,
                'voyage'=> $request->voyage,
                'evenement'=> $request->evenement,
                'autre'=> $request->autre,
            ]);

            if ($request->has('investissements')) {
                foreach ($request->investissements as $inv) {
                    Investissement::create([
                        'user_id' => $utilisateur->id,
                        'secteur_invest_id' => $inv['secteur_invest_id'],
                        'montant_inv' => $inv['montant_inv'],
                        'id_source_financement' => $inv['id_source_financement'] ?? null,
                        'montant_fin' => $inv['montant_fin'] ?? null,
                        'id_inst' => $institution->id_inst,
                    ]);
                }
            }

            DB::commit();
            return redirect()->route('admin.jeunesse.index')
                            ->with('success', 'Institution privée jeunesse enregistrée avec succès ✅');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => 'Erreur lors de l\'enregistrement : '.$e->getMessage()])
                        ->withInput();
        }
    }

public function edit($id)
{
    $institution = InstitutionPriveJeunesse::with(['directeur', 'investissements', 'investissements.utilisateur'])->findOrFail($id);
    $formulaire = TypeFormulaire::find(4);
    $types_espace = TypeEspaceInstitution::all();
    $nature_projet = NatureProjet::all();
    $secteurs = SecteurFinancement::all();
    $service_inst = ServiceInstitution::all();
    $source_fin = SourceFinancement::all();
    $typesIdentite = Identite_personnel::all();

    $statuts = \App\Models\TpStatut::all(); // <-- pass all statuses like debutActivite example

    return view('backoffice.investissement.gestion_jeunesse.edit', compact(
        'institution',
        'formulaire','types_espace','service_inst','secteurs','nature_projet','source_fin',
        'typesIdentite','statuts'
    ));
}

public function toggleStatut(Request $request, $id)
{
    $request->validate([
        'id_statut' => 'required|integer|in:1,2,3,4,5',
        'commentaire_motif' => 'nullable|string',
        'commentaire_refus' => 'nullable|string',
        'commentaire_status' => 'nullable|string',
        'commentaire_acceptation' => 'nullable|string',
        'commentaire_avis' => 'nullable|string',
    ]);

    DB::beginTransaction();
    try {
        // load model + relations
        $institution = InstitutionPriveJeunesse::with('investissements.utilisateur')->findOrFail($id);

        // remember old/new before modifying model
        $oldStatut = (int) ($institution->id_statut ?? 0);
        $newStatut = (int) $request->input('id_statut', $oldStatut);

        // no-op guard
        if ($oldStatut === $newStatut) {
            DB::rollBack();
            return redirect()->back()->with('info', 'لا تغيير في الوضعية.');
        }

        // choose comment (same order/logic as update)
        $comment = null;
        if ($request->filled('commentaire_refus')) {
            $comment = trim($request->input('commentaire_refus'));
        } elseif ($request->filled('commentaire_status')) {
            $comment = trim($request->input('commentaire_status'));
        } elseif ($request->filled('commentaire_motif')) {
            $comment = trim($request->input('commentaire_motif'));
        }

        // fallback on other fields if still empty
        if (($comment === null || $comment === '') && $request->filled('commentaire_acceptation')) {
            $comment = trim($request->input('commentaire_acceptation'));
        }
        if (($comment === null || $comment === '') && $request->filled('commentaire_avis')) {
            $comment = trim($request->input('commentaire_avis'));
        }
        if ($comment === '') $comment = null;

        // persist comment in the institution row similarly to update()
        // keep explicit refusal message in commentaire_motif if statut == 3
        if ($newStatut === 3 && $request->filled('commentaire_motif')) {
            $institution->commentaire_motif = $request->input('commentaire_motif');
        } elseif ($comment !== null) {
            // do not overwrite an existing commentaire_motif unless empty
            $institution->commentaire_motif = $institution->commentaire_motif ?: $comment;
        }

        // set statut and save
        $institution->id_statut = $newStatut;
        $institution->save();

        // create history row and keep reference (use null for '0')
        $history = \App\Models\ImmobilierStatutHistory::create([
            'institution_id'    => $institution->id_inst,
            'from_statut_id'    => $oldStatut ?: null,
            'to_statut_id'      => $newStatut ?: null,
            'changed_by'        => \Auth::id() ?? null,
            'commentaire'       => $comment,
        ]);

        DB::commit();
    } catch (\Exception $e) {
        DB::rollBack();
        \Log::error("toggleStatut error for InstitutionPriveJeunesse ID {$id}: " . $e->getMessage(), [
            'trace' => $e->getTraceAsString(),
            'request' => $request->all(),
        ]);
        return back()->withErrors(['error' => 'حدث خطأ أثناء تغيير الحالة: ' . $e->getMessage()]);
    }

    // --- After commit: send mail + DB notification (best-effort) ---
    try {
        // reload the institution (safe) and get user
        $institution = InstitutionPriveJeunesse::with('investissements.utilisateur')->findOrFail($id);
        $user = $institution->investissements->first()?->utilisateur ?? null;

        // map numeric -> normalized translation/mail type (consistent with update())
        $statusMap = [
            1 => 'accepted',
            3 => 'rejected',
            4 => 'incomplete',
            5 => 'deferred',
        ];
        $normType = $statusMap[$newStatut] ?? 'status_changed';

        // build translation params (used by DB notification)
        $translationParams = [];
        if ($normType === 'rejected') {
            $translationParams['reason'] = $request->input('commentaire_refus')
                ?? $request->input('commentaire_motif')
                ?? ($comment ?? '');
        } elseif ($normType === 'incomplete') {
            $translationParams['missing'] = $request->input('commentaire_acceptation') ?? ($comment ?? '');
        } elseif ($normType === 'deferred') {
            $translationParams['note'] = $request->input('commentaire_avis') ?? ($comment ?? '');
        }

        // decide motif to show in mail: prefer explicit inputs -> local $comment -> history comment
        $motif = $request->input('commentaire_refus')
              ?? $request->input('commentaire_motif')
              ?? ($comment ?? null);

        if (empty($motif) && isset($history)) {
            $motif = $history->commentaire ?? null;
        }

        \Log::info("toggleStatut: preparing mail/notification", [
            'institution_id' => $institution->id_inst,
            'old' => $oldStatut,
            'new' => $newStatut,
            'normType' => $normType,
            'motif' => $motif,
            'user_email' => $user->email ?? null,
        ]);

        if ($user && !empty($user->email)) {
            // send mail (best-effort) — Mail class expects (type, user, motif) in your code
            try {
                \Mail::to($user->email)->send(
                    new \App\Mail\JeunesseStatutMail($normType, $user, $motif)
                );
                \Log::info("toggleStatut: status email sent", ['institution_id' => $institution->id_inst, 'to' => $user->email, 'type' => $normType]);
            } catch (\Exception $mailEx) {
                \Log::error("toggleStatut: mail sending failed for institution {$institution->id_inst}: " . $mailEx->getMessage());
            }

            // DB notification (best-effort)
            try {
                $user->notify(new \App\Notifications\JeunesseStatutNotification(
                    $normType,
                    $translationParams,
                    $institution->id_inst
                ));
                \Log::info("toggleStatut: DB notification created", ['institution_id' => $institution->id_inst, 'user_id' => $user->id, 'type' => $normType]);
            } catch (\Exception $notifEx) {
                \Log::error("toggleStatut: notification saving failed for institution {$institution->id_inst}: " . $notifEx->getMessage());
            }
        } else {
            \Log::warning("toggleStatut: no user or missing email for institution ID {$institution->id_inst}");
        }
    } catch (\Exception $ex) {
        \Log::error("toggleStatut: notification/mail error for InstitutionPriveJeunesse ID {$id}: " . $ex->getMessage());
        // do not rollback — status & history already saved
    }

    return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح');
}



public function update(Request $request, $id)
{
    DB::beginTransaction();
    try {
        // ===== validation =====
        $request->validate([
            // Utilisateur
            'nom_prenom'       => 'required|string|max:255',
            'id_type_identite' => 'required|integer|exists:tp_type_identite_pers,id_type',
            'cin'              => 'nullable|string|max:20',
            'date_delivrance_cin' => 'nullable|date',
            'lieu_delivrance_cin' => 'nullable|string|max:255',
            'passport'         => 'nullable|string|max:50',
            'num_fiscal'       => 'nullable|string|max:50',
            'tel'              => 'nullable|string|max:20',
            'adresse'          => 'nullable|string|max:255',
            'lieu_naissance'   => 'nullable|string|max:100',
            'date_naissance'   => 'nullable|date',
            'niveau_etude_user'    => 'nullable|string|max:100',
            'dernier_diplome_user' => 'nullable|string|max:100',
            'experience_user'      => 'nullable|string|max:150',

            // Directeur
            'nom_prenom_d'     => 'required|string|max:255',
            'num_cin'          => 'required|string|max:20',
            'date_delivrance'  => 'required|date',
            'lieu_delivrance'  => 'required|string|max:255',
            'niveau_etude'     => 'nullable|string|max:255',
            'dernier_diplome_obtenu' => 'nullable|string|max:255',

            // Investissement
             'investissements'                          => 'nullable|array',
             'investissements.*.secteur_invest_id'     => 'required|integer|exists:tp_secteur_financement,id_secteur',
             'investissements.*.montant_inv'           => 'required|numeric',
             'investissements.*.id_source_financement' => 'required|integer|exists:tp_source_financement,id_source',
             'investissements.*.montant_fin'           => 'required|numeric',

            // Institution privée jeunesse
            'type_espace_id' => 'required|integer|exists:tp_types_espace_institution,id_type',
            'nom_projet'     => 'required|string|max:255',
            'nature_projet_id' => 'required|integer|exists:tp_nature_projet,id_nature_p',
            'nbr_chambre'    => 'nullable|integer|min:0',
            'nbr_salles'     => 'nullable|integer|min:0',
            'capacite_accueil_hebergement' => 'nullable|integer|min:0',
            'capacite_accueil_sous_tente'  => 'nullable|integer|min:0',
            'capacite_accueil_espace_animation' => 'nullable|integer|min:0',
            'nbr_emplois' => 'nullable|integer|min:0',
            'commentaire_motif' => 'nullable|string',
            'remarques' => 'nullable|string',
            'heberg_rest'=> 'required|in:0,1',
            'heberg_stage_activ'=> 'required|in:0,1',
            'camping'=> 'required|in:0,1',
            'activ_educative'=> 'required|in:0,1',
            'voyage'=> 'required|in:0,1',
            'evenement'=> 'required|in:0,1',
            'autre'=> 'required|in:0,1',
            'id_statut' => 'nullable', // ok, we'll handle changes
			 
        ]);

        /*$rules = [
            // Utilisateur
            'nom_prenom'       => 'required|string|max:255',
            'id_type_identite' => 'required|integer|exists:tp_type_identite_pers,id_type',
            //'cin'              => 'nullable|string|max:20',
            'date_delivrance_cin' => 'nullable|date',
            'lieu_delivrance_cin' => 'nullable|string|max:255',
            //'passport'         => 'nullable|string|max:50',
            //'num_fiscal'       => 'nullable|string|max:50',
            'tel'              => 'nullable|string|max:20',
            'adresse'          => 'nullable|string|max:255',
            'lieu_naissance'   => 'nullable|string|max:100',
            'date_naissance'   => 'nullable|date',
            'niveau_etude'     => 'nullable|string|max:100',
            'dernier_diplome'  => 'nullable|string|max:100',
            'experience'       => 'nullable|string|max:100',


            'cin' => 'nullable|digits:8|unique:utilisateur,cin,' . $immobilier->utilisateur->id . ',id',
            'passport' => 'nullable|digits_between:8,12|unique:utilisateur,passport,' . $immobilier->utilisateur->id . ',id',
            'num_fiscal' => 'nullable|string|unique:utilisateur,num_fiscal,' . $immobilier->utilisateur->id . ',id',


            // Directeur
            'nom_prenom_d'     => 'required|string|max:255',
            'num_cin'          => 'required|string|max:20',
            'date_delivrance'  => 'required|date',
            'lieu_delivrance'  => 'required|string|max:255',
            'niveau_etude'     => 'nullable|string|max:255',
            'dernier_diplome_obtenu' => 'nullable|string|max:255',

            // Investissement
             'investissements'                          => 'nullable|array',
             'investissements.*.secteur_invest_id'     => 'required|integer|exists:tp_secteur_financement,id_secteur',
             'investissements.*.montant_inv'           => 'required|numeric',
             'investissements.*.id_source_financement' => 'required|integer|exists:tp_source_financement,id_source',
             'investissements.*.montant_fin'           => 'required|numeric',

            // Institution privée jeunesse
            'type_espace_id' => 'required|integer|exists:tp_types_espace_institution,id_type',
            'nom_projet'     => 'required|string|max:255',
            'nature_projet_id' => 'required|integer|exists:tp_nature_projet,id_nature_p',
            'nbr_chambre'    => 'nullable|integer|min:0',
            'nbr_salles'     => 'nullable|integer|min:0',
            'capacite_accueil_hebergement' => 'nullable|integer|min:0',
            'capacite_accueil_sous_tente'  => 'nullable|integer|min:0',
            'capacite_accueil_espace_animation' => 'nullable|integer|min:0',
            'nbr_emplois' => 'nullable|integer|min:0',
            'commentaire_motif' => 'nullable|string',
            'remarques' => 'nullable|string',
            'heberg_rest'=> 'required|in:0,1',
            'heberg_stage_activ'=> 'required|in:0,1',
            'camping'=> 'required|in:0,1',
            'activ_educative'=> 'required|in:0,1',
            'voyage'=> 'required|in:0,1',
            'evenement'=> 'required|in:0,1',
            'autre'=> 'required|in:0,1',
            'id_statut' => 'nullable', // ok, we'll handle changes
            ];
$type = (int) $request->id_type_identite;

// CIN
if ($type === 1) {
    $rules['cin'] = 'required|digits:8|unique:utilisateur,cin,' . $immobilier->utilisateur->id . ',id';
}

// PASSPORT
if ($type === 2) {
    $rules['passport'] = 'required|digits_between:8,12|unique:utilisateur,passport,' . $immobilier->utilisateur->id . ',id';
}

// NUM FISCAL
if ($type === 3) {
    $rules['num_fiscal'] = [
        'required',
        'string',
        'unique:utilisateur,num_fiscal,' . $immobilier->utilisateur->id . ',id',
        'regex:/^[A-Za-z0-9]{7}\/[A-Za-z]\/[A-Za-z]\/[A-Za-z]\/[A-Za-z0-9]{3}$/'
    ];
}
$request->validate($rules);
*/
        // ===== load model =====
        $institution = InstitutionPriveJeunesse::with(['directeur','investissements','investissements.utilisateur'])
            ->findOrFail($id);

        // remember old/new statut BEFORE modifying model
        $oldStatut = (int) ($institution->id_statut ?? 0);
        $newStatut = (int) ($request->input('id_statut') ?? $oldStatut);

        // build comment (prefer explicit fields)
        $comment = null;
        if ($request->filled('commentaire_refus')) {
            $comment = trim($request->input('commentaire_refus'));
        } elseif ($request->filled('commentaire_status')) {
            $comment = trim($request->input('commentaire_status'));
        } elseif ($request->filled('commentaire_motif')) {
            $comment = trim($request->input('commentaire_motif'));
        }
        if ($comment === '') $comment = null;

        // update utilisateur if exists
        $utilisateur = $institution->investissements->first()?->utilisateur;
        if ($utilisateur) {
            $utilisateur->update([
                'nom_prenom' => $request->nom_prenom,
                'id_type_identite' => $request->id_type_identite,
                'cin' => $request->cin,
                'date_delivrance_cin' => $request->date_delivrance_cin,
                'lieu_delivrance_cin' => $request->lieu_delivrance_cin,
                'passport' => $request->passport,
                'num_fiscal' => $request->num_fiscal,
                'tel' => $request->tel,
                'adresse' => $request->adresse,
                'lieu_naissance' => $request->lieu_naissance,
                'date_naissance' => $request->date_naissance,
                
            ]);
        }

        // update directeur if exists
        $directeur = $institution->directeur;
        if ($directeur) {
            $directeur->update([
                'nom_prenom_d' => $request->nom_prenom_d,
                'num_cin' => $request->num_cin,
                'date_delivrance' => $request->date_delivrance,
                'lieu_delivrance' => $request->lieu_delivrance,
                'niveau_etude' => $request->niveau_etude,
                'dernier_diplome_obtenu' => $request->dernier_diplome_obtenu,
            ]);
        }

        // update institution record
        $institution->update([
            'type_espace_id' => $request->type_espace_id,
            'nom_projet' => $request->nom_projet,
            'id_statut' => $newStatut,
            // use institution model for fallback
            'id_formulaire' => $institution->id_formulaire ?? 4,
            'nature_projet_id' => $request->nature_projet_id,
            'nbr_chambre' => $request->nbr_chambre,
            'nbr_salles' => $request->nbr_salles,
            'capacite_accueil_hebergement' => $request->capacite_accueil_hebergement,
            'capacite_accueil_sous_tente' => $request->capacite_accueil_sous_tente,
            'capacite_accueil_espace_animation' => $request->capacite_accueil_espace_animation,
            'nbr_emplois' => $request->nbr_emplois,
            // save chosen comment
            'commentaire_motif' => $comment,
            'remarques' => $request->remarques,
            'heberg_rest'=> $request->heberg_rest,
            'heberg_stage_activ'=> $request->heberg_stage_activ,
            'camping'=> $request->camping,
            'activ_educative'=> $request->activ_educative,
            'voyage'=> $request->voyage,
            'evenement'=> $request->evenement,
            'autre'=> $request->autre,
			'niveau_etude_user'=> $request->niveau_etude_user,
                'dernier_diplome_user'=> $request->dernier_diplome_user,
                'experience_user'=> $request->experience_user,
				'id_user'            => $utilisateur->id,
        ]);

        // replace investments if provided
  // replace investments if provided
if ($request->filled('investissements') && is_array($request->input('investissements'))) {
    // delete old then recreate
    $institution->investissements()->delete();

    foreach ($request->input('investissements') as $inv) {
        // sanitize / cast minimal
        $secteur = (int) ($inv['secteur_invest_id'] ?? 0);
        $montant_inv = $inv['montant_inv'] ?? null;
        $id_source = $inv['id_source_financement'] ?? null;
        $montant_fin = $inv['montant_fin'] ?? null;

        Investissement::create([
            'user_id'             => $utilisateur?->id ?? null,
            'secteur_invest_id'   => $secteur,
            'montant_inv'         => $montant_inv,
            // map the source column to the real DB column:
            // if your table column is named `id_source_financement` use that,
            // if it's `source` keep `source` — adjust below accordingly.
            'id_source_financement' => $id_source, // <-- prefer this if DB column exists
            //'source'             => $id_source,   // <-- uncomment if your column is `source`
            'montant_fin'         => $montant_fin,
            'remarques'           => $inv['remarques'] ?? null,
            'id_inst'             => $institution->id_inst,
        ]);
    }
}


        // create history row only if statut changed
        if ($oldStatut !== $newStatut) {
            \App\Models\ImmobilierStatutHistory::create([
                'institution_id'    => $institution->id_inst,
                'from_statut_id'    => $oldStatut ?: null,
                'to_statut_id'      => $newStatut ?: null,
                'changed_by'        => \Auth::id() ?? null,
                'commentaire'       => $comment,
            ]);
        }

        DB::commit();

         // ----------------------
        // Notifications (like toggleStatut)
        // ----------------------

if ($oldStatut !== $newStatut) {
    try {
        $user = $utilisateur ?? null; // same variable you already set
        // keep the same numeric->string mapping (consistent with mail/template)
        $statusMap = [
            1 => 'accepted',
            3 => 'rejected',
            4 => 'incomplete',
            5 => 'deferred',
        ];
        $normType = $statusMap[$newStatut] ?? 'status_changed';

        // build translation params (same keys as other notifications)
        $translationParams = [];
        if ($normType === 'rejected') {
            $translationParams['reason'] = $request->input('commentaire_refus')
                ?? $request->input('commentaire_motif')
                ?? ($comment ?? '');
        } elseif ($normType === 'incomplete') {
            $translationParams['missing'] = $request->input('commentaire_acceptation') ?? ($comment ?? '');
        } elseif ($normType === 'deferred') {
            $translationParams['note'] = $request->input('commentaire_avis') ?? ($comment ?? '');
        }

        if ($user && !empty($user->email)) {
            // determine motif string for the mail (prefer dedicated inputs, then $comment)
            $motif = $request->input('commentaire_refus')
                   ?? $request->input('commentaire_motif')
                   ?? ($comment ?? null);

            try {
                // send mail for all four types (best-effort)
                \Mail::to($user->email)->send(
                    new \App\Mail\JeunesseStatutMail($normType, $user, $motif)
                );
            } catch (\Exception $mailEx) {
                \Log::error("Mail sending failed for institution {$institution->id_inst}: " . $mailEx->getMessage());
            }

            // DB notification (store translation key + params) — keep your existing notification class
            try {
                $user->notify(new \App\Notifications\JeunesseStatutNotification(
                    $normType,
                    $translationParams,
                    $institution->id_inst
                ));
            } catch (\Exception $notifEx) {
                \Log::error("Notification saving failed for institution {$institution->id_inst}: " . $notifEx->getMessage());
            }
        } else {
            \Log::warning("Aucun utilisateur (ou email manquant) pour institution ID: {$institution->id_inst}");
        }
    } catch (\Exception $ex) {
        \Log::error("Notification/mail error for InstitutionPriveJeunesse ID {$institution->id_inst}: " . $ex->getMessage());
        // do not rollback — status & history already saved
    }
}


        return redirect()->route('admin.jeunesse.index')
                         ->with('success', 'تم تحديث المؤسسة بنجاح ');

    } catch (\Exception $e) {
        DB::rollBack();
        // log full exception for debugging
        \Log::error('Institution update error: '.$e->getMessage(), [
            'id'=>$id, 'trace'=>$e->getTraceAsString()
        ]);

        // return back with a helpful error message (already did in your code)
        return back()->withErrors(['error' => 'حدث خطأ أثناء تحديث المؤسسة: '.$e->getMessage()])->withInput();
     }
}

    public function show($id)
    {
        $institution = InstitutionPriveJeunesse::with(['directeur', 'investissements', 'investissements.utilisateur'])->findOrFail($id);
        $formulaire = TypeFormulaire::find(4);
        $types_espace = TypeEspaceInstitution::all();
        $nature_projet = NatureProjet::all();
        $secteurs = SecteurFinancement::all();
        $service_inst = ServiceInstitution::all();
        $source_fin = SourceFinancement::all();
        $typesIdentite = Identite_personnel::all();
        $statuts = \App\Models\TpStatut::all(); 
        return view('backoffice.investissement.gestion_jeunesse.show', compact('institution',
            'formulaire','types_espace','service_inst','secteurs','nature_projet','source_fin',
            'typesIdentite', 'statuts'
        ));
    }

    public function destroy($id)
    {
        DB::beginTransaction();
        try {
            $institution = InstitutionPriveJeunesse::with(['investissements', 'directeur'])->findOrFail($id);
            if ($institution->investissements->isNotEmpty()) {
                foreach ($institution->investissements as $inv) {
                    $inv->delete();
                }
            }
            if ($institution->directeur) {
                $institution->directeur->delete();
            }
            $institution->delete();

            DB::commit();
            return redirect()->route('admin.jeunesse.index')
                            ->with('success', 'تم الحذف بنجاح');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->route('admin.jeunesse.index')
                            ->withErrors(['error' => 'Erreur lors de la suppression : '.$e->getMessage()]);
        }
    }


    /* section 2 */

    /*public function index2(Request $request)
    {
        $activites = ActiviteJeuneEnfant::with([
            'investissements.utilisateur',
            'investissements',
            'statut',
            'natureActivite'
        ])
        ->orderByDesc('created_at')
        ->paginate(10);

        return view('backoffice.investissement.gestion_jeunesse.index2', compact('activites'));
    }*/
	
	
	public function index2(Request $request)
{
    $query = ActiviteJeuneEnfant::with([
	'investissements.utilisateur',
            'investissements',
            'statut',
            'natureActivite'
        
    ]);

    if ($request->search_option == "nom") {

        $nom = trim($request->nom);

        // Cas invalides → retour liste vide
        if (
            $nom === "" ||                     // vide ou espace
            $nom === "%" ||                    // %
            $nom === "%%" ||                   // %%
            preg_match('/^[^a-zA-Zأ-ي0-9]+$/u', $nom) // caractères spéciaux uniquement
        ) {
            $query->whereRaw('1 = 0'); // renvoie zéro résultat
        } else {
            $query->whereHas('investissements.utilisateur', function ($q) use ($nom) {
                $q->where('nom_prenom', 'LIKE', "%$nom%");
            });
        }
    }



    if ($request->search_option == "identite" && $request->filled('type_identite')) {

        /* --- CIN --- */
        if ($request->type_identite == 1 && $request->filled('cin')) {

            $cin = trim($request->cin);

            if ($cin === "" || preg_match('/[^0-9]/', $cin)) {
                $query->whereRaw('1 = 0');
            } else {
                $query->whereHas('investissements.utilisateur', function ($q) use ($cin) {
                    $q->where('cin', $cin);
                });
            }
        }

        /* --- Passeport --- */
        if ($request->type_identite == 2 && $request->filled('passport')) {

            $passport = trim($request->passport);

            if ($passport === "" || $passport === "%" || $passport === "%%") {
                $query->whereRaw('1 = 0');
            } else {
                $query->whereHas('investissements.utilisateur', function ($q) use ($passport) {
                    $q->where('passport', $passport);
                });
            }
        }

        /* --- Numéro fiscal --- */
        if ($request->type_identite == 3 && $request->filled('num_fiscal')) {

            $num = trim($request->num_fiscal);

            if ($num === "" || preg_match('/[^0-9]/', $num)) {
                $query->whereRaw('1 = 0');
            } else {
                $query->whereHas('investissements.utilisateur', function ($q) use ($num) {
                    $q->where('num_fiscal', $num);
                });
            }
        }
    }

    /*-------------------------------------------
     | Pagination
    --------------------------------------------*/
    $activites = $query->orderByDesc('created_at')
        ->paginate(10)
        ->withQueryString();

    

    return view('backoffice.investissement.gestion_jeunesse.index2',
        compact('activites'));
}

public function exportExcel2(Request $request)
{
    $query = ActiviteJeuneEnfant::with(['investissements.utilisateur','investissements','statut','natureActivite']);

    // Réutiliser les mêmes filtres que index2
    if ($request->search_option == "nom" && $request->filled('nom')) {
        $nom = trim($request->nom);
        if ($nom !== "" && !preg_match('/^[^a-zA-Zأ-ي0-9]+$/u', $nom)) {
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('nom_prenom','LIKE',"%$nom%"));
        }
    }

    if ($request->search_option == "identite" && $request->filled('type_identite')) {
        $type = $request->type_identite;

        if ($type == 1 && $request->filled('cin')) {
            $cin = trim($request->cin);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('cin',$cin));
        }
        if ($type == 2 && $request->filled('passport')) {
            $passport = trim($request->passport);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('passport',$passport));
        }
        if ($type == 3 && $request->filled('num_fiscal')) {
            $num = trim($request->num_fiscal);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('num_fiscal',$num));
        }
    }

    $activites = $query->orderByDesc('created_at')->get();

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setRightToLeft(true);

    $sheet->fromArray([
        ['المعرف','الاسم و اللقب','طبيعة النشاط','الحالة']
    ], null, 'A1');

    $sheet->getStyle('A1:D1')->getFont()->setBold(true);

    $row = 2;
    foreach ($activites as $act) {
        $sheet->setCellValue('A'.$row, $act->id_jeune_enfant);
        $sheet->setCellValue('B'.$row, $act->investissements->first()?->utilisateur?->nom_prenom ?? '---');
        $sheet->setCellValue('C'.$row, $act->natureActivite?->nature_ar ?? '---');
        $sheet->setCellValue('D'.$row, $act->statut?->statut_ar ?? 'في الانتظار');
        $row++;
    }

    foreach(range('A','D') as $col){ $sheet->getColumnDimension($col)->setAutoSize(true); }

    $writer = new Xlsx($spreadsheet);
    $fileName = 'activites_jeunesse.xlsx';

    return response()->streamDownload(function() use ($writer){ $writer->save('php://output'); }, $fileName);
}

public function exportPdf2(Request $request)
{
    $query = ActiviteJeuneEnfant::with(['investissements.utilisateur','investissements','statut','natureActivite']);

    // Filtres comme index2
    if ($request->search_option == "nom" && $request->filled('nom')) {
        $nom = trim($request->nom);
        if ($nom !== "" && !preg_match('/^[^a-zA-Zأ-ي0-9]+$/u', $nom)) {
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('nom_prenom','LIKE',"%$nom%"));
        }
    }

    if ($request->search_option == "identite" && $request->filled('type_identite')) {
        $type = $request->type_identite;
        if ($type == 1 && $request->filled('cin')) {
            $cin = trim($request->cin);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('cin',$cin));
        }
        if ($type == 2 && $request->filled('passport')) {
            $passport = trim($request->passport);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('passport',$passport));
        }
        if ($type == 3 && $request->filled('num_fiscal')) {
            $num = trim($request->num_fiscal);
            $query->whereHas('investissements.utilisateur', fn($q) => $q->where('num_fiscal',$num));
        }
    }

    $activites = $query->orderByDesc('created_at')->get();

    $html = view('backoffice.investissement.gestion_jeunesse.exports.jeunesse2_pdf', compact('activites'))->render();

    $mpdf = new Mpdf([
        'mode'=>'utf-8',
        'format'=>'A4',
        'default_font'=>'dejavusans',
        'directionality'=>'rtl'
    ]);

    $mpdf->WriteHTML($html);

    return response($mpdf->Output('activites_jeunesse.pdf','S'))
        ->header('Content-Type','application/pdf');
}
    public function create2()
    {
        $formulaire = TypeFormulaire::find(21);
        $secteurs = SecteurFinancement::all();
        $service_inst = ServiceInstitution::all();
        $source_fin = SourceFinancement::all();
        $nature_activite = NatureActivite::all();
        $statut_inv = StatutInv::all();
        $gouvernorats = Gouvernorat::all();

        $typesIdentite = Identite_personnel::all();

        return view('backoffice.investissement.gestion_jeunesse.create2', compact(
            'formulaire','service_inst','secteurs','source_fin','nature_activite','statut_inv','gouvernorats',
            'typesIdentite'
        ));
    }

    public function store2(Request $request)
    {
        DB::beginTransaction();
        try {
            $request->validate([
                // Utilisateur
                'nom_prenom'       => 'required|string|max:255',
                'id_type_identite' => 'required|integer|exists:tp_type_identite_pers,id_type',
                'cin'              => 'nullable|string|max:20',
                'date_delivrance_cin' => 'nullable|date',
                'lieu_delivrance_cin' => 'nullable|string|max:255',
                'passport'         => 'nullable|string|max:50',
                'num_fiscal'       => 'nullable|string|max:50',
                'tel'              => 'nullable|string|max:20',
                'adresse'          => 'required|string|max:255',
                'lieu_naissance'   => 'required|string|max:100',
                'date_naissance'   => 'required|date',
                'niveau_etude'     => 'nullable|string|max:100',
                'dernier_diplome'  => 'nullable|string|max:100',
                'experience'       => 'nullable|string|max:100',

                // Activité
                'nom_projet'         => 'required|string|max:255',
                'code_postal'        => 'required|integer',
                'gouvernorat_id'     => 'required|exists:tp_gouvernorat,id_gouver',
                'delegation_id'      => 'required|exists:tp_delegation,id_delegation',
                'id_statut_inv'      => 'required|exists:tp_statut_inv,id_status',
                'id_nature_activite' => 'required|exists:tp_nature_activite,id_nature_ac',
                'remarques'          => 'nullable|string',
                'id_statut'          => 'nullable|in:1,2,3',

                // Investissements
                'investissements.*.secteur_invest_id' => 'required|integer|exists:tp_secteur_financement,id_secteur',
                'investissements.*.montant_inv'       => 'required|numeric',
                'investissements.*.id_source_financement' => 'required|integer|exists:tp_source_financement,id_source',
                'investissements.*.montant_fin'           => 'required|numeric',
            ]);

            $utilisateur = Utilisateur::create([
                'nom_prenom' => $request->nom_prenom,
                'id_type_identite' => $request->id_type_identite,
                'cin' => $request->cin,
                'date_delivrance_cin' => $request->date_delivrance_cin,
                'lieu_delivrance_cin' => $request->lieu_delivrance_cin,
                'passport' => $request->passport,
                'num_fiscal' => $request->num_fiscal,
                'tel' => $request->tel,
                'adresse' => $request->adresse,
                'lieu_naissance' => $request->lieu_naissance,
                'date_naissance' => $request->date_naissance,
                'niveau_etude' => $request->niveau_etude,
                'dernier_diplome' => $request->dernier_diplome,
                'experience' => $request->experience,
            ]);

            $activite = ActiviteJeuneEnfant::create([
                'nom_projet'       => $request->nom_projet,
                'adresse_siege'    => $request->adresse,
                'code_postal'      => $request->code_postal,
                'id_formulaire'    => $request->id_formulaire,
                'id_statut'        => 2, 
                'id_statut_inv'    => $request->id_statut_inv,
                'id_nature_activite' => $request->id_nature_activite,
                'id_gouvernorat'   => $request->gouvernorat_id,
                'id_delegation'    => $request->delegation_id,
                'id_user'          => $utilisateur->id,
                'remarques'        => $request->remarques,
            ]);

            if ($request->has('investissements')) {
                foreach ($request->investissements as $inv) {
                    Investissement::create([
                        'user_id' => $utilisateur->id,
                        'secteur_invest_id' => $inv['secteur_invest_id'],
                        'montant_inv' => $inv['montant_inv'],
                        'id_source_financement' => $inv['id_source_financement'] ?? null,
                        'montant_fin' => $inv['montant_fin'] ?? null,
                        'id_jeune_enfant' => $activite->id_jeune_enfant,
                    ]);
                }
            }

            DB::commit();
            return redirect()->route('admin.jeunesse2.index')
                            ->with('success', 'نشاط خاص بالطفولة و الشباب تم تسجيله بنجاح ✅');

        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => 'Erreur lors de l\'enregistrement : '.$e->getMessage()])
                        ->withInput();
        }
    }
public function edit2($id)
{
    $activite = ActiviteJeuneEnfant::with([
        'investissements.utilisateur',
        'investissements',
        'gouvernorat',
        'delegation',
        // eager load history relations:
        'statutHistories.fromStatut',
        'statutHistories.toStatut',
        'statutHistories.changer'
    ])->findOrFail($id);

    $formulaire = TypeFormulaire::find(21);
    $secteurs = SecteurFinancement::all();
    $service_inst = ServiceInstitution::all();
    $source_fin = SourceFinancement::all();
    $nature = NatureActivite::all();
    $statut_inv = StatutInv::all();
    $gouvernorats = Gouvernorat::all();
    $typesIdentite = Identite_personnel::all();
    $statuts = \App\Models\TpStatut::all(); 
    $delegations = [];
    if ($activite->id_gouvernorat) {
        $delegations = Delegation::where('gouver_id', $activite->id_gouvernorat)->get();
    }

    return view('backoffice.investissement.gestion_jeunesse.edit2', compact(
        'activite','formulaire','service_inst','secteurs','source_fin',
        'nature','statut_inv','gouvernorats','typesIdentite','delegations','statuts'
    ));
}

public function toggleStatut2(Request $request, $id)
{
    $request->validate([
        'id_statut' => 'required|integer|in:1,2,3,4,5',
        'commentaire_motif' => 'nullable|string',
        'commentaire_refus' => 'nullable|string',
        'commentaire_status' => 'nullable|string',
        'commentaire_acceptation' => 'nullable|string',
        'commentaire_avis' => 'nullable|string',
    ]);

    DB::beginTransaction();
    try {
        $activite = ActiviteJeuneEnfant::with(['investissements.utilisateur'])->findOrFail($id);

        // old/new
        $oldStatut = (int) ($activite->id_statut ?? 0);
        $newStatut = (int) ($request->input('id_statut') ?? $oldStatut);

        if ($oldStatut === $newStatut) {
            DB::rollBack();
            return redirect()->back()->with('info', 'لا تغيير في الوضعية.');
        }

        // prepare comment (same logic as update)
        $comment = null;
        if ($request->filled('commentaire_refus')) {
            $comment = trim($request->input('commentaire_refus'));
        } elseif ($request->filled('commentaire_status')) {
            $comment = trim($request->input('commentaire_status'));
        } elseif ($request->filled('commentaire_motif')) {
            $comment = trim($request->input('commentaire_motif'));
        }
        if (($comment === null || $comment === '') && $request->filled('commentaire_acceptation')) {
            $comment = trim($request->input('commentaire_acceptation'));
        }
        if (($comment === null || $comment === '') && $request->filled('commentaire_avis')) {
            $comment = trim($request->input('commentaire_avis'));
        }
        if ($comment === '') $comment = null;

        // persist change on model (store refusal explicitly when given)
        if ($newStatut == 3 && $request->filled('commentaire_motif')) {
            $activite->commentaire_motif = $request->input('commentaire_motif');
        } elseif ($comment !== null && $activite->commentaire_motif === null) {
            $activite->commentaire_motif = $comment;
        }

        $activite->id_statut = $newStatut;
        $activite->save();

        // create history row (use null instead of 0)
        $history = ImmobilierStatutHistory::create([
            'jeune_enfant_id' => $activite->id_jeune_enfant,
            'from_statut_id'  => $oldStatut ?: null,
            'to_statut_id'    => $newStatut ?: null,
            'changed_by'      => Auth::id() ?? null,
            'commentaire'     => $comment,
        ]);

        DB::commit();
    } catch (\Exception $e) {
        DB::rollBack();
        \Log::error("toggleStatut2 error for ActiviteJeuneEnfant ID {$id}: " . $e->getMessage(), [
            'trace' => $e->getTraceAsString(),
            'request' => $request->all(),
        ]);
        return back()->withErrors(['error' => 'حدث خطأ أثناء تغيير الحالة: ' . $e->getMessage()]);
    }

    // --- AFTER COMMIT: best-effort mail + DB notification ---
    try {
        $activite = ActiviteJeuneEnfant::with(['investissements.utilisateur'])->findOrFail($id);
        $user = $activite->investissements->first()?->utilisateur ?? null;

        // map numeric statut -> mail type (Mailable expects arabic strings used elsewhere)
        $mailTypeMap = [
            1 => 'accepte',
            3 => 'refuse',
            4 => 'incomplet',
            5 => 'deferre',
        ];
        $mailType = $mailTypeMap[$newStatut] ?? 'status_changed';

        // notification normalized type (english keys for your DB notifications)
        $notifyTypeMap = [
            1 => 'accepted',
            3 => 'rejected',
            4 => 'incomplete',
            5 => 'deferred',
        ];
        $notifyType = $notifyTypeMap[$newStatut] ?? 'status_changed';

        // build motif: prefer explicit request value, then history->commentaire
        $motif = $request->input('commentaire_refus')
              ?? $request->input('commentaire_motif')
              ?? $request->input('commentaire_acceptation')
              ?? $request->input('commentaire_avis')
              ?? $comment
              ?? ($history->commentaire ?? null);

        // build translation params for DB-notification
        $translationParams = [];
        if ($notifyType === 'rejected') {
            $translationParams['reason'] = $motif ?? '';
        } elseif ($notifyType === 'incomplete') {
            $translationParams['missing'] = $motif ?? '';
        } elseif ($notifyType === 'deferred') {
            $translationParams['note'] = $motif ?? '';
        }

        if ($user && !empty($user->email)) {
            // send mail (best-effort)
            try {
                Mail::to($user->email)->send(
                    new Jeunesse2StatutMail($mailType, $user, $motif)
                );
                \Log::info("toggleStatut2: status email sent", ['activite_id' => $activite->id_jeune_enfant, 'to' => $user->email, 'type' => $mailType]);
            } catch (\Throwable $mailEx) {
                \Log::error("toggleStatut2: mail sending failed for activite {$activite->id_jeune_enfant}: " . $mailEx->getMessage());
            }

            // DB notification
            try {
                $user->notify(new Jeunesse2StatutNotification($notifyType, $translationParams));
                \Log::info("toggleStatut2: DB notification stored", ['activite_id' => $activite->id_jeune_enfant, 'user' => $user->id, 'type' => $notifyType]);
            } catch (\Throwable $notifEx) {
                \Log::error("toggleStatut2: notification saving failed for activite {$activite->id_jeune_enfant}: " . $notifEx->getMessage());
            }
        } else {
            \Log::warning("toggleStatut2: no user or missing email for activite ID: {$activite->id_jeune_enfant}");
        }
    } catch (\Exception $ex) {
        \Log::error("toggleStatut2: notification/mail error for ActiviteJeuneEnfant ID {$id}: " . $ex->getMessage());
    }

    return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح');
}



public function update2(Request $request, $id)
{
    DB::beginTransaction();
    try {
        $activite = ActiviteJeuneEnfant::with(['investissements.utilisateur', 'investissements'])->findOrFail($id);

        $request->validate([
            // Utilisateur
            'nom_prenom'       => 'required|string|max:255',
            'id_type_identite' => 'required|integer|exists:tp_type_identite_pers,id_type',
            'cin'              => 'nullable|string|max:20',
            'date_delivrance_cin' => 'nullable|date',
            'lieu_delivrance_cin' => 'nullable|string|max:255',
            'passport'         => 'nullable|string|max:50',
            'num_fiscal'       => 'nullable|string|max:50',
            'tel'              => 'nullable|string|max:20',
            'adresse'          => 'required|string|max:255',
            'lieu_naissance'   => 'required|string|max:100',
            'date_naissance'   => 'required|date',
            'niveau_etude_user'    => 'nullable|string|max:100',
            'dernier_diplome_user' => 'nullable|string|max:100',
            'experience_user'      => 'nullable|string|max:150',

            // Activité
            'nom_projet'         => 'required|string|max:255',
            'code_postal'        => 'required|integer',
            'gouvernorat_id'     => 'required|exists:tp_gouvernorat,id_gouver',
            'delegation_id'      => 'required|exists:tp_delegation,id_delegation',
            'id_statut_inv'      => 'required|exists:tp_statut_inv,id_status',
            'id_nature_activite' => 'required|exists:tp_nature_activite,id_nature_ac',
            'remarques'          => 'nullable|string',
            'id_statut'          => 'nullable',

            // Investissements
            'investissements.*.secteur_invest_id' => 'required|integer|exists:tp_secteur_financement,id_secteur',
            'investissements.*.montant_inv'       => 'required|numeric',
            'investissements.*.id_source_financement' => 'required|integer|exists:tp_source_financement,id_source',
            'investissements.*.montant_fin'           => 'required|numeric',
        ]);

        $oldStatut = (int) ($activite->id_statut ?? 0);
        $newStatut = (int) ($request->input('id_statut') ?? $oldStatut);

        // build comment (prefer explicit fields)
        $comment = null;
        if ($request->filled('commentaire_refus')) {
            $comment = trim($request->input('commentaire_refus'));
        } elseif ($request->filled('commentaire_status')) {
            $comment = trim($request->input('commentaire_status'));
        } elseif ($request->filled('commentaire_motif')) {
            $comment = trim($request->input('commentaire_motif'));
        }
        if ($comment === '') $comment = null;

        // update utilisateur if exists
        $utilisateur = $activite->investissements->first()?->utilisateur;
        if ($utilisateur) {
            $utilisateur->update([
                'nom_prenom' => $request->nom_prenom,
                'id_type_identite' => $request->id_type_identite,
                'cin' => $request->cin,
                'date_delivrance_cin' => $request->date_delivrance_cin,
                'lieu_delivrance_cin' => $request->lieu_delivrance_cin,
                'passport' => $request->passport,
                'num_fiscal' => $request->num_fiscal,
                'tel' => $request->tel,
                'adresse' => $request->adresse,
                'lieu_naissance' => $request->lieu_naissance,
                'date_naissance' => $request->date_naissance,
                
            ]);
        }

        // update activite record
        $activite->update([
            'nom_projet'         => $request->nom_projet,
            'adresse_siege'      => $request->adresse,
            'code_postal'        => $request->code_postal,
            'id_statut_inv'      => $request->id_statut_inv,
            'id_nature_activite' => $request->id_nature_activite,
            'id_gouvernorat'     => $request->gouvernorat_id,
            'id_delegation'      => $request->delegation_id ?? $activite->id_delegation,
            'remarques'          => $request->remarques,
            'id_statut'          => $request->id_statut ?? $activite->id_statut,
			'niveau_etude_user'=> $request->niveau_etude_user,
                'dernier_diplome_user'=> $request->dernier_diplome_user,
                'experience_user'=> $request->experience_user,
				'id_user'            => $utilisateur->id,
        ]);

        // replace investments
        $activite->investissements()->delete();
        if ($utilisateur && $request->has('investissements')) {
            foreach ($request->investissements as $inv) {
                Investissement::create([
                    'user_id' => $utilisateur->id,
                    'secteur_invest_id' => $inv['secteur_invest_id'],
                    'montant_inv' => $inv['montant_inv'],
                    'id_source_financement' => $inv['id_source_financement'] ?? null,
                    'montant_fin' => $inv['montant_fin'] ?? null,
                    'id_jeune_enfant' => $activite->id_jeune_enfant,
                ]);
            }
        }

        // history row only if statut changed
        if ($oldStatut !== $newStatut) {
            ImmobilierStatutHistory::create([
                'jeune_enfant_id' => $activite->id_jeune_enfant,
                'from_statut_id'  => $oldStatut ?: null,
                'to_statut_id'    => $newStatut ?: null,
                'changed_by'      => Auth::id() ?? null,
                'commentaire'     => $comment,
            ]);
        }

        DB::commit();

        // ----------------------
        // Notifications: send translation-based DB notification (1,3,4,5)
        // ----------------------
        if ($oldStatut !== $newStatut) {
            try {
                $user = $utilisateur ?? null;

                $mailTypeMap = [
                    1 => 'accepte',
                    3 => 'refuse',
                    4 => 'incomplet',
                    5 => 'deferre',
                ];
                $mailType = $mailTypeMap[$newStatut] ?? 'status_changed';

                $notifyTypeMap = [
                    1 => 'accepted',
                    3 => 'rejected',
                    4 => 'incomplete',
                    5 => 'deferred',
                ];
                $notifyType = $notifyTypeMap[$newStatut] ?? 'status_changed';

                // choose motif/comment (prefer explicit request fields)
                $motif = $request->input('commentaire_refus')
                      ?? $request->input('commentaire_motif')
                      ?? $request->input('commentaire_acceptation')
                      ?? $request->input('commentaire_avis')
                      ?? $comment;

                // translation params
                $translationParams = [];
                if ($notifyType === 'rejected') {
                    $translationParams['reason'] = $motif ?? '';
                } elseif ($notifyType === 'incomplete') {
                    $translationParams['missing'] = $motif ?? '';
                } elseif ($notifyType === 'deferred') {
                    $translationParams['note'] = $motif ?? '';
                } elseif ($notifyType === 'accepted') {
                    $translationParams['reference'] = $activite->id_jeune_enfant;
                }

                if ($user && !empty($user->email)) {
                    // send mail for all supported types (best-effort)
                    try {
                        Mail::to($user->email)->send(
                            new Jeunesse2StatutMail($mailType, $user, $motif)
                        );
                    } catch (\Throwable $mailEx) {
                        \Log::error("update2: Mail failed for activite {$activite->id_jeune_enfant}: " . $mailEx->getMessage());
                    }

                    // database notification
                    try {
                        // pass the activite id as reference
                        $user->notify(new Jeunesse2StatutNotification($notifyType, $translationParams, $activite->id_jeune_enfant));
                    } catch (\Throwable $notifEx) {
                        \Log::error("update2: DB notification failed for activite {$activite->id_jeune_enfant}: " . $notifEx->getMessage());
                    }
                } else {
                    \Log::warning("update2: No user or email for activite ID {$activite->id_jeune_enfant}");
                }
            } catch (\Exception $e) {
                \Log::error("update2: notification/mail error for activite {$activite->id_jeune_enfant}: " . $e->getMessage());
            }
        }

        return redirect()->route('admin.jeunesse2.index')
                        ->with('success', 'تم تحديث النشاط بنجاح ✅');

    } catch (\Exception $e) {
        DB::rollBack();
        \Log::error('update2 error: ' . $e->getMessage(), ['trace' => $e->getTraceAsString(), 'id' => $id]);
        return back()->withErrors(['error' => 'Erreur lors de la mise à jour : '.$e->getMessage()])->withInput();
    }
}


/*
   public function update2(Request $request, $id)
    {
        DB::beginTransaction();
        try {
            $activite = ActiviteJeuneEnfant::with(['investissements.utilisateur', 'investissements'])->findOrFail($id);

            $request->validate([
                // Utilisateur
                'nom_prenom'       => 'required|string|max:255',
                'id_type_identite' => 'required|integer|exists:tp_type_identite_pers,id_type',
                'cin'              => 'nullable|string|max:20',
                'date_delivrance_cin' => 'nullable|date',
                'lieu_delivrance_cin' => 'nullable|string|max:255',
                'passport'         => 'nullable|string|max:50',
                'num_fiscal'       => 'nullable|string|max:50',
                'tel'              => 'nullable|string|max:20',
                'adresse'          => 'required|string|max:255',
                'lieu_naissance'   => 'required|string|max:100',
                'date_naissance'   => 'required|date',
                'niveau_etude'     => 'nullable|string|max:100',
                'dernier_diplome'  => 'nullable|string|max:100',
                'experience'       => 'nullable|string|max:100',

                // Activité
                'nom_projet'         => 'required|string|max:255',
                'code_postal'        => 'required|integer',
                'gouvernorat_id'     => 'required|exists:tp_gouvernorat,id_gouver',
                'delegation_id'      => 'required|exists:tp_delegation,id_delegation',
                'id_statut_inv'      => 'required|exists:tp_statut_inv,id_status',
                'id_nature_activite' => 'required|exists:tp_nature_activite,id_nature_ac',
                'remarques'          => 'nullable|string',
                'id_statut'          => 'nullable',

                // Investissements
                'investissements.*.secteur_invest_id' => 'required|integer|exists:tp_secteur_financement,id_secteur',
                'investissements.*.montant_inv'       => 'required|numeric',
                'investissements.*.id_source_financement' => 'required|integer|exists:tp_source_financement,id_source',
                'investissements.*.montant_fin'           => 'required|numeric',
            ]);

        $oldStatut = (int) ($activite->id_statut ?? 0);
        $newStatut = (int) ($request->input('id_statut') ?? $oldStatut);

        // build comment (prefer explicit fields)
        $comment = null;
        if ($request->filled('commentaire_refus')) {
            $comment = trim($request->input('commentaire_refus'));
        } elseif ($request->filled('commentaire_status')) {
            $comment = trim($request->input('commentaire_status'));
        } elseif ($request->filled('commentaire_motif')) {
            $comment = trim($request->input('commentaire_motif'));
        }
        if ($comment === '') $comment = null;
            $utilisateur = $activite->investissements->first()?->utilisateur;
            if ($utilisateur) {
                $utilisateur->update([
                    'nom_prenom' => $request->nom_prenom,
                    'id_type_identite' => $request->id_type_identite,
                    'cin' => $request->cin,
                    'date_delivrance_cin' => $request->date_delivrance_cin,
                    'lieu_delivrance_cin' => $request->lieu_delivrance_cin,
                    'passport' => $request->passport,
                    'num_fiscal' => $request->num_fiscal,
                    'tel' => $request->tel,
                    'adresse' => $request->adresse,
                    'lieu_naissance' => $request->lieu_naissance,
                    'date_naissance' => $request->date_naissance,
                    'niveau_etude' => $request->niveau_etude,
                    'dernier_diplome' => $request->dernier_diplome,
                    'experience' => $request->experience,
                ]);
            }

            $activite->update([
                'nom_projet'         => $request->nom_projet,
                'adresse_siege'      => $request->adresse,
                'code_postal'        => $request->code_postal,
                'id_statut_inv'      => $request->id_statut_inv,
                'id_nature_activite' => $request->id_nature_activite,
                'id_gouvernorat'     => $request->gouvernorat_id,
                'id_delegation'      => $request->delegation_id ?? $activite->id_delegation,
                'remarques'          => $request->remarques,
                'id_statut'          => $request->id_statut ?? $activite->id_statut,
            ]);

            $activite->investissements()->delete(); 
            if ($utilisateur && $request->has('investissements')) {
                foreach ($request->investissements as $inv) {
                    Investissement::create([
                        'user_id' => $utilisateur->id,
                        'secteur_invest_id' => $inv['secteur_invest_id'],
                        'montant_inv' => $inv['montant_inv'],
                        'id_source_financement' => $inv['id_source_financement'] ?? null,
                        'montant_fin' => $inv['montant_fin'] ?? null,
                        'id_jeune_enfant' => $activite->id_jeune_enfant,
                    ]);
                }
            }
       if ($oldStatut !== $newStatut) {
            ImmobilierStatutHistory::create([
                // link to projet table using correct primary key
                'jeune_enfant_id'     => $activite->id_jeune_enfant,
                'from_statut_id'=> $oldStatut ?: null,
                'to_statut_id'  => $newStatut ?: null,
                'changed_by'    => Auth::id() ?? null,
                'commentaire'   => $comment,
            ]);
        }

            DB::commit();
      // ----------------------
        // Notifications: send translation-based DB notification (4 types)
        // ----------------------
 
			if ($oldStatut !== $newStatut) {
				try {
					$user = $utilisateur ?? null;

					$mailTypeMap = [
						1 => 'accepte',
						3 => 'refuse',
						4 => 'incomplet',
						5 => 'deferre',
					];
					$mailType = $mailTypeMap[$newStatut] ?? 'status_changed';

					$notifyTypeMap = [
						1 => 'accepted',
						3 => 'rejected',
						4 => 'incomplete',
						5 => 'deferred',
					];
					$notifyType = $notifyTypeMap[$newStatut] ?? 'status_changed';

					// choose motif/comment (prefer explicit request fields)
					$motif = $request->input('commentaire_refus')
						  ?? $request->input('commentaire_motif')
						  ?? $request->input('commentaire_acceptation')
						  ?? $request->input('commentaire_avis')
						  ?? $comment;

					// translation params
					$translationParams = [];
					if ($notifyType === 'rejected') {
						$translationParams['reason'] = $motif ?? '';
					} elseif ($notifyType === 'incomplete') {
						$translationParams['missing'] = $motif ?? '';
					} elseif ($notifyType === 'deferred') {
						$translationParams['note'] = $motif ?? '';
					} elseif ($notifyType === 'accepted') {
						// optionally include a reference or date if desired
						$translationParams['reference'] = $projet->id_projet ?? null;
					}

					if ($user && !empty($user->email)) {
						// send mail for all supported types
						try {
							Mail::to($user->email)->send(
								new JeuneEnfantStatutMail($mailType, $user, $motif)
							);
						} catch (\Throwable $mailEx) {
							\Log::error("update2: Mail failed for projet {$projet->id_projet}: " . $mailEx->getMessage());
						}

						// database notification
						try {
							$user->notify(new JeuneEnfantStatutNotification($notifyType, $translationParams, $projet->id_projet));
						} catch (\Throwable $notifEx) {
							\Log::error("update2: DB notification failed for projet {$projet->id_projet}: " . $notifEx->getMessage());
						}
					} else {
						\Log::warning("update2: No user or email for projet ID {$projet->id_projet}");
					}
				} catch (\Exception $e) {
					\Log::error("update2: notification/mail error for projet {$projet->id_projet}: " . $e->getMessage());
				}
			}


            
            return redirect()->route('admin.jeunesse2.index')
                            ->with('success', 'تم تحديث النشاط بنجاح ✅');

        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => 'Erreur lors de la mise à jour : '.$e->getMessage()])
                        ->withInput();
        }
    }
*/
    public function show2($id)
    {
        $activite = ActiviteJeuneEnfant::with(['investissements.utilisateur', 'investissements', 'gouvernorat'])->findOrFail($id);

        $formulaire = TypeFormulaire::find(21);
        $secteurs = SecteurFinancement::all();
        $service_inst = ServiceInstitution::all();
        $source_fin = SourceFinancement::all();
        $nature = NatureActivite::all();
        $statut_inv = StatutInv::all();
        $gouvernorats = Gouvernorat::all();
        $typesIdentite = Identite_personnel::all();
        $statuts = \App\Models\TpStatut::all(); 
        $delegations = [];
        if ($activite->id_gouvernorat) {
            $delegations = Delegation::where('gouver_id', $activite->id_gouvernorat)->get();
        }

        return view('backoffice.investissement.gestion_jeunesse.show2', compact(
            'activite','formulaire','service_inst','secteurs','source_fin',
            'nature','statut_inv','gouvernorats','typesIdentite','delegations', 'statuts'
        ));
    }

public function getDelegations_jeunesse($gouvernoratId)    {      
  $delegations = Delegation::where('gouver_id', $gouvernoratId)->get(); 
  return response()->json($delegations);  
  }

	public function destroy2($id)
{
    DB::beginTransaction();
    try {
        $activite = ActiviteJeuneEnfant::with(['investissements'])->findOrFail($id);

        if ($activite->investissements()->exists()) {
            $activite->investissements()->delete();
        }

        $activite->delete();

        DB::commit();
        return redirect()
            ->route('admin.jeunesse2.index')
            ->with('success', 'تم حذف النشاط بنجاح');

    } catch (\Exception $e) {
        DB::rollBack();
        return back()->withErrors([
            'error' => 'Erreur lors de la suppression : ' . $e->getMessage()
        ]);
    }
}


}