<?php

namespace App\Http\Controllers;

use App\Models\Type;
use Illuminate\Http\Request;

class GuideController extends Controller
{
    public function index()
    {        
        $types = Type::orderBy('id_type', 'desc')->paginate(10);

        return view('backoffice.gestion_menu.index', compact('types'));
    }

    public function create()
    {
        return view('backoffice.gestion_menu.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'type_ar' => 'required|string|max:255',
            'type_fr' => 'nullable|string|max:255',
            'type_en' => 'nullable|string|max:255',
        ]);

        Type::create([
            'type_ar' => $request->type_ar,
            'type_fr' => $request->type_fr,
            'type_en' => $request->type_en,
        ]);

        return redirect()->route('types.index')->with('ok', 'تمت إضافة القائمة بنجاح ✅');
    }

    public function edit($id)
    {
        $type = Type::findOrFail($id);
        return view('backoffice.gestion_menu.edit', compact('type'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'type_ar' => 'required|string|max:255',
            'type_fr' => 'nullable|string|max:255',
            'type_en' => 'nullable|string|max:255',
        ]);

        $type = Type::findOrFail($id);

        $type->update([
            'type_ar' => $request->type_ar,
            'type_fr' => $request->type_fr,
            'type_en' => $request->type_en,
        ]);

        return redirect()->route('types.index')->with('ok', 'تم تعديل القائمة بنجاح ✅');
    }

    public function destroy($id)
    {
        $type = Type::findOrFail($id);
        $type->delete();

        return redirect()->route('types.index')->with('ok', 'تم حذف القائمة بنجاح ❌');
    }


}
