<?php

namespace App\Http\Controllers;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Mail\AccountConfirmationMail;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\Utilisateur;
use App\Models\Identite_personnel;
use App\Models\Role;
use App\Mail\ResetPasswordMail;

class AuthController extends Controller
{
    public function loginFormadmin() {
        return view('backoffice.authentification.signin');
    }

    public function login_admin(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'mdp'   => 'required|string',
        ]);

        $user = Utilisateur::where('email', $request->email)->first();

        if (!$user || !Hash::check($request->mdp, $user->mdp)) {
            return back()->withErrors(['email' => ' البريد الإلكتروني أو كلمة المرور غير صحيحة']);
        }

        if (!$user->est_active) {
            return back()->withErrors(['email' => '⛔ حسابك غير مفعل.']);
        }

         $hasRole2or3 = $user->roles()->whereIn('id_roles', [2, 3])->exists();

        if ($hasRole2or3) {
            return back()->withErrors(['email' => '⛔ لا يمكنك الدخول من لوحة الإدارة.']);
        }
        
        Auth::guard('admin')->login($user, $request->has('remember'));
        return redirect()->route('admin.dashboard');
    }

    public function logout_admin()
    {
        Auth::guard('admin')->logout();
        request()->session()->invalidate();
        request()->session()->regenerateToken();
        return redirect()->route('login');
    }

        public function setMdpForm(Utilisateur $utilisateur)
    {
        return view('backoffice.authentification.password.set-password', compact('utilisateur'));
    }

    public function setMdp(Request $request, Utilisateur $utilisateur)
    {
        $request->validate([
            'mdp' => 'required|string|min:6|confirmed',
            'token' => 'required',
            'email' => 'required|email',
        ]);

        $reset = \DB::table('password_resets')
        ->where('email', $request->email)
        ->first();

        if (!$reset || !Hash::check($request->token, $reset->token)) {
            return back()->withErrors(['email' => 'الرابط غير صالح أو منتهي.']);
        }

        $utilisateur->mdp = Hash::make($request->mdp);
        $utilisateur->save();

        \DB::table('password_resets')->where('email', $request->email)->delete();

        return redirect()->route('login')->with('success', 'تم تعيين كلمة المرور بنجاح.');
    }

    public function showForgotPasswordForm()
    {
        return view('backoffice.authentification.password.forgot-password');
    }

    /*public function sendResetLinkEmail(Request $request)
    {
        $request->validate([
            'email' => 'required|email|exists:utilisateur,email',
        ], [
            'email.exists' => 'هذا البريد غير موجود في سجلاتنا.',
        ]);

        $token = Str::random(60);

        \DB::table('password_resets')->updateOrInsert(
            ['email' => $request->email],
            [
                'email' => $request->email,
                'token' => Hash::make($token),
                'created_at' => Carbon::now()
            ]
        );

        $user = Utilisateur::where('email', $request->email)->first();

        $resetLink = route('admin.password.reset', $user->id) . '?token=' . $token . '&email=' . $user->email;

        Mail::to($request->email)->send(new ResetPasswordMail($user, $resetLink));

        return back()->with('status', 'تم إرسال رابط إعادة تعيين كلمة المرور إلى بريدك الإلكتروني.');
    }*/
	
	public function sendResetLinkEmail(Request $request)
{
    $request->validate([
    'email' => 'required|email',
	], [
		'email.required' => '⚠ الرجاء إدخال البريد الإلكتروني',
		'email.email'    => '⚠ البريد الإلكتروني غير صالح',
	]);

    $user = Utilisateur::where('email', $request->email)
        ->whereDoesntHave('roles', function ($query) {
            $query->whereIn('id_roles', [2, 3]);
        })
        ->first();

    if (!$user) {
        return back()->with('error', 'لا يمكن إرسال رابط إعادة التعيين لهذا الحساب.');
    }

    $token = Str::random(60);

    \DB::table('password_resets')->updateOrInsert(
        ['email' => $user->email],
        [
            'email' => $user->email,
            'token' => Hash::make($token),
            'created_at' => now()
        ]
    );

    $resetLink = route('admin.password.reset', $user->id)
        . '?token=' . $token
        . '&email=' . urlencode($user->email);

    Mail::to($user->email)->send(
        new ResetPasswordMail($user, $resetLink)
    );

    return back()->with('status', 'تم إرسال رابط إعادة تعيين كلمة المرور إلى بريدك الإلكتروني.');
}



}
