<?php

namespace App\Exports;

use App\Models\Immobilier;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class SallesSportExport implements FromCollection, WithHeadings, WithMapping
{
    public function collection()
    {
        return Immobilier::with(['utilisateur', 'statut'])
            ->where('id_type_formulaire', 1)
            ->latest()
            ->get();
    }

    public function headings(): array
    {
        return [
            'المعرف',
            'تاريخ الإيداع',
            'إسم مقدم الطلب',
            'وضعية الطلب',
        ];
    }

    public function map($salle): array
    {
        return [
            $salle->id_imm,
            $salle->created_at->format('Y-m-d H:i'),
            $salle->utilisateur->nom_prenom ?? '---',
            $salle->statut->statut_ar ?? 'في الانتظار',
        ];
    }
}
