<?php

namespace App\Exports;

use App\Models\ProjetDivertissementJeuneEnfant;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class JeuneEnfantExport implements FromCollection, WithHeadings, WithMapping
{
    protected $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $query = ProjetDivertissementJeuneEnfant::with([
            'statut',
            'natureProjet',
            'investissements.utilisateur'
        ]);

        /** نفس فلاتر index **/
        if ($this->request->search_option === 'nom' && $this->request->filled('nom')) {
            $query->whereHas('investissements.utilisateur', function ($q) {
                $q->where('nom_prenom', 'LIKE', '%' . trim($this->request->nom) . '%');
            });
        }

        if ($this->request->search_option === 'nature' && $this->request->filled('nature')) {
            $query->where('id_nature', $this->request->nature);
        }

        return $query->latest()->get();
    }

    public function headings(): array
    {
        return [
            'المعرف',
            'تاريخ الإيداع',
            'الاسم و اللقب',
            'طبيعة المشروع',
            'وضعية الطلب',
        ];
    }

    public function map($projet): array
    {
        return [
            $projet->id_projet,
            $projet->created_at->format('Y-m-d H:i'),
            $projet->investissements->first()?->utilisateur?->nom_prenom ?? '---',
            $projet->natureProjet?->nature_ar ?? '---',
            $projet->statut?->statut_ar ?? 'في الانتظار',
        ];
    }
}
